/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.setup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.montoyo.mcef.setup.CfgParser;

public class ConfigForm
implements ActionListener,
WindowListener {
    private CfgParser config;
    private JFrame parent;
    private JFrame frame;
    private JPanel contentPane;
    private JPanel cMainPane;
    private JTextField cMainForcedMirror;
    private JCheckBox cMainSkipUpdates;
    private JCheckBox cMainForgeSplash;
    private JCheckBox cMainWarnUpdates;
    private JPanel cBrowserPane;
    private JCheckBox cBrowserEnable;
    private JTextField cBrowserHome;
    private JPanel btnPane;
    private JButton btnOk;
    private JButton btnBack;
    private JButton btnApply;

    public ConfigForm(JFrame p, File cfgFile) {
        this.config = new CfgParser(cfgFile);
        this.parent = p;
        this.config.load();
        this.frame = new JFrame("MCEF Setup - Configuration (does not save yet)");
        this.frame.setMinimumSize(new Dimension(500, 1));
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.contentPane.setLayout(new GridBagLayout());
        this.cMainPane = new JPanel();
        this.cMainPane.setBorder(new TitledBorder("Main"));
        this.cMainPane.setLayout(new GridBagLayout());
        this.cMainForcedMirror = new JTextField();
        this.cMainSkipUpdates = new JCheckBox();
        this.cMainForgeSplash = new JCheckBox();
        this.cMainWarnUpdates = new JCheckBox();
        this.addFormComponent(this.cMainPane, 0, "Forced mirror", this.cMainForcedMirror);
        this.addFormComponent(this.cMainPane, 1, "Skip updates", this.cMainSkipUpdates);
        this.addFormComponent(this.cMainPane, 2, "Use forge splash", this.cMainForgeSplash);
        this.addFormComponent(this.cMainPane, 3, "Warn updates", this.cMainWarnUpdates);
        this.cMainForcedMirror.setText(this.config.getStringValue("main", "forcedMirror", ""));
        this.cMainSkipUpdates.setSelected(this.config.getBooleanValue("main", "skipUpdates", false));
        this.cMainForgeSplash.setSelected(this.config.getBooleanValue("main", "useForgeSplash", true));
        this.cMainWarnUpdates.setSelected(this.config.getBooleanValue("main", "warnUpdates", true));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 4;
        c.fill = 3;
        c.weighty = 1.0;
        this.cMainPane.add(Box.createVerticalGlue(), c);
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        this.contentPane.add((Component)this.cMainPane, c);
        this.cBrowserPane = new JPanel();
        this.cBrowserPane.setBorder(new TitledBorder("Browser"));
        this.cBrowserPane.setLayout(new GridBagLayout());
        this.cBrowserEnable = new JCheckBox();
        this.cBrowserHome = new JTextField();
        this.addFormComponent(this.cBrowserPane, 0, "Enable", this.cBrowserEnable);
        this.addFormComponent(this.cBrowserPane, 1, "Home page", this.cBrowserHome);
        this.cBrowserEnable.setSelected(this.config.getBooleanValue("examplebrowser", "enable", true));
        this.cBrowserHome.setText(this.config.getStringValue("examplebrowser", "home", "mod://mcef/home.html"));
        c = new GridBagConstraints();
        c.gridy = 2;
        c.fill = 3;
        c.weighty = 1.0;
        this.cBrowserPane.add(Box.createVerticalGlue(), c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        this.contentPane.add((Component)this.cBrowserPane, c);
        this.btnPane = new JPanel();
        this.btnPane.setLayout(new GridBagLayout());
        this.btnOk = new JButton("Ok");
        this.btnBack = new JButton("Back");
        this.btnApply = new JButton("Apply");
        this.btnOk.addActionListener(this);
        this.btnBack.addActionListener(this);
        this.btnApply.addActionListener(this);
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        this.btnPane.add(Box.createHorizontalGlue(), c);
        this.addFormButton(1, this.btnOk);
        this.addFormButton(2, this.btnBack);
        this.addFormButton(3, this.btnApply);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.contentPane.add((Component)this.btnPane, c);
        this.frame.setContentPane(this.contentPane);
        this.frame.pack();
        this.parent.setVisible(false);
        this.frame.setVisible(true);
    }

    private void addFormComponent(JPanel pane, int line, String label, Component comp) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 3, 3, 3);
        c.fill = 2;
        c.gridy = line;
        pane.add((Component)new JLabel(label), c);
        c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 3, 3);
        c.gridx = 1;
        c.gridy = line;
        c.fill = 2;
        c.weightx = 1.0;
        pane.add(comp, c);
    }

    private void addFormButton(int x, JButton btn) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 3, 3);
        c.gridx = x;
        this.btnPane.add((Component)btn, c);
    }

    private void saveChanges() {
        this.config.setStringValue("main", "forcedMirror", this.cMainForcedMirror.getText());
        this.config.setBooleanValue("main", "skipUpdates", this.cMainSkipUpdates.isSelected());
        this.config.setBooleanValue("main", "useForgeSplash", this.cMainForgeSplash.isSelected());
        this.config.setBooleanValue("main", "warnUpdates", this.cMainWarnUpdates.isSelected());
        this.config.setBooleanValue("examplebrowser", "enable", this.cBrowserEnable.isSelected());
        this.config.setStringValue("examplebrowser", "home", this.cBrowserHome.getText());
        if (!this.config.save()) {
            JOptionPane.showMessageDialog(this.frame, "Could not save configuration file.\nMake sure you have the permissions to write in the config folder.", "Error", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnBack) {
            this.windowClosing(null);
        } else if (e.getSource() == this.btnApply) {
            this.saveChanges();
        } else if (e.getSource() == this.btnOk) {
            this.saveChanges();
            this.windowClosing(null);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.parent.setVisible(true);
        this.frame.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

