/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.utilities;

import net.montoyo.mcef.utilities.Log;

public class Version {
    private int[] numbers;

    public Version(String v) {
        int end;
        String[] ray = v.trim().split("\\.");
        this.numbers = new int[ray.length];
        for (int i = 0; i < ray.length; ++i) {
            try {
                this.numbers[i] = Integer.parseInt(ray[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Log.error("Couldn't parse %s. Number %d will be zero.", v, i);
                e.printStackTrace();
                this.numbers[i] = 0;
            }
        }
        for (end = this.numbers.length - 1; end >= 0 && this.numbers[end] == 0; --end) {
        }
        if (++end != this.numbers.length) {
            int[] na = new int[end];
            System.arraycopy(this.numbers, 0, na, 0, end);
            this.numbers = na;
        }
    }

    public boolean isBiggerThan(Version v) {
        int len = Math.min(this.numbers.length, v.numbers.length);
        for (int i = 0; i < len; ++i) {
            if (this.numbers[i] <= v.numbers[i]) continue;
            return true;
        }
        return this.numbers.length > v.numbers.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version v = (Version)o;
        if (v == this) {
            return true;
        }
        if (this.numbers.length != v.numbers.length) {
            return false;
        }
        for (int i = 0; i < this.numbers.length; ++i) {
            if (this.numbers[i] == v.numbers[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Object ret = "";
        for (int i = 0; i < this.numbers.length; ++i) {
            if (i > 0) {
                ret = (String)ret + ".";
            }
            ret = (String)ret + this.numbers[i];
        }
        return ret;
    }
}

