/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.renderer.GameRenderer;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.utilities.Log;
import org.lwjgl.opengl.GL11;

public class CefRenderer {
    private static final ArrayList<Integer> GL_TEXTURES = new ArrayList();
    private boolean transparent_;
    public int[] texture_id_ = new int[1];
    private int view_width_ = 0;
    private int view_height_ = 0;
    private float spin_x_ = 0.0f;
    private float spin_y_ = 0.0f;
    private Rectangle popup_rect_ = new Rectangle(0, 0, 0, 0);
    private Rectangle original_popup_rect_ = new Rectangle(0, 0, 0, 0);
    private boolean use_draw_pixels_ = false;

    public static void dumpVRAMLeak() {
        Log.info(">>>>> MCEF: Beginning VRAM leak report", new Object[0]);
        GL_TEXTURES.forEach(tex -> Log.warning(">>>>> MCEF: This texture has not been freed: " + tex, new Object[0]));
        Log.info(">>>>> MCEF: End of VRAM leak report", new Object[0]);
    }

    protected CefRenderer(boolean transparent) {
        this.transparent_ = transparent;
        this.initialize();
    }

    protected boolean isTransparent() {
        return this.transparent_;
    }

    protected int getTextureID() {
        return this.texture_id_[0];
    }

    protected void initialize() {
        GlStateManager.m_84109_();
        this.texture_id_[0] = GlStateManager.m_84111_();
        if (MCEF.CHECK_VRAM_LEAK) {
            GL_TEXTURES.add(this.texture_id_[0]);
        }
        GlStateManager.m_84544_((int)this.texture_id_[0]);
        GlStateManager.m_84331_((int)3553, (int)10241, (int)9729);
        GlStateManager.m_84331_((int)3553, (int)10240, (int)9729);
        GlStateManager.m_84544_((int)0);
    }

    protected void cleanup() {
        if (this.texture_id_[0] != 0) {
            if (MCEF.CHECK_VRAM_LEAK) {
                GL_TEXTURES.remove((Object)this.texture_id_[0]);
            }
            GlStateManager.m_84541_((int)this.texture_id_[0]);
        }
    }

    protected void render(PoseStack matrix, double x1, double y1, double x2, double y2) {
        Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder vb = t.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157453_((int)0, (int)this.texture_id_[0]);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        vb.m_85982_(positionMatrix, (float)x1, (float)y1, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        vb.m_85982_(positionMatrix, (float)x2, (float)y1, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        vb.m_85982_(positionMatrix, (float)x2, (float)y2, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        vb.m_85982_(positionMatrix, (float)x1, (float)y2, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        t.m_85914_();
    }

    protected void onPopupSize(Rectangle rect) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        this.original_popup_rect_ = rect;
        this.popup_rect_ = this.getPopupRectInWebView(this.original_popup_rect_);
    }

    protected Rectangle getPopupRect() {
        return (Rectangle)this.popup_rect_.clone();
    }

    protected Rectangle getPopupRectInWebView(Rectangle original_rect) {
        Rectangle rc = original_rect;
        if (rc.x < 0) {
            rc.x = 0;
        }
        if (rc.y < 0) {
            rc.y = 0;
        }
        if (rc.x + rc.width > this.view_width_) {
            rc.x = this.view_width_ - rc.width;
        }
        if (rc.y + rc.height > this.view_height_) {
            rc.y = this.view_height_ - rc.height;
        }
        if (rc.x < 0) {
            rc.x = 0;
        }
        if (rc.y < 0) {
            rc.y = 0;
        }
        return rc;
    }

    protected void clearPopupRects() {
        this.popup_rect_.setBounds(0, 0, 0, 0);
        this.original_popup_rect_.setBounds(0, 0, 0, 0);
    }

    protected void onPaint(boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height, boolean completeReRender) {
        int size;
        if (this.transparent_) {
            GlStateManager.m_84525_();
        }
        if ((size = width * height << 2) > buffer.limit()) {
            Log.warning("Bad data passed to CefRenderer.onPaint() triggered safe guards... (1)", new Object[0]);
            return;
        }
        GlStateManager.m_84109_();
        GlStateManager.m_84544_((int)this.texture_id_[0]);
        int oldAlignement = GlStateManager.m_84092_((int)3317);
        GlStateManager.m_84522_((int)3317, (int)1);
        if (!popup) {
            if (completeReRender || width != this.view_width_ || height != this.view_height_) {
                this.view_width_ = width;
                this.view_height_ = height;
                System.out.println("going to glTexImage2D " + width + " " + height + " " + buffer.limit());
                GlStateManager.m_84522_((int)3316, (int)0);
                GlStateManager.m_84522_((int)3315, (int)0);
                GlStateManager.m_84209_((int)3553, (int)0, (int)6408, (int)this.view_width_, (int)this.view_height_, (int)0, (int)32993, (int)5121, (IntBuffer)buffer.asIntBuffer());
            } else {
                GlStateManager.m_84522_((int)3314, (int)this.view_width_);
                for (Rectangle rect : dirtyRects) {
                    if (rect.x < 0 || rect.y < 0 || rect.x + rect.width > this.view_width_ || rect.y + rect.height > this.view_height_) {
                        Log.warning("Bad data passed to CefRenderer.onPaint() triggered safe guards... (2)", new Object[0]);
                        continue;
                    }
                    GlStateManager.m_84522_((int)3316, (int)rect.x);
                    GlStateManager.m_84522_((int)3315, (int)rect.y);
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, (int)32993, (int)5121, (ByteBuffer)buffer);
                }
                GlStateManager.m_84522_((int)3316, (int)0);
                GlStateManager.m_84522_((int)3315, (int)0);
                GlStateManager.m_84522_((int)3314, (int)0);
            }
        } else if (this.popup_rect_.width > 0 && this.popup_rect_.height > 0) {
            System.out.println("Processing popup");
            int skip_pixels = 0;
            int x = this.popup_rect_.x;
            int skip_rows = 0;
            int y = this.popup_rect_.y;
            int w = width;
            int h = height;
            if (x < 0) {
                skip_pixels = -x;
                x = 0;
            }
            if (y < 0) {
                skip_rows = -y;
                y = 0;
            }
            if (x + w > this.view_width_) {
                w -= x + w - this.view_width_;
            }
            if (y + h > this.view_height_) {
                h -= y + h - this.view_height_;
            }
            GlStateManager.m_84522_((int)3314, (int)width);
            GlStateManager.m_84522_((int)3316, (int)skip_pixels);
            GlStateManager.m_84522_((int)3315, (int)skip_rows);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)x, (int)y, (int)w, (int)h, (int)32993, (int)5121, (ByteBuffer)buffer);
            GlStateManager.m_84522_((int)3314, (int)0);
            GlStateManager.m_84522_((int)3316, (int)0);
            GlStateManager.m_84522_((int)3315, (int)0);
        }
        GlStateManager.m_84522_((int)3317, (int)oldAlignement);
        GlStateManager.m_84544_((int)0);
    }

    protected void setSpin(float spinX, float spinY) {
        this.spin_x_ = spinX;
        this.spin_y_ = spinY;
    }

    protected void incrementSpin(float spinDX, float spinDY) {
        this.spin_x_ -= spinDX;
        this.spin_y_ -= spinDY;
    }
}

