/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.DynamicComponent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class NixieTubeTileEntity
extends SmartTileEntity {
    private static final Couple<String> EMPTY = Couple.create("", "");
    private int redstoneStrength = 0;
    private Optional<DynamicComponent> customText = Optional.empty();
    private int nixieIndex;
    private Couple<String> displayedStrings;
    private WeakReference<SignalTileEntity> cachedSignalTE = new WeakReference<Object>(null);
    public SignalTileEntity.SignalState signalState;

    public NixieTubeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            return;
        }
        this.signalState = null;
        SignalTileEntity signalTileEntity = (SignalTileEntity)this.cachedSignalTE.get();
        if (signalTileEntity == null || signalTileEntity.m_58901_()) {
            Direction facing = NixieTubeBlock.getFacing(this.m_58900_());
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing.m_122424_()));
            if (blockEntity instanceof SignalTileEntity) {
                SignalTileEntity signal = (SignalTileEntity)blockEntity;
                this.signalState = signal.getState();
                this.cachedSignalTE = new WeakReference<SignalTileEntity>(signal);
            }
            return;
        }
        this.signalState = signalTileEntity.getState();
    }

    @Override
    public void initialize() {
        if (this.f_58857_.f_46443_) {
            this.updateDisplayedStrings();
        }
    }

    public boolean reactsToRedstone() {
        return this.customText.isEmpty();
    }

    public Couple<String> getDisplayedStrings() {
        if (this.displayedStrings == null) {
            return EMPTY;
        }
        return this.displayedStrings;
    }

    public MutableComponent getFullText() {
        return this.customText.map(DynamicComponent::get).orElse(Components.literal("" + this.redstoneStrength));
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.clearCustomText();
        this.redstoneStrength = signalStrength;
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, this.f_58858_);
        this.notifyUpdate();
    }

    public void displayCustomText(String tagElement, int nixiePositionInRow) {
        if (tagElement == null) {
            return;
        }
        if (this.customText.filter(d -> d.sameAs(tagElement)).isPresent()) {
            return;
        }
        DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
        component.displayCustomText(this.f_58857_, this.f_58858_, tagElement);
        this.customText = Optional.of(component);
        this.nixieIndex = nixiePositionInRow;
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, this.f_58858_);
        this.notifyUpdate();
    }

    public void updateDisplayedStrings() {
        if (this.signalState != null) {
            return;
        }
        this.customText.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.displayedStrings = Couple.create(this.charOrEmpty((String)fullText, this.nixieIndex * 2), this.charOrEmpty((String)fullText, this.nixieIndex * 2 + 1));
        }, () -> {
            this.displayedStrings = Couple.create(this.redstoneStrength < 10 ? "0" : "1", String.valueOf(this.redstoneStrength % 10));
        });
    }

    public void clearCustomText() {
        this.nixieIndex = 0;
        this.customText = Optional.empty();
    }

    @Override
    protected void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.m_128441_("CustomText")) {
            DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
            component.read(this.f_58857_, this.f_58858_, nbt);
            if (component.isValid()) {
                this.customText = Optional.of(component);
                this.nixieIndex = nbt.m_128451_("CustomTextIndex");
            } else {
                this.customText = Optional.empty();
                this.nixieIndex = 0;
            }
        }
        if (this.customText.isEmpty()) {
            this.redstoneStrength = nbt.m_128451_("RedstoneStrength");
        }
        if (clientPacket) {
            this.updateDisplayedStrings();
        }
    }

    @Override
    protected void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.customText.isPresent()) {
            nbt.m_128405_("CustomTextIndex", this.nixieIndex);
            this.customText.get().write(nbt);
        } else {
            nbt.m_128405_("RedstoneStrength", this.redstoneStrength);
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

