/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractSimpleShaftBlock;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.MaterialChecklist;
import com.simibubi.create.content.schematics.SchematicPrinter;
import com.simibubi.create.content.schematics.block.LaunchedItem;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonInventory;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CSchematics;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class SchematicannonTileEntity
extends SmartTileEntity
implements MenuProvider {
    public static final int NEIGHBOUR_CHECKING = 100;
    public static final int MAX_ANCHOR_DISTANCE = 256;
    public SchematicannonInventory inventory;
    public boolean sendUpdate;
    public boolean dontUpdateChecklist;
    public int neighbourCheckCooldown;
    public SchematicPrinter printer;
    public ItemStack missingItem;
    public boolean positionNotLoaded;
    public boolean hasCreativeCrate;
    private int printerCooldown;
    private int skipsLeft;
    private boolean blockSkipped;
    public BlockPos previousTarget;
    public LinkedHashSet<LazyOptional<IItemHandler>> attachedInventories;
    public List<LaunchedItem> flyingBlocks;
    public MaterialChecklist checklist;
    public float fuelLevel;
    public float bookPrintingProgress;
    public float schematicProgress;
    public String statusMsg;
    public State state;
    public int blocksPlaced;
    public int blocksToPlace;
    public int replaceMode;
    public boolean skipMissing;
    public boolean replaceTileEntities;
    public boolean firstRenderTick;
    public float defaultYaw;

    public SchematicannonTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(30);
        this.attachedInventories = new LinkedHashSet();
        this.flyingBlocks = new LinkedList<LaunchedItem>();
        this.inventory = new SchematicannonInventory(this);
        this.statusMsg = "idle";
        this.state = State.STOPPED;
        this.replaceMode = 2;
        this.checklist = new MaterialChecklist();
        this.printer = new SchematicPrinter();
    }

    public void findInventories() {
        this.hasCreativeCrate = false;
        this.attachedInventories.clear();
        for (Direction facing : Iterate.directions) {
            LazyOptional capability;
            BlockEntity tileEntity;
            if (!this.f_58857_.m_46749_(this.f_58858_.m_142300_(facing))) continue;
            if (AllBlocks.CREATIVE_CRATE.has(this.f_58857_.m_8055_(this.f_58858_.m_142300_(facing)))) {
                this.hasCreativeCrate = true;
            }
            if ((tileEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing))) == null || !(capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.m_122424_())).isPresent()) continue;
            this.attachedInventories.add((LazyOptional<IItemHandler>)capability);
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        }
        this.statusMsg = compound.m_128461_("Status");
        this.schematicProgress = compound.m_128457_("Progress");
        this.bookPrintingProgress = compound.m_128457_("PaperProgress");
        this.fuelLevel = compound.m_128457_("Fuel");
        this.state = State.valueOf(compound.m_128461_("State"));
        this.blocksPlaced = compound.m_128451_("AmountPlaced");
        this.blocksToPlace = compound.m_128451_("AmountToPlace");
        this.missingItem = null;
        if (compound.m_128441_("MissingItem")) {
            this.missingItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("MissingItem"));
        }
        CompoundTag options = compound.m_128469_("Options");
        this.replaceMode = options.m_128451_("ReplaceMode");
        this.skipMissing = options.m_128471_("SkipMissing");
        this.replaceTileEntities = options.m_128471_("ReplaceTileEntities");
        if (compound.m_128441_("Printer")) {
            this.printer.fromTag(compound.m_128469_("Printer"), clientPacket);
        }
        if (compound.m_128441_("FlyingBlocks")) {
            this.readFlyingBlocks(compound);
        }
        this.defaultYaw = compound.m_128457_("DefaultYaw");
        super.read(compound, clientPacket);
    }

    protected void readFlyingBlocks(CompoundTag compound) {
        ListTag tagBlocks = compound.m_128437_("FlyingBlocks", 10);
        if (tagBlocks.isEmpty()) {
            this.flyingBlocks.clear();
        }
        boolean pastDead = false;
        for (int i = 0; i < tagBlocks.size(); ++i) {
            CompoundTag c = tagBlocks.m_128728_(i);
            LaunchedItem launched = LaunchedItem.fromNBT(c);
            BlockPos readBlockPos = launched.target;
            if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
                this.flyingBlocks.add(launched);
                continue;
            }
            while (!(pastDead || this.flyingBlocks.isEmpty() || this.flyingBlocks.get((int)0).target.equals((Object)readBlockPos))) {
                this.flyingBlocks.remove(0);
            }
            pastDead = true;
            if (i < this.flyingBlocks.size()) continue;
            this.flyingBlocks.add(launched);
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (!clientPacket) {
            compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
            if (this.state == State.RUNNING) {
                compound.m_128379_("Running", true);
            }
        }
        compound.m_128350_("Progress", this.schematicProgress);
        compound.m_128350_("PaperProgress", this.bookPrintingProgress);
        compound.m_128350_("Fuel", this.fuelLevel);
        compound.m_128359_("Status", this.statusMsg);
        compound.m_128359_("State", this.state.name());
        compound.m_128405_("AmountPlaced", this.blocksPlaced);
        compound.m_128405_("AmountToPlace", this.blocksToPlace);
        if (this.missingItem != null) {
            compound.m_128365_("MissingItem", (Tag)this.missingItem.serializeNBT());
        }
        CompoundTag options = new CompoundTag();
        options.m_128405_("ReplaceMode", this.replaceMode);
        options.m_128379_("SkipMissing", this.skipMissing);
        options.m_128379_("ReplaceTileEntities", this.replaceTileEntities);
        compound.m_128365_("Options", (Tag)options);
        CompoundTag printerData = new CompoundTag();
        this.printer.write(printerData);
        compound.m_128365_("Printer", (Tag)printerData);
        ListTag tagFlyingBlocks = new ListTag();
        for (LaunchedItem b : this.flyingBlocks) {
            tagFlyingBlocks.add((Object)b.serializeNBT());
        }
        compound.m_128365_("FlyingBlocks", (Tag)tagFlyingBlocks);
        compound.m_128350_("DefaultYaw", this.defaultYaw);
        super.write(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.state != State.STOPPED && this.neighbourCheckCooldown-- <= 0) {
            this.neighbourCheckCooldown = 100;
            this.findInventories();
        }
        this.firstRenderTick = true;
        this.previousTarget = this.printer.getCurrentTarget();
        this.tickFlyingBlocks();
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.tickPaperPrinter();
        this.refillFuelIfPossible();
        this.skipsLeft = (Integer)this.config().schematicannonSkips.get();
        this.blockSkipped = true;
        while (this.blockSkipped && this.skipsLeft-- > 0) {
            this.tickPrinter();
        }
        this.schematicProgress = 0.0f;
        if (this.blocksToPlace > 0) {
            this.schematicProgress = (float)this.blocksPlaced / (float)this.blocksToPlace;
        }
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 6);
        }
    }

    public CSchematics config() {
        return AllConfigs.SERVER.schematics;
    }

    protected void tickPrinter() {
        ItemRequirement requirement;
        ItemStack blueprint = this.inventory.getStackInSlot(0);
        this.blockSkipped = false;
        if (this.state == State.STOPPED) {
            if (this.printer.isLoaded()) {
                this.resetPrinter();
            }
            return;
        }
        if (blueprint.m_41619_()) {
            this.state = State.STOPPED;
            this.statusMsg = "idle";
            this.sendUpdate = true;
            return;
        }
        if (this.state == State.PAUSED && !this.positionNotLoaded && this.missingItem == null && (double)this.fuelLevel > this.getFuelUsageRate()) {
            return;
        }
        if (!this.printer.isLoaded()) {
            this.initializePrinter(blueprint);
            return;
        }
        if (this.printerCooldown > 0) {
            --this.printerCooldown;
            return;
        }
        if (this.fuelLevel <= 0.0f && !this.hasCreativeCrate) {
            this.fuelLevel = 0.0f;
            this.state = State.PAUSED;
            this.statusMsg = "noGunpowder";
            this.sendUpdate = true;
            return;
        }
        if (this.hasCreativeCrate && this.missingItem != null) {
            this.missingItem = null;
            this.state = State.RUNNING;
        }
        if (this.missingItem == null && !this.positionNotLoaded) {
            if (!this.printer.advanceCurrentPos()) {
                this.finishedPrinting();
                return;
            }
            this.sendUpdate = true;
        }
        if (!this.m_58904_().m_46749_(this.printer.getCurrentTarget())) {
            this.positionNotLoaded = true;
            this.statusMsg = "targetNotLoaded";
            this.state = State.PAUSED;
            return;
        }
        if (this.positionNotLoaded) {
            this.positionNotLoaded = false;
            this.state = State.RUNNING;
        }
        if ((requirement = this.printer.getCurrentRequirement()).isInvalid() || !this.printer.shouldPlaceCurrent(this.f_58857_, this::shouldPlace)) {
            this.statusMsg = "searching";
            this.blockSkipped = true;
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        if (!requirement.isEmpty()) {
            for (ItemRequirement.StackRequirement required : requiredItems) {
                if (this.grabItemsFromAttachedInventories(required, true)) continue;
                if (this.skipMissing) {
                    this.statusMsg = "skipping";
                    this.blockSkipped = true;
                    if (this.missingItem != null) {
                        this.missingItem = null;
                        this.state = State.RUNNING;
                    }
                    return;
                }
                this.missingItem = required.stack;
                this.state = State.PAUSED;
                this.statusMsg = "missingBlock";
                return;
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                this.grabItemsFromAttachedInventories(required, false);
            }
        }
        this.state = State.RUNNING;
        ItemStack icon = requirement.isEmpty() || requiredItems.isEmpty() ? ItemStack.f_41583_ : requiredItems.get((int)0).stack;
        this.printer.handleCurrentTarget((target, blockState, tile) -> {
            this.statusMsg = blockState.m_60734_() != Blocks.f_50016_ ? "placing" : "clearing";
            this.launchBlockOrBelt(target, icon, blockState, tile);
        }, (target, entity) -> {
            this.statusMsg = "placing";
            this.launchEntity(target, icon, entity);
        });
        this.printerCooldown = (Integer)this.config().schematicannonDelay.get();
        this.fuelLevel = (float)((double)this.fuelLevel - this.getFuelUsageRate());
        this.sendUpdate = true;
        this.missingItem = null;
    }

    public double getFuelUsageRate() {
        return this.hasCreativeCrate ? 0.0 : (Double)this.config().schematicannonFuelUsage.get() / 100.0;
    }

    protected void initializePrinter(ItemStack blueprint) {
        if (!blueprint.m_41782_()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicInvalid";
            this.sendUpdate = true;
            return;
        }
        if (!blueprint.m_41783_().m_128471_("Deployed")) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicNotPlaced";
            this.sendUpdate = true;
            return;
        }
        this.printer.loadSchematic(blueprint, this.f_58857_, true);
        if (this.printer.isWorldEmpty()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicExpired";
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            this.inventory.setStackInSlot(1, new ItemStack((ItemLike)AllItems.EMPTY_SCHEMATIC.get()));
            this.printer.resetSchematic();
            return;
        }
        if (!this.printer.getAnchor().m_123314_((Vec3i)this.m_58899_(), 256.0)) {
            this.state = State.STOPPED;
            this.statusMsg = "targetOutsideRange";
            this.printer.resetSchematic();
            return;
        }
        this.state = State.PAUSED;
        this.statusMsg = "ready";
        this.updateChecklist();
        this.sendUpdate = true;
        this.blocksToPlace += this.blocksPlaced;
    }

    protected ItemStack getItemForBlock(BlockState blockState) {
        Item item = BlockItem.f_41373_.getOrDefault(blockState.m_60734_(), Items.f_41852_);
        return item == Items.f_41852_ ? ItemStack.f_41583_ : new ItemStack((ItemLike)item);
    }

    protected boolean grabItemsFromAttachedInventories(ItemRequirement.StackRequirement required, boolean simulate) {
        IItemHandler iItemHandler;
        if (this.hasCreativeCrate) {
            return true;
        }
        this.attachedInventories.removeIf(cap -> !cap.isPresent());
        ItemRequirement.ItemUseType usage = required.usage;
        if (usage == ItemRequirement.ItemUseType.DAMAGE) {
            for (LazyOptional lazyOptional : this.attachedInventories) {
                IItemHandler iItemHandler2 = (IItemHandler)lazyOptional.orElse((Object)EmptyHandler.INSTANCE);
                for (int i = 0; i < iItemHandler2.getSlots(); ++i) {
                    ItemStack extractItem = iItemHandler2.extractItem(i, 1, true);
                    if (!required.matches(extractItem) || !extractItem.m_41763_()) continue;
                    if (!simulate) {
                        ItemStack stack = iItemHandler2.extractItem(i, 1, false);
                        stack.m_41721_(stack.m_41773_() + 1);
                        if (stack.m_41773_() <= stack.m_41776_()) {
                            if (iItemHandler2.getStackInSlot(i).m_41619_()) {
                                iItemHandler2.insertItem(i, stack, false);
                            } else {
                                ItemHandlerHelper.insertItem((IItemHandler)iItemHandler2, (ItemStack)stack, (boolean)false);
                            }
                        }
                    }
                    return true;
                }
            }
            return false;
        }
        boolean success = false;
        boolean bl = false;
        for (LazyOptional lazyOptional : this.attachedInventories) {
            iItemHandler = (IItemHandler)lazyOptional.orElse((Object)EmptyHandler.INSTANCE);
            if ((var5_8 += ItemHelper.extract(iItemHandler, required::matches, ItemHelper.ExtractionCountMode.UPTO, required.stack.m_41613_(), true).m_41613_()) < required.stack.m_41613_()) continue;
            success = true;
            break;
        }
        if (!simulate && success) {
            boolean bl2 = false;
            for (LazyOptional lazyOptional : this.attachedInventories) {
                iItemHandler = (IItemHandler)lazyOptional.orElse((Object)EmptyHandler.INSTANCE);
                if ((var5_10 += ItemHelper.extract(iItemHandler, required::matches, ItemHelper.ExtractionCountMode.UPTO, required.stack.m_41613_(), false).m_41613_()) < required.stack.m_41613_()) continue;
            }
        }
        return success;
    }

    public void finishedPrinting() {
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        this.inventory.setStackInSlot(1, new ItemStack((ItemLike)AllItems.EMPTY_SCHEMATIC.get(), this.inventory.getStackInSlot(1).m_41613_() + 1));
        this.state = State.STOPPED;
        this.statusMsg = "finished";
        this.resetPrinter();
        AllSoundEvents.SCHEMATICANNON_FINISH.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        this.sendUpdate = true;
    }

    protected void resetPrinter() {
        this.printer.resetSchematic();
        this.missingItem = null;
        this.sendUpdate = true;
        this.schematicProgress = 0.0f;
        this.blocksPlaced = 0;
        this.blocksToPlace = 0;
    }

    protected boolean shouldPlace(BlockPos pos, BlockState state, BlockEntity te, BlockState toReplace, BlockState toReplaceOther, boolean isNormalCube) {
        if (pos.m_123314_((Vec3i)this.m_58899_(), 2.0)) {
            return false;
        }
        if (!this.replaceTileEntities && (toReplace.m_155947_() || toReplaceOther != null && toReplaceOther.m_155947_())) {
            return false;
        }
        if (this.shouldIgnoreBlockState(state, te)) {
            return false;
        }
        boolean placingAir = state.m_60795_();
        if (this.replaceMode == 3) {
            return true;
        }
        if (this.replaceMode == 2 && !placingAir) {
            return true;
        }
        if (!(this.replaceMode != 1 || !isNormalCube && (toReplace.m_60796_((BlockGetter)this.f_58857_, pos) || toReplaceOther != null && toReplaceOther.m_60796_((BlockGetter)this.f_58857_, pos)) || placingAir)) {
            return true;
        }
        return this.replaceMode == 0 && !toReplace.m_60796_((BlockGetter)this.f_58857_, pos) && (toReplaceOther == null || !toReplaceOther.m_60796_((BlockGetter)this.f_58857_, pos)) && !placingAir;
    }

    protected boolean shouldIgnoreBlockState(BlockState state, BlockEntity te) {
        if (state.m_60734_() == Blocks.f_50454_) {
            return true;
        }
        ItemRequirement requirement = ItemRequirement.of(state, te);
        if (requirement.isEmpty()) {
            return false;
        }
        if (requirement.isInvalid()) {
            return false;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61401_) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61391_) && state.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.HEAD) {
            return true;
        }
        if (state.m_60734_() instanceof PistonHeadBlock) {
            return true;
        }
        if (AllBlocks.BELT.has(state)) {
            return state.m_61143_(BeltBlock.PART) == BeltPart.MIDDLE;
        }
        return false;
    }

    protected void tickFlyingBlocks() {
        LinkedList<LaunchedItem> toRemove = new LinkedList<LaunchedItem>();
        for (LaunchedItem b : this.flyingBlocks) {
            if (!b.update(this.f_58857_)) continue;
            toRemove.add(b);
        }
        this.flyingBlocks.removeAll(toRemove);
    }

    protected void refillFuelIfPossible() {
        if (this.hasCreativeCrate) {
            return;
        }
        if ((double)(1.0f - this.fuelLevel + 0.0078125f) < this.getFuelAddedByGunPowder()) {
            return;
        }
        if (this.inventory.getStackInSlot(4).m_41619_()) {
            return;
        }
        this.inventory.getStackInSlot(4).m_41774_(1);
        this.fuelLevel = (float)((double)this.fuelLevel + this.getFuelAddedByGunPowder());
        this.sendUpdate = true;
    }

    public double getFuelAddedByGunPowder() {
        return (Double)this.config().schematicannonGunpowderWorth.get() / 100.0;
    }

    protected void tickPaperPrinter() {
        boolean outputFull;
        int BookInput = 2;
        int BookOutput = 3;
        ItemStack blueprint = this.inventory.getStackInSlot(0);
        ItemStack paper = this.inventory.extractItem(BookInput, 1, true);
        boolean bl = outputFull = this.inventory.getStackInSlot(BookOutput).m_41613_() == this.inventory.getSlotLimit(BookOutput);
        if (paper.m_41619_() || outputFull) {
            if (this.bookPrintingProgress != 0.0f) {
                this.sendUpdate = true;
            }
            this.bookPrintingProgress = 0.0f;
            this.dontUpdateChecklist = false;
            return;
        }
        if (!this.printer.isLoaded()) {
            if (!blueprint.m_41619_()) {
                this.initializePrinter(blueprint);
            }
            return;
        }
        if (this.bookPrintingProgress >= 1.0f) {
            this.bookPrintingProgress = 0.0f;
            if (!this.dontUpdateChecklist) {
                this.updateChecklist();
            }
            this.dontUpdateChecklist = true;
            this.inventory.extractItem(BookInput, 1, false);
            ItemStack stack = this.checklist.createItem();
            stack.m_41764_(this.inventory.getStackInSlot(BookOutput).m_41613_() + 1);
            this.inventory.setStackInSlot(BookOutput, stack);
            this.sendUpdate = true;
            return;
        }
        this.bookPrintingProgress += 0.05f;
        this.sendUpdate = true;
    }

    public static BlockState stripBeltIfNotLast(BlockState blockState) {
        BeltPart part = (BeltPart)((Object)blockState.m_61143_(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return Blocks.f_50016_.m_49966_();
        }
        boolean isLastSegment = false;
        Direction facing = (Direction)blockState.m_61143_(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)blockState.m_61143_(BeltBlock.SLOPE));
        boolean positive = facing.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;
        switch (slope) {
            case DOWNWARD: {
                isLastSegment = start;
                break;
            }
            case UPWARD: {
                isLastSegment = end;
                break;
            }
            default: {
                boolean bl = isLastSegment = positive && end || !positive && start;
            }
        }
        if (isLastSegment) {
            return blockState;
        }
        return (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)AbstractSimpleShaftBlock.AXIS, (Comparable)(slope == BeltSlope.SIDEWAYS ? Direction.Axis.Y : facing.m_122427_().m_122434_()));
    }

    protected void launchBlockOrBelt(BlockPos target, ItemStack icon, BlockState blockState, BlockEntity tile) {
        if (AllBlocks.BELT.has(blockState)) {
            blockState = SchematicannonTileEntity.stripBeltIfNotLast(blockState);
            if (tile instanceof BeltTileEntity && AllBlocks.BELT.has(blockState)) {
                this.launchBelt(target, blockState, ((BeltTileEntity)tile).beltLength);
            } else if (blockState != Blocks.f_50016_.m_49966_()) {
                this.launchBlock(target, icon, blockState, null);
            }
        } else {
            CompoundTag data = null;
            if (tile != null) {
                if (AllTags.AllBlockTags.SAFE_NBT.matches(blockState)) {
                    data = tile.m_187480_();
                    data = NBTProcessors.process(tile, data, true);
                } else if (tile instanceof IPartialSafeNBT) {
                    data = new CompoundTag();
                    ((IPartialSafeNBT)tile).writeSafe(data);
                    data = NBTProcessors.process(tile, data, true);
                }
            }
            this.launchBlock(target, icon, blockState, data);
        }
    }

    protected void launchBelt(BlockPos target, BlockState state, int length) {
        ++this.blocksPlaced;
        ItemStack connector = AllItems.BELT_CONNECTOR.asStack();
        this.flyingBlocks.add(new LaunchedItem.ForBelt(this.m_58899_(), target, connector, state, length));
        this.playFiringSound();
    }

    protected void launchBlock(BlockPos target, ItemStack stack, BlockState state, @Nullable CompoundTag data) {
        if (!state.m_60795_()) {
            ++this.blocksPlaced;
        }
        this.flyingBlocks.add(new LaunchedItem.ForBlockState(this.m_58899_(), target, stack, state, data));
        this.playFiringSound();
    }

    protected void launchEntity(BlockPos target, ItemStack stack, Entity entity) {
        ++this.blocksPlaced;
        this.flyingBlocks.add(new LaunchedItem.ForEntity(this.m_58899_(), target, stack, entity));
        this.playFiringSound();
    }

    public void playFiringSound() {
        AllSoundEvents.SCHEMATICANNON_LAUNCH_BLOCK.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
    }

    @Override
    public void sendToContainer(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.m_58899_());
        buffer.m_130079_(this.m_5995_());
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return SchematicannonContainer.create(id, inv, this);
    }

    public Component m_5446_() {
        return Lang.translateDirect("gui.schematicannon.title", new Object[0]);
    }

    public void updateChecklist() {
        this.checklist.required.clear();
        this.checklist.damageRequired.clear();
        this.checklist.blocksNotLoaded = false;
        if (this.printer.isLoaded()) {
            this.blocksToPlace = this.blocksPlaced;
            this.blocksToPlace += this.printer.markAllBlockRequirements(this.checklist, this.f_58857_, this::shouldPlace);
            this.printer.markAllEntityRequirements(this.checklist);
        }
        this.checklist.gathered.clear();
        this.findInventories();
        for (LazyOptional lazyOptional : this.attachedInventories) {
            if (!lazyOptional.isPresent()) continue;
            IItemHandler inventory = (IItemHandler)lazyOptional.orElse((Object)EmptyHandler.INSTANCE);
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                ItemStack stackInSlot = inventory.getStackInSlot(slot);
                if (inventory.extractItem(slot, 1, true).m_41619_()) continue;
                this.checklist.collect(stackInSlot);
            }
        }
        this.sendUpdate = true;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.findInventories();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static enum State {
        STOPPED,
        PAUSED,
        RUNNING;

    }
}

