/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.core.IPeripheral;
import net.montoyo.wd.entity.TileEntityKeyboard;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Vector3i;
import org.jetbrains.annotations.NotNull;

public class BlockKeyboardRight
extends Block
implements IPeripheral {
    public static final DirectionProperty facing = BlockStateProperties.f_61374_;
    public static final VoxelShape KEYBOARD_AABB = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);

    public BlockKeyboardRight() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 10.0f));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{facing});
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return KEYBOARD_AABB;
    }

    private TileEntityKeyboard getTileEntity(Level world, BlockPos pos) {
        for (Direction nf : Direction.Plane.HORIZONTAL) {
            BlockPos np = pos.m_141952_(nf.m_122436_());
            BlockState ns = world.m_8055_(np);
            if (!(ns.m_60734_() instanceof BlockPeripheral) || ns.m_61143_(BlockPeripheral.type) != DefaultPeripheral.KEYBOARD) continue;
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof TileEntityKeyboard)) break;
            return (TileEntityKeyboard)te;
        }
        return null;
    }

    @Override
    public boolean connect(Level world, BlockPos pos, BlockState state, Vector3i scrPos, BlockSide scrSide) {
        TileEntityKeyboard keyboard = this.getTileEntity(world, pos);
        return keyboard != null && keyboard.connect(world, pos, state, scrPos, scrSide);
    }

    public static boolean checkNeighborhood(Level world, BlockPos bp, BlockPos ignore) {
        for (Direction neighbor : Direction.Plane.HORIZONTAL) {
            BlockState state;
            BlockPos np = bp.m_141952_(neighbor.m_122436_());
            if (ignore != null && np.equals((Object)ignore) || !((state = world.m_8055_(np)).m_60734_() instanceof BlockPeripheral ? state.m_61143_(BlockPeripheral.type) == DefaultPeripheral.KEYBOARD : state.m_60734_() instanceof BlockKeyboardRight)) continue;
            return false;
        }
        return true;
    }

    public void removeLeftPiece(Level world, BlockPos pos, boolean dropItem) {
        for (Direction nf : Direction.Plane.HORIZONTAL) {
            BlockPos np = pos.m_141952_(nf.m_122436_());
            BlockState ns = world.m_8055_(np);
            if (!(ns.m_60734_() instanceof BlockPeripheral) || ns.m_61143_(BlockPeripheral.type) != DefaultPeripheral.KEYBOARD) continue;
            world.m_7731_(np, Blocks.f_50016_.m_49966_(), 11);
            break;
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        if (world.m_5776_()) {
            return;
        }
        if (neighbor.m_123341_() == pos.m_123341_() && neighbor.m_123342_() == pos.m_123342_() - 1 && neighbor.m_123343_() == pos.m_123343_()) {
            this.removeLeftPiece(world, pos, true);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player ply, boolean willHarvest, FluidState fluid) {
        if (!world.f_46443_) {
            this.removeLeftPiece(world, pos, !ply.m_7500_());
        }
        return super.onDestroyedByPlayer(state, world, pos, ply, willHarvest, fluid);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        TileEntityKeyboard tek;
        double rpos = (entity.m_20186_() - (double)pos.m_123342_()) * 16.0;
        if (!world.f_46443_ && rpos >= 1.0 && rpos <= 2.0 && Math.random() < 0.25 && (tek = this.getTileEntity(world, pos)) != null) {
            tek.simulateCat(entity);
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (!context.m_43722_().m_41619_()) {
            return false;
        }
        BlockPos pos = context.m_8083_().m_141952_(context.m_8125_().m_122436_());
        if (context.m_43725_().m_8055_(pos.m_7495_()) == Blocks.f_50016_.m_49966_() || !BlockKeyboardRight.checkNeighborhood(context.m_43725_(), pos, null)) {
            return true;
        }
        int f = (int)Math.floor((double)(context.m_43723_().m_146908_() * 4.0f / 360.0f) + 2.5) & 3;
        Vec3i dir = Direction.m_122407_((int)f).m_122436_();
        BlockPos left = pos.m_141952_(dir);
        BlockPos right = pos.m_141950_(dir);
        if (context.m_43725_().m_8055_(right) == Blocks.f_50016_.m_49966_() && context.m_43725_().m_8055_(right.m_7495_()) != Blocks.f_50016_.m_49966_() && BlockKeyboardRight.checkNeighborhood(context.m_43725_(), right, null)) {
            return false;
        }
        return context.m_43725_().m_8055_(left) != Blocks.f_50016_.m_49966_() || context.m_43725_().m_8055_(left.m_7495_()) == Blocks.f_50016_.m_49966_() || !BlockKeyboardRight.checkNeighborhood(context.m_43725_(), left, null);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack;
        if (player.m_6144_() && this.m_6864_(state, new BlockPlaceContext(player, hand, itemStack = player.m_21120_(hand), hit))) {
            int f = (int)Math.floor((double)(player.m_146908_() * 4.0f / 360.0f) + 2.5) & 3;
            Vec3i dir = Direction.m_122407_((int)f).m_122436_();
            level.m_7731_(pos.m_141952_(dir), ((Block)BlockInit.blockKeyBoard.get()).m_49966_(), 11);
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_41720_() instanceof ItemLinker) {
            return InteractionResult.PASS;
        }
        TileEntityKeyboard tek = this.getTileEntity(level, pos);
        if (tek != null) {
            return tek.onRightClick(player, hand);
        }
        return InteractionResult.PASS;
    }
}

