/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.wd.block.BlockKeyboardRight;
import net.montoyo.wd.block.WDBlockContainer;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.entity.TileEntityInterfaceBase;
import net.montoyo.wd.entity.TileEntityKeyboard;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityServer;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.client.CMessageCloseGui;
import org.jetbrains.annotations.Nullable;

public class BlockPeripheral
extends WDBlockContainer {
    public static final EnumProperty<DefaultPeripheral> type = EnumProperty.m_61587_((String)"type", DefaultPeripheral.class);
    public static final DirectionProperty facing = DirectionProperty.m_61549_((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
    private static final Property<?>[] properties = new Property[]{type, facing};

    public BlockPeripheral() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 10.0f));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        BlockEntityType.BlockEntitySupplier<? extends BlockEntity> cls = ((DefaultPeripheral)((Object)state.m_61143_(type))).getTEClass();
        if (cls == null) {
            return null;
        }
        try {
            return cls.m_155267_(pos, state);
        }
        catch (Throwable t) {
            Log.errorEx((String)"Couldn't instantiate peripheral TileEntity:", (Throwable)t, (Object[])new Object[0]);
            return null;
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_41720_() instanceof ItemLinker) {
            return InteractionResult.FAIL;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityPeripheralBase) {
            return ((TileEntityPeripheralBase)te).onRightClick(player, hand);
        }
        if (te instanceof TileEntityServer) {
            ((TileEntityServer)te).onPlayerRightClick(player);
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_(type) == DefaultPeripheral.KEYBOARD ? BlockKeyboardRight.KEYBOARD_AABB : Shapes.m_83144_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (state.m_61143_(type) == DefaultPeripheral.KEYBOARD) {
            Direction f = (Direction)state.m_61143_((Property)facing);
            Vec3i dir = f.m_122427_().m_122436_();
            BlockPos left = pos.m_141952_(dir);
            BlockPos right = pos.m_141950_(dir);
            if (!world.m_46859_(pos.m_7495_()) && BlockKeyboardRight.checkNeighborhood(world, pos, null)) {
                if (world.m_46859_(right) && !world.m_46859_(right.m_7495_()) && BlockKeyboardRight.checkNeighborhood(world, right, pos)) {
                    world.m_7731_(right, (BlockState)((Block)BlockInit.blockKbRight.get()).m_49966_().m_61124_((Property)BlockKeyboardRight.facing, (Comparable)f), 3);
                    return;
                }
                if (world.m_46859_(left) && !world.m_46859_(left.m_7495_()) && BlockKeyboardRight.checkNeighborhood(world, left, pos)) {
                    world.m_7731_(left, state, 3);
                    world.m_7731_(pos, (BlockState)((Block)BlockInit.blockKbRight.get()).m_49966_().m_61124_((Property)BlockKeyboardRight.facing, (Comparable)f), 3);
                    return;
                }
            }
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            if (placer instanceof Player && ((Player)placer).m_7500_()) return;
        }
        if (!(placer instanceof Player)) return;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityServer) {
            ((TileEntityServer)te).setOwner((Player)placer);
            return;
        } else {
            if (!(te instanceof TileEntityInterfaceBase)) return;
            ((TileEntityInterfaceBase)te).setOwner((Player)placer);
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.IGNORE;
    }

    private void removeRightPiece(Level world, BlockPos pos) {
        for (Direction nf : Direction.Plane.HORIZONTAL) {
            BlockPos np = pos.m_141952_(nf.m_122436_());
            if (!(world.m_8055_(np).m_60734_() instanceof BlockKeyboardRight)) continue;
            world.m_7731_(np, Blocks.f_50016_.m_49966_(), 3);
            break;
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborType, BlockPos neighbor, boolean isMoving) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te instanceof TileEntityPeripheralBase) {
            ((TileEntityPeripheralBase)te).onNeighborChange(neighborType, neighbor);
        }
        if (world.f_46443_ || state.m_61143_(type) != DefaultPeripheral.KEYBOARD) {
            return;
        }
        if (neighbor.m_123341_() == pos.m_123341_() && neighbor.m_123342_() == pos.m_123342_() - 1 && neighbor.m_123343_() == pos.m_123343_() && world.m_46859_(neighbor)) {
            this.removeRightPiece(world, pos);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(world, pos)), (Object)new CMessageCloseGui(pos));
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        if (!world.f_46443_) {
            if (state.m_60734_() == this && state.m_61143_(type) == DefaultPeripheral.KEYBOARD) {
                this.removeRightPiece(world, pos);
            }
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(world, pos)), (Object)new CMessageCloseGui(pos));
        }
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.m_6240_(level, null, pos, level.m_8055_(pos), null, null);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity te;
        double rpos;
        if (!world.f_46443_ && world.m_8055_(pos).m_61143_(type) == DefaultPeripheral.KEYBOARD && (rpos = (entity.m_20186_() - (double)pos.m_123342_()) * 16.0) >= 1.0 && rpos <= 2.0 && Math.random() < 0.25 && (te = world.m_7702_(pos)) != null && te instanceof TileEntityKeyboard) {
            ((TileEntityKeyboard)te).simulateCat(entity);
        }
    }

    public static PacketDistributor.TargetPoint point(Level world, BlockPos bp) {
        return new PacketDistributor.TargetPoint((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), 64.0, world.m_46472_());
    }
}

