/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.data.SetURLData;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockScreen
extends BaseEntityBlock {
    public static final BooleanProperty hasTE = BooleanProperty.m_61465_((String)"haste");
    public static final BooleanProperty emitting = BooleanProperty.m_61465_((String)"emitting");
    private static final Property<?>[] properties = new Property[]{hasTE, emitting};
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final int BAR_BOT = 1;
    private static final int BAR_RIGHT = 2;
    private static final int BAR_TOP = 4;
    private static final int BAR_LEFT = 8;

    public BlockScreen(BlockBehaviour.Properties properties) {
        super(properties.m_60913_(1.5f, 10.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)hasTE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)emitting, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(properties).m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public static boolean isntScreenBlock(Level world, Vector3i pos) {
        return world.m_8055_(pos.toBlock()).m_60734_() != BlockInit.blockScreen.get();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return super.m_5573_(context);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public int getMetaFromState(BlockState state) {
        int ret = 0;
        if (((Boolean)state.m_61143_((Property)hasTE)).booleanValue()) {
            ret |= 1;
        }
        if (((Boolean)state.m_61143_((Property)emitting)).booleanValue()) {
            ret |= 2;
        }
        return ret;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos position, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_()) {
            heldItem = null;
        } else if (!(heldItem.m_41720_() instanceof IUpgrade)) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            return InteractionResult.FAIL;
        }
        boolean sneaking = player.m_6144_();
        Vector3i pos = new Vector3i(position);
        BlockSide side = BlockSide.values()[hit.m_82434_().ordinal()];
        Multiblock.findOrigin((LevelAccessor)world, pos, side, null);
        TileEntityScreen te = (TileEntityScreen)world.m_7702_(pos.toBlock());
        if (te != null && te.getScreen(side) != null) {
            TileEntityScreen.Screen scr = te.getScreen(side);
            if (sneaking) {
                if ((scr.rightsFor(player) & 1) == 0) {
                    Util.toast(player, "restrictions", new Object[0]);
                } else {
                    new SetURLData(pos, scr.side, scr.url).sendTo((ServerPlayer)player);
                }
                return InteractionResult.SUCCESS;
            }
            if (heldItem != null && !te.hasUpgrade(side, heldItem)) {
                if ((scr.rightsFor(player) & 0x10) == 0) {
                    Util.toast(player, "restrictions", new Object[0]);
                    return InteractionResult.SUCCESS;
                }
                if (te.addUpgrade(side, heldItem, player, false)) {
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    Util.toast(player, ChatFormatting.AQUA, "upgradeOk", new Object[0]);
                    if (player instanceof ServerPlayer) {
                        WebDisplays.INSTANCE.criterionUpgradeScreen.trigger(((ServerPlayer)player).m_8960_());
                    }
                } else {
                    Util.toast(player, "upgradeError", new Object[0]);
                }
                return InteractionResult.SUCCESS;
            }
            if ((scr.rightsFor(player) & 2) == 0) {
                Util.toast(player, "restrictions", new Object[0]);
                return InteractionResult.SUCCESS;
            }
            Vector2i tmp = new Vector2i();
            if (BlockScreen.hit2pixels(side, hit.m_82425_(), pos, scr, (float)hit.m_82450_().f_82479_, (float)hit.m_82450_().f_82480_, (float)hit.m_82450_().f_82481_, tmp)) {
                te.click(side, tmp);
            }
            return InteractionResult.SUCCESS;
        }
        if (sneaking) {
            Util.toast(player, "turnOn", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        Vector2i size = Multiblock.measure((LevelAccessor)world, pos, side);
        if (size.x < 2 || size.y < 2) {
            Util.toast(player, "tooSmall", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        if (size.x > WebDisplays.INSTANCE.maxScreenX || size.y > WebDisplays.INSTANCE.maxScreenY) {
            Util.toast(player, "tooBig", WebDisplays.INSTANCE.maxScreenX, WebDisplays.INSTANCE.maxScreenY);
            return InteractionResult.SUCCESS;
        }
        Vector3i err = Multiblock.check((LevelAccessor)world, pos, size, side);
        if (err != null) {
            Util.toast(player, "invalid", err.toString());
            return InteractionResult.SUCCESS;
        }
        boolean created = false;
        Log.info("Player %s (UUID %s) created a screen at %s of size %dx%d", player.m_7755_(), player.m_36316_().getId().toString(), pos.toString(), size.x, size.y);
        if (te == null) {
            BlockPos bp = pos.toBlock();
            world.m_46597_(bp, (BlockState)world.m_8055_(bp).m_61124_((Property)hasTE, (Comparable)Boolean.valueOf(true)));
            te = (TileEntityScreen)world.m_7702_(bp);
            created = true;
        }
        te.addScreen(side, size, null, player, !created);
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos source, boolean isMoving) {
        if (block != this && !world.f_46443_ && !((Boolean)state.m_61143_((Property)emitting)).booleanValue()) {
            for (BlockSide side : BlockSide.values()) {
                Vector3i vec = new Vector3i(pos);
                Multiblock.findOrigin((LevelAccessor)world, vec, side, null);
                TileEntityScreen tes = (TileEntityScreen)world.m_7702_(vec.toBlock());
                if (tes == null || !tes.hasUpgrade(side, DefaultUpgrade.REDSTONE_INPUT)) continue;
                Direction facing = Direction.m_122407_((int)side.reverse().ordinal());
                vec.sub(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()).neg();
                tes.updateJSRedstone(side, new Vector2i(vec.dot(side.right), vec.dot(side.up)), world.m_46681_(pos, facing));
            }
        }
    }

    public static boolean hit2pixels(BlockSide side, BlockPos bpos, Vector3i pos, TileEntityScreen.Screen scr, float hitX, float hitY, float hitZ, Vector2i dst) {
        if (side.right.x < 0) {
            hitX -= 1.0f;
        }
        if (side.right.z < 0 || side == BlockSide.TOP || side == BlockSide.BOTTOM) {
            hitZ -= 1.0f;
        }
        Vector3f rel = new Vector3f(pos.toBlock().m_123341_(), pos.toBlock().m_123342_(), pos.toBlock().m_123343_());
        rel.sub(hitX, hitY, hitZ);
        float cx = Math.abs(rel.dot(side.right.toFloat()) - 0.125f);
        float cy = Math.abs(rel.dot(side.up.toFloat()) - 0.125f);
        float sw = (float)scr.size.x - 0.25f;
        float sh = (float)scr.size.y - 0.25f;
        cx /= sw;
        cy /= sh;
        cx -= 0.05f;
        cy -= 0.05f;
        if (cx >= 0.0f && cx <= 1.0f && cy >= 0.0f && cy <= 1.0f) {
            if (side != BlockSide.BOTTOM) {
                cy = 1.0f - cy;
            }
            switch (scr.rotation) {
                case ROT_90: {
                    cy = 1.0f - cy;
                    break;
                }
                case ROT_180: {
                    cx = 1.0f - cx;
                    cy = 1.0f - cy;
                    break;
                }
                case ROT_270: {
                    cx = 1.0f - cx;
                    break;
                }
            }
            cx *= (float)scr.resolution.x;
            cy *= (float)scr.resolution.y;
            if (scr.rotation.isVertical) {
                dst.x = (int)cy;
                dst.y = (int)cx;
            } else {
                dst.x = (int)cx;
                dst.y = (int)cy;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        int meta = this.getMetaFromState(state);
        if ((meta & 1) == 0) {
            return null;
        }
        return (meta & 1) == 0 ? null : new TileEntityScreen(pos, state);
    }

    private void onDestroy(Level world, BlockPos pos, Player ply) {
        if (!world.f_46443_) {
            Vector3i bp = new Vector3i(pos);
            Multiblock.BlockOverride override = new Multiblock.BlockOverride(bp, Multiblock.OverrideAction.SIMULATE);
            for (BlockSide bs : BlockSide.values()) {
                this.destroySide(world, bp.clone(), bs, override, ply);
            }
        }
    }

    private void destroySide(Level world, Vector3i pos, BlockSide side, Multiblock.BlockOverride override, Player source) {
        Multiblock.findOrigin((LevelAccessor)world, pos, side, override);
        BlockPos bp = pos.toBlock();
        BlockEntity te = world.m_7702_(bp);
        if (te != null && te instanceof TileEntityScreen) {
            ((TileEntityScreen)te).onDestroy(source);
            world.m_7731_(bp, (BlockState)world.m_8055_(bp).m_61124_((Property)hasTE, (Comparable)Boolean.valueOf(false)), 11);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.onDestroy(level, pos, player);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6402_(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity whoDidThisShit, @NotNull ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        Multiblock.BlockOverride override = new Multiblock.BlockOverride(new Vector3i(pos), Multiblock.OverrideAction.IGNORE);
        Vector3i[] neighbors = new Vector3i[]{new Vector3i(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_()), new Vector3i(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_()), new Vector3i(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_()), new Vector3i(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_()), new Vector3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1), new Vector3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1)};
        for (Vector3i neighbor : neighbors) {
            if (!(world.m_8055_(neighbor.toBlock()).m_60734_() instanceof BlockScreen)) continue;
            for (BlockSide bs : BlockSide.values()) {
                this.destroySide(world, neighbor.clone(), bs, override, whoDidThisShit instanceof Player ? (Player)whoDidThisShit : null);
            }
        }
    }

    @NotNull
    public PushReaction m_5537_(BlockState state) {
        return PushReaction.IGNORE;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)emitting) != false ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)emitting);
    }

    private static class ItemBlockScreen
    extends BlockItem
    implements WDItem {
        public ItemBlockScreen(BlockScreen screen) {
            super((Block)screen, new Item.Properties());
        }

        @Override
        @javax.annotation.Nullable
        public String getWikiName(@Nonnull ItemStack is) {
            return is.m_41720_().m_7626_(is).getString();
        }
    }
}

