/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.utilities.BlockSide;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class GuiMinePad
extends WDScreen {
    private ClientProxy.PadData pad;
    private double vx;
    private double vy;
    private double vw;
    private double vh;

    public GuiMinePad() {
        super(Component.m_130674_(null));
    }

    public GuiMinePad(ClientProxy.PadData pad) {
        this();
        this.pad = pad;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.vw = (double)this.f_96543_ - 32.0;
        this.vh = this.vw / 1.9666666666666666;
        this.vx = 16.0;
        this.vy = ((double)this.f_96544_ - this.vh) / 2.0;
    }

    private static void addRect(BufferBuilder bb, double x, double y, double w, double h) {
        bb.m_5483_(x, y, 0.0).m_5752_();
        bb.m_5483_(x + w, y, 0.0).m_5752_();
        bb.m_5483_(x + w, y + h, 0.0).m_5752_();
        bb.m_5483_(x, y + h, 0.0).m_5752_();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
        this.m_7333_(poseStack);
        RenderSystem.m_69472_();
        RenderSystem.m_69464_();
        RenderSystem.m_157429_((float)0.73f, (float)0.73f, (float)0.73f, (float)1.0f);
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder bb = t.m_85915_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        GuiMinePad.addRect(bb, this.vx, this.vy - 16.0, this.vw, 16.0);
        GuiMinePad.addRect(bb, this.vx, this.vy + this.vh, this.vw, 16.0);
        GuiMinePad.addRect(bb, this.vx - 16.0, this.vy, 16.0, this.vh);
        GuiMinePad.addRect(bb, this.vx + this.vw, this.vy, 16.0, this.vh);
        t.m_85914_();
        RenderSystem.m_69493_();
        if (this.pad.view != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.pad.view.draw(poseStack, this.vx, this.vy + this.vh, this.vx + this.vw, this.vy);
        }
        RenderSystem.m_69481_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.key(keyCode, scanCode, true);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.key(keyCode, scanCode, false);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void key(int keyCode, int scanCode, boolean pressed) {
        Optional<Character> key = GuiMinePad.getChar(keyCode, scanCode);
        if (this.pad.view != null && key.isPresent()) {
            char c = key.get().charValue();
            if (pressed) {
                this.pad.view.injectKeyPressedByKeyCode(keyCode, c, 0);
            } else {
                this.pad.view.injectKeyReleasedByKeyCode(keyCode, c, 0);
            }
            if (c != '\u0000') {
                this.pad.view.injectKeyTyped((int)c, 0);
            }
        }
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        this.mouse(-1, false, (int)mouseX, (int)mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.mouse(button, true, (int)mouseX, (int)mouseY);
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.mouse(button, false, (int)mouseX, (int)mouseY);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void mouse(int btn, boolean pressed, int sx, int sy) {
        int vx = this.screen2DisplayX((int)this.vx);
        int vy = this.screen2DisplayY((int)this.vy);
        int vh = this.screen2DisplayX((int)this.vh);
        int vw = this.screen2DisplayY((int)this.vw);
        if (this.pad.view != null && sx >= vx && sx <= vx + vw && sy >= vy && sy <= vy + vh) {
            sx -= vx;
            sy -= vy;
            sy = vh - sy;
            sx = (int)((double)sx / (double)vw * WebDisplays.INSTANCE.padResX);
            sy = (int)((double)sy / (double)vh * WebDisplays.INSTANCE.padResY);
            if (btn == -1) {
                this.pad.view.injectMouseMove(sx, sy, 0, false);
            } else {
                this.pad.view.injectMouseButton(sx, sy, 0, btn + 1, pressed, 1);
            }
        }
    }

    public static Optional<Character> getChar(int keyCode, int scanCode) {
        String keystr = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if (keystr == null) {
            keystr = "\u0000";
        }
        if (keyCode == 257) {
            keystr = "\n";
        }
        if (keystr.length() == 0) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(keystr.charAt(keystr.length() - 1)));
    }

    @Override
    public void m_96624_() {
        if (this.pad.view == null) {
            this.f_96541_.m_91152_(null);
        }
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return false;
    }
}

