/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.IntStream;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.utilities.Log;

@OnlyIn(value=Dist.CLIENT)
public class RenderRecipe
extends Screen {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/crafting_table.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 166;
    private int x;
    private int y;
    private ItemRenderer renderItem;
    private final ItemStack[] recipe = new ItemStack[9];
    private ItemStack recipeResult;
    private String recipeName;
    private final ArrayList<NameRecipePair> recipes = new ArrayList();
    private ByteBuffer buffer;
    private int[] array;

    public RenderRecipe() {
        super(Component.m_130674_(null));
    }

    public void m_7856_() {
        this.x = (this.f_96543_ - 176) / 2;
        this.y = (this.f_96544_ - 166) / 2;
        this.renderItem = this.f_96541_.m_91291_();
        for (Recipe recipe : this.f_96541_.f_91073_.m_7465_().m_44051_()) {
            ResourceLocation regName = recipe.m_6423_();
            if (regName == null || !regName.m_135827_().equals("webdisplays")) continue;
            if (recipe instanceof ShapedRecipe) {
                this.recipes.add(new NameRecipePair(regName.m_135815_(), (ShapedRecipe)recipe));
                continue;
            }
            Log.warning("Found non-shaped recipe %s", regName.toString());
        }
        Log.info("Loaded %d recipes", this.recipes.size());
        this.nextRecipe();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CRAFTING_TABLE_GUI_TEXTURES);
        this.m_93228_(poseStack, this.x, this.y, 0, 0, 176, 166);
        this.f_96547_.m_92883_(poseStack, I18n.m_118938_((String)"container.crafting", (Object[])new Object[0]), (float)(this.x + 28), (float)(this.y + 6), 0x404040);
        Lighting.m_84930_();
        for (int sy = 0; sy < 3; ++sy) {
            for (int sx = 0; sx < 3; ++sx) {
                ItemStack is = this.recipe[sy * 3 + sx];
                if (is == null) continue;
                int x = this.x + 30 + sx * 18;
                int y = this.y + 17 + sy * 18;
                this.renderItem.m_174229_((LivingEntity)this.f_96541_.f_91074_, is, x, y, 0);
                this.renderItem.m_115174_(this.f_96547_, is, x, y, null);
            }
        }
        if (this.recipeResult != null) {
            this.renderItem.m_174229_((LivingEntity)this.f_96541_.f_91074_, this.recipeResult, this.x + 124, this.y + 35, 0);
            this.renderItem.m_115174_(this.f_96547_, this.recipeResult, this.x + 124, this.y + 35, null);
        }
        Lighting.m_84931_();
    }

    private void setRecipe(ShapedRecipe recipe) {
        IntStream.range(0, this.recipe.length).forEach(i -> {
            this.recipe[i] = null;
        });
        NonNullList ingredients = recipe.m_7527_();
        int pos = 0;
        for (int y = 0; y < recipe.getRecipeHeight(); ++y) {
            for (int x = 0; x < recipe.getRecipeWidth(); ++x) {
                ItemStack[] stacks;
                if ((stacks = ((Ingredient)ingredients.get(pos++)).m_43908_()).length <= 0) continue;
                this.recipe[y * 3 + x] = stacks[0];
            }
        }
        this.recipeResult = recipe.m_8043_();
    }

    private void nextRecipe() {
        if (this.recipes.isEmpty()) {
            this.f_96541_.m_91152_(null);
        } else {
            NameRecipePair pair = this.recipes.remove(0);
            this.setRecipe(pair.recipe);
            this.recipeName = pair.name;
        }
    }

    private int screen2DisplayX(int x) {
        double ret = (double)x / (double)this.f_96543_ * (double)this.f_96541_.m_91268_().m_85441_();
        return (int)ret;
    }

    private int screen2DisplayY(int y) {
        double ret = (double)y / (double)this.f_96544_ * (double)this.f_96541_.m_91268_().m_85442_();
        return (int)ret;
    }

    private void takeScreenshot() throws Throwable {
    }

    public void m_96624_() {
        if (this.recipeName != null) {
            try {
                this.takeScreenshot();
                this.nextRecipe();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.f_96541_.m_91152_(null);
            }
        }
    }

    private static class NameRecipePair {
        private final String name;
        private final ShapedRecipe recipe;

        private NameRecipePair(String n, ShapedRecipe r) {
            this.name = n;
            this.recipe = r;
        }
    }
}

