/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.montoyo.wd.client.gui.controls.BasicControl;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;

public class CheckBox
extends BasicControl {
    private static final ResourceLocation texUnchecked = new ResourceLocation("webdisplays", "textures/gui/checkbox.png");
    private static final ResourceLocation texChecked = new ResourceLocation("webdisplays", "textures/gui/checkbox_checked.png");
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    private String label;
    private int labelW;
    private boolean checked;
    private List<String> tooltip;

    public CheckBox() {
        this.label = "";
    }

    public CheckBox(int x, int y, String label) {
        this.label = label;
        this.labelW = this.font.m_92895_(label);
        this.checked = false;
        this.x = x;
        this.y = y;
    }

    public CheckBox(int x, int y, String label, boolean val) {
        this.label = label;
        this.labelW = this.font.m_92895_(label);
        this.checked = val;
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && !this.disabled) {
            if (mouseX >= (double)this.x && mouseX <= (double)(this.x + 16 + 2 + this.labelW) && mouseY >= (double)this.y && mouseY < (double)(this.y + 16)) {
                this.checked = !this.checked;
                this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                parent.actionPerformed(new CheckedEvent(this));
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
        if (this.visible) {
            poseStack.m_85836_();
            RenderSystem.m_157456_((int)2, (ResourceLocation)(this.checked ? texChecked : texUnchecked));
            RenderSystem.m_69396_((int)2);
            RenderSystem.m_69478_();
            this.fillTexturedRect(poseStack, this.x, this.y, 16, 16, 0.0, 0.0, 1.0, 1.0);
            RenderSystem.m_69461_();
            RenderSystem.m_69396_((int)-1);
            poseStack.m_85849_();
            boolean inside = !this.disabled && mouseX >= this.x && mouseX <= this.x + 16 + 2 + this.labelW && mouseY >= this.y && mouseY < this.y + 16;
            this.font.m_92883_(poseStack, this.label, (float)(this.x + 16 + 2), (float)(this.y + 4), inside ? -16744193 : -1);
        }
    }

    public void setLabel(String label) {
        this.label = label;
        this.labelW = this.font.m_92895_(label);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    @Override
    public int getWidth() {
        return 18 + this.labelW;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.label = CheckBox.tr(json.getString("label", ""));
        this.labelW = this.font.m_92895_(this.label);
        this.checked = json.getBool("checked", false);
        String tt = CheckBox.tr(json.getString("tooltip", ""));
        if (!tt.isEmpty()) {
            this.tooltip = Lists.newArrayList((Object[])tt.split("\\\\n"));
            parent.requirePostDraw(this);
        }
    }

    @Override
    public void postDraw(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
        if (this.tooltip != null && !this.disabled && mouseX >= this.x && mouseX <= this.x + 16 + 2 + this.labelW && mouseY >= this.y && mouseY < this.y + 16) {
            parent.drawTooltip(poseStack, this.tooltip, mouseX, mouseY);
        }
    }

    public static class CheckedEvent
    extends Event<CheckBox> {
        private final boolean checked;

        public CheckedEvent(CheckBox cb) {
            this.source = cb;
            this.checked = cb.checked;
        }

        public boolean isChecked() {
            return this.checked;
        }
    }
}

