/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.data;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.client.gui.GuiKeyboard;
import net.montoyo.wd.data.GuiData;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Vector3i;

public class KeyboardData
extends GuiData {
    public Vector3i pos;
    public BlockSide side;
    public int kbX;
    public int kbY;
    public int kbZ;

    public KeyboardData() {
    }

    public KeyboardData(TileEntityScreen tes, BlockSide side, BlockPos kbPos) {
        this.pos = new Vector3i(tes.m_58899_());
        this.side = side;
        this.kbX = kbPos.m_123341_();
        this.kbY = kbPos.m_123342_();
        this.kbZ = kbPos.m_123343_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createGui(Screen old, Level world) {
        BlockEntity te = world.m_7702_(this.pos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen)) {
            Log.error("TileEntity at %s is not a screen; can't open keyboard!", this.pos.toString());
            return null;
        }
        return new GuiKeyboard((TileEntityScreen)te, this.side, new BlockPos(this.kbX, this.kbY, this.kbZ));
    }

    @Override
    public String getName() {
        return "Keyboard";
    }
}

