/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.data;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.client.gui.GuiSetURL2;
import net.montoyo.wd.data.GuiData;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Vector3i;

public class SetURLData
extends GuiData {
    public Vector3i pos;
    public BlockSide side;
    public String url;
    public boolean isRemote;
    public Vector3i remoteLocation;

    public SetURLData() {
    }

    public SetURLData(Vector3i pos, BlockSide side, String url) {
        this.pos = pos;
        this.side = side;
        this.url = url;
        this.isRemote = false;
        this.remoteLocation = new Vector3i();
    }

    public SetURLData(Vector3i pos, BlockSide side, String url, BlockPos rl) {
        this.pos = pos;
        this.side = side;
        this.url = url;
        this.isRemote = true;
        this.remoteLocation = new Vector3i(rl);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createGui(Screen old, Level world) {
        BlockEntity te = world.m_7702_(this.pos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen)) {
            Log.error("TileEntity at %s is not a screen; can't open gui!", this.pos.toString());
            return null;
        }
        return new GuiSetURL2((TileEntityScreen)te, this.side, this.url, this.isRemote ? this.remoteLocation : null);
    }

    @Override
    public String getName() {
        return "SetURL";
    }
}

