/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.core.IComputerArgs;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.TypeData;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector2i;

public abstract class TileEntityInterfaceBase
extends TileEntityPeripheralBase {
    private NameUUIDPair owner;
    private static final Object[] TRUE = new Object[]{true};
    private static final Object[] FALSE = new Object[]{false};

    public TileEntityInterfaceBase(BlockEntityType<?> arg, BlockPos arg2, BlockState arg3) {
        super(arg, arg2, arg3);
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.owner = Util.readOwnerFromNBT(tag);
    }

    @Override
    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.serializeNBT();
        return Util.writeOwnerToNBT(tag, this.owner);
    }

    public void setOwner(Player ep) {
        this.owner = new NameUUIDPair(ep.m_36316_());
        this.m_6596_();
    }

    @ComputerFunc
    public Object[] isLinked(IComputerArgs args) {
        return new Object[]{this.isLinked()};
    }

    @ComputerFunc
    public Object[] isScreenChunkLoaded(IComputerArgs args) {
        return new Object[]{this.isScreenChunkLoaded()};
    }

    @ComputerFunc
    public Object[] getScreenPos(IComputerArgs args) {
        Object[] objectArray;
        if (this.isLinked()) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this.screenPos.x;
            objectArray2[1] = this.screenPos.y;
            objectArray = objectArray2;
            objectArray2[2] = this.screenPos.z;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @ComputerFunc
    public Object[] getScreenSide(IComputerArgs args) {
        Object[] objectArray;
        if (this.isLinked()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.screenSide.toString().toLowerCase();
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @ComputerFunc
    public Object[] getOwner(IComputerArgs args) {
        if (this.owner == null) {
            return null;
        }
        return new Object[]{this.owner.name, this.owner.uuid.toString()};
    }

    @ComputerFunc
    public Object[] can(IComputerArgs args) {
        String what;
        int right = switch (what = args.checkString(0).toLowerCase()) {
            case "click", "type" -> 2;
            case "seturl", "js", "javascript", "runjs" -> 1;
            case "setresolution", "setrotation" -> 32;
            default -> throw new IllegalArgumentException("invalid right name");
        };
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        return (tes.getScreen(this.screenSide).rightsFor(this.owner.uuid) & right) == 0 ? FALSE : TRUE;
    }

    @ComputerFunc
    public Object[] hasUpgrade(IComputerArgs args) {
        String name = args.checkString(0);
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        return tes.getScreen((BlockSide)this.screenSide).upgrades.stream().anyMatch(is -> ((IUpgrade)is.m_41720_()).getJSName((ItemStack)is).equalsIgnoreCase(name)) ? TRUE : FALSE;
    }

    @ComputerFunc
    public Object[] getSize(IComputerArgs args) {
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        Vector2i sz = tes.getScreen((BlockSide)this.screenSide).size;
        return new Object[]{sz.x, sz.y};
    }

    @ComputerFunc
    public Object[] getResolution(IComputerArgs args) {
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        Vector2i res = tes.getScreen((BlockSide)this.screenSide).resolution;
        return new Object[]{res.x, res.y};
    }

    @ComputerFunc
    public Object[] getRotation(IComputerArgs args) {
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        return new Object[]{tes.getScreen((BlockSide)this.screenSide).rotation.getAngleAsInt()};
    }

    @ComputerFunc
    public Object[] getURL(IComputerArgs args) {
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        return new Object[]{tes.getScreen((BlockSide)this.screenSide).url};
    }

    private static Object[] err(String str) {
        return new Object[]{false, str};
    }

    @ComputerFunc
    public Object[] click(IComputerArgs args) {
        int x = args.checkInteger(0);
        int y = args.checkInteger(1);
        String action = "click";
        if (args.count() > 2) {
            action = args.checkString(2).toLowerCase();
        }
        int actionId = switch (action) {
            case "click" -> 0;
            case "up", "release" -> 1;
            case "down", "press" -> 3;
            case "move" -> 2;
            default -> throw new IllegalArgumentException("bad action name");
        };
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityInterfaceBase.err("notlinked");
        }
        TileEntityScreen.Screen scrscr = scr.getScreen(this.screenSide);
        if ((scrscr.rightsFor(this.owner.uuid) & 2) == 0) {
            return TileEntityInterfaceBase.err("restrictions");
        }
        switch (scrscr.rotation) {
            case ROT_90: {
                y = scrscr.resolution.y - y;
                break;
            }
            case ROT_180: {
                x = scrscr.resolution.x - x;
                y = scrscr.resolution.y - y;
                break;
            }
            case ROT_270: {
                x = scrscr.resolution.x - x;
                break;
            }
        }
        if (scrscr.rotation.isVertical) {
            scr.clickUnsafe(this.screenSide, actionId, y, x);
        } else {
            scr.clickUnsafe(this.screenSide, actionId, x, y);
        }
        return TRUE;
    }

    private Object[] realType(String what) {
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityInterfaceBase.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 2) == 0) {
            return TileEntityInterfaceBase.err("restrictions");
        }
        scr.type(this.screenSide, what, null);
        return TRUE;
    }

    @ComputerFunc
    public Object[] type(IComputerArgs args) {
        String text = args.checkString(0);
        if (text.length() > 64) {
            return TileEntityInterfaceBase.err("toolong");
        }
        if (text.indexOf(1) >= 0) {
            return TileEntityInterfaceBase.err("badchar");
        }
        return this.realType("t" + text);
    }

    @ComputerFunc
    public Object[] typeAdvanced(IComputerArgs args) {
        ArrayList<TypeData> data = new ArrayList<TypeData>();
        Map map = args.checkTable(0);
        int maxEvents = 0;
        for (Object o : map.values()) {
            TypeData.Action dataAction;
            if (!(o instanceof Map)) {
                return TileEntityInterfaceBase.err("badinput");
            }
            if (++maxEvents >= 16) {
                return TileEntityInterfaceBase.err("toomany");
            }
            Map event = (Map)o;
            Object action = event.get("action");
            Object chr = event.get("char");
            int code = 0;
            if (!(action instanceof String)) {
                return TileEntityInterfaceBase.err("badaction");
            }
            if (!(chr instanceof String)) {
                return TileEntityInterfaceBase.err("badchar");
            }
            String strAction = (String)action;
            String strChr = (String)chr;
            if (strAction.equalsIgnoreCase("press")) {
                dataAction = TypeData.Action.PRESS;
            } else if (strAction.equalsIgnoreCase("release")) {
                dataAction = TypeData.Action.RELEASE;
            } else if (strAction.equalsIgnoreCase("type")) {
                dataAction = TypeData.Action.TYPE;
            } else {
                return TileEntityInterfaceBase.err("unknownaction");
            }
            if (strChr.isEmpty()) {
                return TileEntityInterfaceBase.err("emptychar");
            }
            if (dataAction != TypeData.Action.TYPE) {
                Object oCode = event.get("code");
                if (!(oCode instanceof Double)) {
                    return TileEntityInterfaceBase.err("badcode");
                }
                code = ((Double)oCode).intValue();
            }
            data.add(new TypeData(dataAction, code, 0));
        }
        return this.realType(WebDisplays.GSON.toJson(data));
    }

    @ComputerFunc
    public Object[] setURL(IComputerArgs args) {
        String url = args.checkString(0);
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityInterfaceBase.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 1) == 0) {
            return TileEntityInterfaceBase.err("restrictions");
        }
        scr.setScreenURL(this.screenSide, url);
        return TRUE;
    }

    @ComputerFunc
    public Object[] setResolution(IComputerArgs args) {
        int rx = args.checkInteger(0);
        int ry = args.checkInteger(1);
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityInterfaceBase.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 0x20) == 0) {
            return TileEntityInterfaceBase.err("restrictions");
        }
        scr.setResolution(this.screenSide, new Vector2i(rx, ry));
        return TRUE;
    }

    @ComputerFunc
    public Object[] setRotation(IComputerArgs args) {
        int rot = args.checkInteger(0);
        if (rot < 0) {
            int toAdd = rot / -360 + 1;
            rot += toAdd * 360;
        }
        rot /= 90;
        rot &= 3;
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityInterfaceBase.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 0x20) == 0) {
            return TileEntityInterfaceBase.err("restrictions");
        }
        scr.setRotation(this.screenSide, Rotation.values()[rot]);
        return TRUE;
    }

    @ComputerFunc
    public Object[] runJS(IComputerArgs args) {
        String code = args.checkString(0);
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityInterfaceBase.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 1) == 0) {
            return TileEntityInterfaceBase.err("restrictions");
        }
        scr.evalJS(this.screenSide, code);
        return TRUE;
    }

    @ComputerFunc
    public Object[] unlink(IComputerArgs args) {
        if (this.isLinked()) {
            this.screenPos = null;
            this.screenSide = null;
            this.m_6596_();
        }
        return null;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ComputerFunc {
    }
}

