/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.data.KeyboardData;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.init.TileInit;
import net.montoyo.wd.utilities.Util;

public class TileEntityKeyboard
extends TileEntityPeripheralBase {
    private static final String RANDOM_CHARS = "AZERTYUIOPQSDFGHJKLMWXCVBNazertyuiopqsdfghjklmwxcvbn0123456789";
    private static BlockPos blockPos;
    private static BlockState blockState;

    public TileEntityKeyboard(BlockPos arg2, BlockState arg3) {
        super((BlockEntityType)TileInit.KEYBOARD.get(), arg2, arg3);
        blockPos = arg2;
        blockState = arg3;
    }

    public static Block getBlockFromTE() {
        return new BlockPeripheral().m_49966_().m_60734_();
    }

    @Override
    public InteractionResult onRightClick(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isScreenChunkLoaded()) {
            Util.toast(player, "chunkUnloaded", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        TileEntityScreen tes = this.getConnectedScreen();
        if (tes == null) {
            Util.toast(player, "notLinked", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        TileEntityScreen.Screen scr = tes.getScreen(this.screenSide);
        if ((scr.rightsFor(player) & 2) == 0) {
            Util.toast(player, "restrictions", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        new KeyboardData(tes, this.screenSide, this.m_58899_()).sendTo((ServerPlayer)player);
        return InteractionResult.SUCCESS;
    }

    public void simulateCat(Entity ent) {
        TileEntityScreen tes;
        if (this.isScreenChunkLoaded() && (tes = this.getConnectedScreen()) != null) {
            boolean ok;
            TileEntityScreen.Screen scr = tes.getScreen(this.screenSide);
            if (ent instanceof Player) {
                ok = (scr.rightsFor((Player)ent) & 2) != 0;
            } else {
                boolean bl = ok = (scr.otherRights & 2) != 0;
            }
            if (ok) {
                char rnd = RANDOM_CHARS.charAt((int)(Math.random() * (double)RANDOM_CHARS.length()));
                tes.type(this.screenSide, "t" + rnd, this.m_58899_());
                Player owner = this.f_58857_.m_46003_(scr.owner.uuid);
                if (owner != null && owner instanceof ServerPlayer && ent instanceof Ocelot) {
                    WebDisplays.INSTANCE.criterionKeyboardCat.trigger(((ServerPlayer)owner).m_8960_());
                }
            }
        }
    }
}

