/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.data.ScreenConfigData;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.init.ItemInit;
import net.montoyo.wd.init.TileInit;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.client.CMessageAddScreen;
import net.montoyo.wd.net.client.CMessageCloseGui;
import net.montoyo.wd.net.client.CMessageJSResponse;
import net.montoyo.wd.net.client.CMessageScreenUpdate;
import net.montoyo.wd.net.server.SMessageRequestTEData;
import net.montoyo.wd.utilities.AABB;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.NibbleArray;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.ScreenIterator;
import net.montoyo.wd.utilities.TypeData;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;
import net.montoyo.wd.utilities.VideoType;

public class TileEntityScreen
extends BlockEntity {
    private final ArrayList<Screen> screens = new ArrayList();
    private net.minecraft.world.phys.AABB renderBB = new net.minecraft.world.phys.AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private boolean loaded = true;
    public float ytVolume = Float.POSITIVE_INFINITY;

    public TileEntityScreen(BlockPos arg2, BlockState arg3) {
        super((BlockEntityType)TileInit.SCREEN_BLOCK_ENTITY.get(), arg2, arg3);
    }

    public void forEachScreenBlocks(BlockSide side, Consumer<BlockPos> func) {
        Screen scr = this.getScreen(side);
        if (scr != null) {
            ScreenIterator it = new ScreenIterator(this.m_58899_(), side, scr.size);
            while (it.hasNext()) {
                func.accept(it.next());
            }
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
    }

    public void unload() {
        for (Screen scr : this.screens) {
            if (scr.browser == null) continue;
            scr.browser.close();
            scr.browser = null;
        }
        this.loaded = false;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        ListTag list = tag.m_128437_("WDScreens", 10);
        if (list.isEmpty()) {
            return;
        }
        this.screens.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.screens.add(Screen.deserialize(list.m_128728_(i)));
        }
    }

    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.serializeNBT();
        ListTag list = new ListTag();
        for (Screen scr : this.screens) {
            list.add((Object)scr.serialize());
        }
        tag.m_128365_("WDScreens", (Tag)list);
        return tag;
    }

    public Screen addScreen(BlockSide side, Vector2i size, @Nullable Vector2i resolution, @Nullable Player owner, boolean sendUpdate) {
        for (Screen scr : this.screens) {
            if (scr.side != side) continue;
            return scr;
        }
        Screen ret = new Screen();
        ret.side = side;
        ret.size = size;
        ret.url = WebDisplays.INSTANCE.homePage;
        ret.friends = new ArrayList();
        ret.friendRights = 51;
        ret.otherRights = 51;
        ret.upgrades = new ArrayList();
        if (owner != null) {
            ret.owner = new NameUUIDPair(owner.m_36316_());
            if (side == BlockSide.TOP || side == BlockSide.BOTTOM) {
                int rot = (int)Math.floor((double)(owner.m_146908_() * 4.0f / 360.0f) + 2.5) & 3;
                if (side == BlockSide.TOP) {
                    if (rot == 1) {
                        rot = 3;
                    } else if (rot == 3) {
                        rot = 1;
                    }
                }
                ret.rotation = Rotation.values()[rot];
            }
        }
        if (resolution == null || resolution.x < 1 || resolution.y < 1) {
            float psx = (float)size.x * 16.0f - 4.0f;
            float psy = (float)size.y * 16.0f - 4.0f;
            ret.resolution = new Vector2i((int)(psx *= 8.0f), (int)(psy *= 8.0f));
        } else {
            ret.resolution = resolution;
        }
        ret.clampResolution();
        if (!this.f_58857_.f_46443_) {
            ret.setupRedstoneStatus(this.f_58857_, this.m_58899_());
            if (sendUpdate) {
                Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)new CMessageAddScreen(this, ret));
            }
        }
        this.screens.add(ret);
        if (this.f_58857_.f_46443_) {
            this.updateAABB();
        } else {
            this.m_6596_();
        }
        return ret;
    }

    public Screen getScreen(BlockSide side) {
        for (Screen scr : this.screens) {
            if (scr.side != side) continue;
            return scr;
        }
        return null;
    }

    public int screenCount() {
        return this.screens.size();
    }

    public Screen getScreen(int idx) {
        return this.screens.get(idx);
    }

    public void clear() {
        this.screens.clear();
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public void requestData(ServerPlayer ep) {
        if (!this.f_58857_.f_46443_) {
            Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> ep), (Object)new CMessageAddScreen(this));
        }
    }

    public void setScreenURL(BlockSide side, String url) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt to change URL of non-existing screen on side %s", side.toString());
            return;
        }
        scr.url = url = WebDisplays.applyBlacklist(url);
        scr.videoType = VideoType.getTypeFromURL(url);
        if (this.f_58857_.f_46443_) {
            if (scr.browser != null) {
                scr.browser.loadURL(url);
            }
        } else {
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.setURL(this, side, url));
            this.m_6596_();
        }
    }

    public void removeScreen(BlockSide side) {
        int idx = -1;
        for (int i = 0; i < this.screens.size(); ++i) {
            if (this.screens.get((int)i).side != side) continue;
            idx = i;
            break;
        }
        if (idx < 0) {
            Log.error("Tried to delete non-existing screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (this.screens.get((int)idx).browser != null) {
                this.screens.get((int)idx).browser.close();
                this.screens.get((int)idx).browser = null;
            }
        } else {
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)new CMessageScreenUpdate(this, side));
        }
        this.screens.remove(idx);
        if (!this.f_58857_.f_46443_) {
            if (this.screens.isEmpty()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)((Block)BlockInit.blockScreen.get()).m_49966_().m_61124_((Property)BlockScreen.hasTE, (Comparable)Boolean.valueOf(false)));
            } else {
                this.m_6596_();
            }
        }
    }

    public void setResolution(BlockSide side, Vector2i res) {
        if (res.x < 1 || res.y < 1) {
            Log.warning("Call to TileEntityScreen.setResolution(%s) with suspicious values X=%d and Y=%d", side.toString(), res.x, res.y);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to change resolution of non-existing screen on side %s", side.toString());
            return;
        }
        scr.resolution = res;
        scr.clampResolution();
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.screenUpdateResolutionInGui(new Vector3i(this.m_58899_()), side, res);
            if (scr.browser != null) {
                scr.browser.close();
                scr.browser = null;
            }
        } else {
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.setResolution(this, side, res));
            this.m_6596_();
        }
    }

    private static Player getLaserUser(Screen scr) {
        if (scr.laserUser != null && (scr.laserUser.m_146910_() || !scr.laserUser.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(ItemInit.itemLaserPointer.get()))) {
            scr.laserUser = null;
        }
        return scr.laserUser;
    }

    private static void checkLaserUserRights(Screen scr) {
        if (scr.laserUser != null && (scr.rightsFor(scr.laserUser) & 2) == 0) {
            scr.laserUser = null;
        }
    }

    public void clearLaserUser(BlockSide side) {
        Screen scr = this.getScreen(side);
        if (scr != null) {
            scr.laserUser = null;
        }
    }

    public void click(BlockSide side, Vector2i vec) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt click non-existing screen of side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            Log.warning("TileEntityScreen.click() from client side is useless...", new Object[0]);
        } else if (TileEntityScreen.getLaserUser(scr) == null) {
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.click(this, side, 0, vec));
        }
    }

    void clickUnsafe(BlockSide side, int action, int x, int y) {
        if (this.f_58857_.f_46443_) {
            Vector2i vec = action == 1 ? null : new Vector2i(x, y);
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.click(this, side, action, vec));
        }
    }

    public void handleMouseEvent(BlockSide side, int event, @Nullable Vector2i vec) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt inject mouse events on non-existing screen of side %s", side.toString());
            return;
        }
        if (scr.browser != null) {
            if (event == 0) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, 1, true, 1);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, 1, false, 1);
            } else if (event == 3) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, 1, true, 1);
            } else if (event == 2) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
            } else if (event == 1) {
                scr.browser.injectMouseButton(scr.lastMousePos.x, scr.lastMousePos.y, 0, 1, false, 1);
            }
            if (vec != null) {
                scr.lastMousePos.x = vec.x;
                scr.lastMousePos.y = vec.y;
            }
        }
    }

    public void updateJSRedstone(BlockSide side, Vector2i vec, int redstoneLevel) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called updateJSRedstone on non-existing side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (scr.browser != null) {
                scr.browser.runJS("if(typeof webdisplaysRedstoneCallback == \"function\") webdisplaysRedstoneCallback(" + vec.x + ", " + vec.y + ", " + redstoneLevel + ");", "");
            }
        } else {
            boolean sendMsg = false;
            if (scr.redstoneStatus == null) {
                scr.setupRedstoneStatus(this.f_58857_, this.m_58899_());
                sendMsg = true;
            } else {
                int idx = vec.y * scr.size.x + vec.x;
                if (scr.redstoneStatus.get(idx) != redstoneLevel) {
                    scr.redstoneStatus.set(idx, redstoneLevel);
                    sendMsg = true;
                }
            }
            if (sendMsg) {
                Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.jsRedstone(this, side, vec, redstoneLevel));
            }
        }
    }

    public void handleJSRequest(ServerPlayer src, BlockSide side, int reqId, JSServerRequest req, Object[] data) {
        if (this.f_58857_.f_46443_) {
            Log.error("Called handleJSRequest client-side", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called handleJSRequest on non-existing side %s", side.toString());
            Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new CMessageJSResponse(reqId, req, 403, "Invalid side"));
            return;
        }
        if (!scr.owner.uuid.equals(src.m_36316_().getId())) {
            Log.warning("Player %s (UUID %s) tries to use the redstone output API on a screen he doesn't own!", src.m_7755_(), src.m_36316_().getId().toString());
            Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new CMessageJSResponse(reqId, req, 403, "Only the owner can do that"));
            return;
        }
        if (scr.upgrades.stream().noneMatch(DefaultUpgrade.REDSTONE_OUTPUT::matches)) {
            Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new CMessageJSResponse(reqId, req, 403, "Missing upgrade"));
            return;
        }
        if (req == JSServerRequest.CLEAR_REDSTONE) {
            BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
            Vector3i vec1 = new Vector3i(this.m_58899_());
            Vector3i vec2 = new Vector3i();
            for (int y = 0; y < scr.size.y; ++y) {
                vec2.set(vec1);
                for (int x = 0; x < scr.size.x; ++x) {
                    vec2.toBlock(mbp);
                    BlockState bs = this.f_58857_.m_8055_((BlockPos)mbp);
                    if (((Boolean)bs.m_61143_((Property)BlockScreen.emitting)).booleanValue()) {
                        this.f_58857_.m_7731_((BlockPos)mbp, (BlockState)bs.m_61124_((Property)BlockScreen.emitting, (Comparable)Boolean.valueOf(false)), 11);
                    }
                    vec2.add(side.right.x, side.right.y, side.right.z);
                }
                vec1.add(side.up.x, side.up.y, side.up.z);
            }
            Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new CMessageJSResponse(reqId, req, new byte[0]));
        } else if (req == JSServerRequest.SET_REDSTONE_AT) {
            int x = (Integer)data[0];
            int y = (Integer)data[1];
            boolean state = (Boolean)data[2];
            if (x < 0 || x >= scr.size.x || y < 0 || y >= scr.size.y) {
                Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new CMessageJSResponse(reqId, req, 403, "Out of range"));
            } else {
                BlockPos bp = new Vector3i(this.m_58899_()).addMul(side.right, x).addMul(side.up, y).toBlock();
                BlockState bs = this.f_58857_.m_8055_(bp);
                if (!((Boolean)bs.m_61143_((Property)BlockScreen.emitting)).equals(state)) {
                    this.f_58857_.m_46597_(bp, (BlockState)bs.m_61124_((Property)BlockScreen.emitting, (Comparable)Boolean.valueOf(state)));
                }
                Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new CMessageJSResponse(reqId, req, new byte[0]));
            }
        } else {
            Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new CMessageJSResponse(reqId, req, 400, "Invalid request"));
        }
    }

    public void onLoad() {
        if (this.f_58857_.f_46443_) {
            Messages.INSTANCE.sendToServer((Object)new SMessageRequestTEData(this));
            WebDisplays.PROXY.trackScreen(this, true);
        }
    }

    public void onChunkUnloaded() {
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.trackScreen(this, false);
            for (Screen scr : this.screens) {
                if (scr.browser == null) continue;
                scr.browser.close();
                scr.browser = null;
            }
        }
    }

    private void updateAABB() {
        Vector3i origin = new Vector3i(this.m_58899_());
        Vector3i tmp = new Vector3i();
        AABB aabb = new AABB(origin);
        for (Screen scr : this.screens) {
            tmp.set(origin);
            tmp.addMul(scr.side.right, scr.size.x);
            tmp.addMul(scr.side.up, scr.size.y);
            tmp.add(scr.side.forward);
            aabb.expand(tmp);
        }
        this.renderBB = aabb.toMc().m_82363_(0.1, 0.1, 0.1);
    }

    @Nonnull
    public net.minecraft.world.phys.AABB getRenderBoundingBox() {
        return this.renderBB;
    }

    public void updateTrackDistance(double d, float masterVolume) {
        WebDisplays wd = WebDisplays.INSTANCE;
        boolean needsComputation = true;
        int intPart = 0;
        int fracPart = 0;
        for (Screen scr : this.screens) {
            if (!scr.autoVolume || scr.videoType == null || scr.browser == null || scr.browser.isPageLoading()) continue;
            if (needsComputation) {
                float dist = (float)Math.sqrt(d);
                float vol = dist <= wd.avDist100 ? masterVolume * wd.ytVolume : (dist >= wd.avDist0 ? 0.0f : (1.0f - (dist - wd.avDist100) / (wd.avDist0 - wd.avDist100)) * masterVolume * wd.ytVolume);
                if (Math.abs(this.ytVolume - vol) < 0.5f) {
                    return;
                }
                this.ytVolume = vol;
                intPart = (int)vol;
                fracPart = (int)(vol * 100.0f) - intPart * 100;
                needsComputation = false;
            }
            scr.browser.runJS(scr.videoType.getVolumeJSQuery(intPart, fracPart), "");
        }
    }

    public void updateClientSideURL(IBrowser target, String url) {
        for (Screen scr : this.screens) {
            if (scr.browser != target) continue;
            boolean blacklisted = WebDisplays.isSiteBlacklisted(url);
            scr.url = blacklisted ? "mod://webdisplays/blacklisted.html" : url;
            scr.videoType = VideoType.getTypeFromURL(scr.url);
            this.ytVolume = Float.POSITIVE_INFINITY;
            if (!blacklisted || scr.browser == null) break;
            scr.browser.loadURL("mod://webdisplays/blacklisted.html");
            break;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.f_58857_.f_46443_) {
            this.onChunkUnloaded();
        }
    }

    public void addFriend(ServerPlayer ply, BlockSide side, NameUUIDPair pair) {
        if (!this.f_58857_.f_46443_) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to add friend to invalid screen side %s", side.toString());
                return;
            }
            if (!scr.friends.contains(pair)) {
                scr.friends.add(pair);
                new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(BlockPeripheral.point(this.f_58857_, this.m_58899_()));
                this.m_6596_();
            }
        }
    }

    public void removeFriend(ServerPlayer ply, BlockSide side, NameUUIDPair pair) {
        if (!this.f_58857_.f_46443_) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to remove friend from invalid screen side %s", side.toString());
                return;
            }
            if (scr.friends.remove(pair)) {
                TileEntityScreen.checkLaserUserRights(scr);
                new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(BlockPeripheral.point(this.f_58857_, this.m_58899_()));
                this.m_6596_();
            }
        }
    }

    public void setRights(ServerPlayer ply, BlockSide side, int fr, int or) {
        if (!this.f_58857_.f_46443_) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to change rights of invalid screen on side %s", side.toString());
                return;
            }
            scr.friendRights = fr;
            scr.otherRights = or;
            TileEntityScreen.checkLaserUserRights(scr);
            new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(BlockPeripheral.point(this.f_58857_, this.m_58899_()));
            this.m_6596_();
        }
    }

    public void type(BlockSide side, String text, BlockPos soundPos) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to type on invalid screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (scr.browser != null) {
                try {
                    TypeData[] data;
                    if (text.startsWith("t")) {
                        char chr;
                        for (int i = 1; i < text.length() && (chr = text.charAt(i)) != '\u0001'; ++i) {
                            scr.browser.injectKeyTyped((int)chr, 0);
                        }
                    }
                    block8: for (TypeData ev : data = (TypeData[])WebDisplays.GSON.fromJson(text, TypeData[].class)) {
                        switch (ev.getAction()) {
                            case PRESS: {
                                scr.browser.injectKeyPressedByKeyCode(ev.getKeyCode(), (char)ev.getKeyCode(), 0);
                                continue block8;
                            }
                            case RELEASE: {
                                scr.browser.injectKeyReleasedByKeyCode(ev.getKeyCode(), (char)ev.getKeyCode(), 0);
                                continue block8;
                            }
                            case TYPE: {
                                scr.browser.injectKeyTyped((int)((char)ev.getKeyCode()), 0);
                                continue block8;
                            }
                            default: {
                                throw new RuntimeException("Invalid type action '" + ev.getAction() + "'");
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    Log.warningEx("Suspicious keyboard type packet received...", t, new Object[0]);
                }
            }
        } else {
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.type(this, side, text));
            if (soundPos != null) {
                this.playSoundAt(WebDisplays.INSTANCE.soundTyping, soundPos, 0.25f, 1.0f);
            }
        }
    }

    private void playSoundAt(SoundEvent snd, BlockPos at, float vol, float pitch) {
        double x = at.m_123341_();
        double y = at.m_123342_();
        double z = at.m_123343_();
        this.f_58857_.m_6263_(null, x + 0.5, y + 0.5, z + 0.5, snd, SoundSource.BLOCKS, vol, pitch);
    }

    public void updateUpgrades(BlockSide side, ItemStack[] upgrades) {
        if (!this.f_58857_.f_46443_) {
            Log.error("Tried to call TileEntityScreen.updateUpgrades() from server side...", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to update upgrades on invalid screen on side %s", side.toString());
            return;
        }
        scr.upgrades.clear();
        Collections.addAll(scr.upgrades, upgrades);
        if (scr.browser != null) {
            scr.browser.runJS("if(typeof webdisplaysUpgradesChanged == \"function\") webdisplaysUpgradesChanged();", "");
        }
    }

    private static String safeName(ItemStack is) {
        ResourceLocation rl = is.m_41720_().getRegistryName();
        return rl == null ? "[NO NAME, WTF?!]" : rl.toString();
    }

    public boolean addUpgrade(BlockSide side, ItemStack is, @Nullable Player player, boolean abortIfExisting) {
        if (this.f_58857_.f_46443_) {
            return false;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to add an upgrade on invalid screen on side %s", side.toString());
            return false;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            Log.error("Tried to add a non-upgrade item %s to screen (%s does not implement IUpgrade)", TileEntityScreen.safeName(is), is.m_41720_().getClass().getCanonicalName());
            return false;
        }
        if (scr.upgrades.size() >= 16) {
            Log.error("Can't insert upgrade %s in screen %s at %s: too many upgrades already!", TileEntityScreen.safeName(is), side.toString(), this.m_58899_().toString());
            return false;
        }
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        if (abortIfExisting && scr.upgrades.stream().anyMatch(otherStack -> itemAsUpgrade.isSameUpgrade(is, (ItemStack)otherStack))) {
            return false;
        }
        ItemStack isCopy = is.m_41777_();
        isCopy.m_41764_(1);
        scr.upgrades.add(isCopy);
        Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.upgrade(this, side));
        itemAsUpgrade.onInstall(this, side, player, isCopy);
        this.playSoundAt(WebDisplays.INSTANCE.soundUpgradeAdd, this.m_58899_(), 1.0f, 1.0f);
        this.m_6596_();
        return true;
    }

    public boolean hasUpgrade(BlockSide side, ItemStack is) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            return false;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            return false;
        }
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        return scr.upgrades.stream().anyMatch(otherStack -> itemAsUpgrade.isSameUpgrade(is, (ItemStack)otherStack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasUpgrade(BlockSide side, DefaultUpgrade du) {
        Screen scr = this.getScreen(side);
        if (scr == null) return false;
        if (!scr.upgrades.stream().anyMatch(du::matches)) return false;
        return true;
    }

    public void removeUpgrade(BlockSide side, ItemStack is, @Nullable Player player) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to remove an upgrade on invalid screen on side %s", side.toString());
            return;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            Log.error("Tried to remove a non-upgrade item %s to screen (%s does not implement IUpgrade)", TileEntityScreen.safeName(is), is.m_41720_().getClass().getCanonicalName());
            return;
        }
        int idxToRemove = -1;
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        for (int i = 0; i < scr.upgrades.size(); ++i) {
            if (!itemAsUpgrade.isSameUpgrade(is, scr.upgrades.get(i))) continue;
            idxToRemove = i;
            break;
        }
        if (idxToRemove >= 0) {
            this.dropUpgrade(scr.upgrades.get(idxToRemove), side, player);
            scr.upgrades.remove(idxToRemove);
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.upgrade(this, side));
            this.playSoundAt(WebDisplays.INSTANCE.soundUpgradeDel, this.m_58899_(), 1.0f, 1.0f);
            this.m_6596_();
        } else {
            Log.warning("Tried to remove non-existing upgrade %s to screen %s at %s", TileEntityScreen.safeName(is), side.toString(), this.m_58899_().toString());
        }
    }

    private void dropUpgrade(ItemStack is, BlockSide side, @Nullable Player ply) {
        if (!((IUpgrade)is.m_41720_()).onRemove(this, side, ply, is)) {
            boolean spawnDrop = true;
            if (ply != null && (ply.m_7500_() || ply.m_36356_(is))) {
                spawnDrop = false;
            }
            if (spawnDrop) {
                Vector3f pos = new Vector3f(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
                pos.addMul(side.backward.toFloat(), 1.5f);
                if (this.f_58857_ != null) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)pos.x, (double)pos.y, (double)pos.z, is));
                }
            }
        }
    }

    private Screen getScreenForLaserOp(BlockSide side, Player ply) {
        if (this.f_58857_.f_46443_) {
            return null;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called laser operation on invalid screen on side %s", side.toString());
            return null;
        }
        if ((scr.rightsFor(ply) & 2) == 0) {
            return null;
        }
        if (scr.upgrades.stream().noneMatch(DefaultUpgrade.LASER_MOUSE::matches)) {
            Log.error("Called laser operation on side %s, but it's missing the laser sensor upgrade", side.toString());
            return null;
        }
        return scr;
    }

    public void laserDownMove(BlockSide side, Player ply, Vector2i pos, boolean down) {
        Screen scr = this.getScreenForLaserOp(side, ply);
        if (scr != null) {
            if (down) {
                if (TileEntityScreen.getLaserUser(scr) == null) {
                    scr.laserUser = ply;
                    Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.click(this, side, 3, pos));
                }
            } else if (TileEntityScreen.getLaserUser(scr) == ply) {
                Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.click(this, side, 2, pos));
            }
        }
    }

    public void laserUp(BlockSide side, Player ply) {
        Screen scr = this.getScreenForLaserOp(side, ply);
        if (scr != null && TileEntityScreen.getLaserUser(scr) == ply) {
            scr.laserUser = null;
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.click(this, side, 1, null));
        }
    }

    public void onDestroy(@Nullable Player ply) {
        for (Screen scr : this.screens) {
            scr.upgrades.forEach(is -> this.dropUpgrade((ItemStack)is, scr.side, ply));
            scr.upgrades.clear();
        }
        Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)new CMessageCloseGui(this.m_58899_()));
    }

    public void setOwner(BlockSide side, Player newOwner) {
        if (this.f_58857_.f_46443_) {
            Log.error("Called TileEntityScreen.setOwner() on client...", new Object[0]);
            return;
        }
        if (newOwner == null) {
            Log.error("Called TileEntityScreen.setOwner() with null owner", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called TileEntityScreen.setOwner() on invalid screen on side %s", side.toString());
            return;
        }
        scr.owner = new NameUUIDPair(newOwner.m_36316_());
        Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.owner(this, side, scr.owner));
        TileEntityScreen.checkLaserUserRights(scr);
        this.m_6596_();
    }

    public void setRotation(BlockSide side, Rotation rot) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to change rotation of invalid screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            boolean oldWasVertical = scr.rotation.isVertical;
            scr.rotation = rot;
            WebDisplays.PROXY.screenUpdateRotationInGui(new Vector3i(this.m_58899_()), side, rot);
            if (scr.browser != null && oldWasVertical != rot.isVertical) {
                scr.browser.close();
                scr.browser = null;
            }
        } else {
            scr.rotation = rot;
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.rotation(this, side, rot));
            this.m_6596_();
        }
    }

    public void evalJS(BlockSide side, String code) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to run JS code on invalid screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (scr.browser != null) {
                scr.browser.runJS(code, "");
            }
        } else {
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.js(this, side, code));
        }
    }

    public void setAutoVolume(BlockSide side, boolean av) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to toggle auto-volume on invalid screen (side %s)", side.toString());
            return;
        }
        scr.autoVolume = av;
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.screenUpdateAutoVolumeInGui(new Vector3i(this.m_58899_()), side, av);
        } else {
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)CMessageScreenUpdate.autoVolume(this, side, av));
            this.m_6596_();
        }
    }

    public static class Screen {
        public BlockSide side;
        public Vector2i size;
        public Vector2i resolution;
        public Rotation rotation = Rotation.ROT_0;
        public String url;
        private VideoType videoType;
        public NameUUIDPair owner;
        public ArrayList<NameUUIDPair> friends;
        public int friendRights;
        public int otherRights;
        public IBrowser browser;
        public ArrayList<ItemStack> upgrades;
        public boolean doTurnOnAnim;
        public long turnOnTime;
        public Player laserUser;
        public final Vector2i lastMousePos = new Vector2i();
        public NibbleArray redstoneStatus;
        public boolean autoVolume = true;

        public static Screen deserialize(CompoundTag tag) {
            Screen ret = new Screen();
            ret.side = BlockSide.values()[tag.m_128445_("Side")];
            ret.size = new Vector2i(tag.m_128451_("Width"), tag.m_128451_("Height"));
            ret.resolution = new Vector2i(tag.m_128451_("ResolutionX"), tag.m_128451_("ResolutionY"));
            ret.rotation = Rotation.values()[tag.m_128445_("Rotation")];
            ret.url = tag.m_128461_("URL");
            ret.videoType = VideoType.getTypeFromURL(ret.url);
            if (ret.resolution.x <= 0 || ret.resolution.y <= 0) {
                float psx = (float)ret.size.x * 16.0f - 4.0f;
                float psy = (float)ret.size.y * 16.0f - 4.0f;
                ret.resolution.x = (int)(psx *= 8.0f);
                ret.resolution.y = (int)(psy *= 8.0f);
            }
            if (tag.m_128441_("OwnerName")) {
                String name = tag.m_128461_("OwnerName");
                UUID uuid = tag.m_128342_("OwnerUUID");
                ret.owner = new NameUUIDPair(name, uuid);
            }
            ListTag friends = tag.m_128437_("Friends", 10);
            ret.friends = new ArrayList(friends.size());
            for (int i = 0; i < friends.size(); ++i) {
                CompoundTag nf = friends.m_128728_(i);
                NameUUIDPair pair = new NameUUIDPair(nf.m_128461_("Name"), nf.m_128342_("UUID"));
                ret.friends.add(pair);
            }
            ret.friendRights = tag.m_128445_("FriendRights");
            ret.otherRights = tag.m_128445_("OtherRights");
            ListTag upgrades = tag.m_128437_("Upgrades", 10);
            ret.upgrades = new ArrayList();
            for (int i = 0; i < upgrades.size(); ++i) {
                ret.upgrades.add(new ItemStack((ItemLike)upgrades.m_128728_(i)));
            }
            if (tag.m_128441_("AutoVolume")) {
                ret.autoVolume = tag.m_128471_("AutoVolume");
            }
            return ret;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Side", (byte)this.side.ordinal());
            tag.m_128405_("Width", this.size.x);
            tag.m_128405_("Height", this.size.y);
            tag.m_128405_("ResolutionX", this.resolution.x);
            tag.m_128405_("ResolutionY", this.resolution.y);
            tag.m_128344_("Rotation", (byte)this.rotation.ordinal());
            tag.m_128359_("URL", this.url);
            if (this.owner == null) {
                Log.warning("Found TES with NO OWNER!!", new Object[0]);
            } else {
                tag.m_128359_("OwnerName", this.owner.name);
                tag.m_128362_("OwnerUUID", this.owner.uuid);
            }
            ListTag list = new ListTag();
            for (NameUUIDPair f : this.friends) {
                CompoundTag nf = new CompoundTag();
                nf.m_128359_("Name", f.name);
                nf.m_128362_("UUID", f.uuid);
                list.add((Object)nf);
            }
            tag.m_128365_("Friends", (Tag)list);
            tag.m_128344_("FriendRights", (byte)this.friendRights);
            tag.m_128344_("OtherRights", (byte)this.otherRights);
            list = new ListTag();
            for (ItemStack is : this.upgrades) {
                list.add((Object)is.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("Upgrades", (Tag)list);
            tag.m_128379_("AutoVolume", this.autoVolume);
            return tag;
        }

        public int rightsFor(Player ply) {
            return this.rightsFor(ply.m_36316_().getId());
        }

        public int rightsFor(UUID uuid) {
            if (this.owner.uuid.equals(uuid)) {
                return 255;
            }
            return this.friends.stream().anyMatch(f -> f.uuid.equals(uuid)) ? this.friendRights : this.otherRights;
        }

        public void setupRedstoneStatus(Level world, BlockPos start) {
            if (world.m_5776_()) {
                Log.warning("Called Screen.setupRedstoneStatus() on client.", new Object[0]);
                return;
            }
            if (this.redstoneStatus != null) {
                Log.warning("Called Screen.setupRedstoneStatus() on server, but redstone status is non-null", new Object[0]);
                return;
            }
            Direction[] VALUES = Direction.values();
            this.redstoneStatus = new NibbleArray(this.size.x * this.size.y);
            Direction facing = VALUES[this.side.reverse().ordinal()];
            ScreenIterator it = new ScreenIterator(start, this.side, this.size);
            while (it.hasNext()) {
                int idx = it.getIndex();
                this.redstoneStatus.set(idx, world.m_46681_(it.next(), facing));
            }
        }

        public void clampResolution() {
            if (this.resolution.x > WebDisplays.INSTANCE.maxResX) {
                float newY = (float)this.resolution.y * (float)WebDisplays.INSTANCE.maxResX / (float)this.resolution.x;
                this.resolution.x = WebDisplays.INSTANCE.maxResX;
                this.resolution.y = (int)newY;
            }
            if (this.resolution.y > WebDisplays.INSTANCE.maxResY) {
                float newX = (float)this.resolution.x * (float)WebDisplays.INSTANCE.maxResY / (float)this.resolution.y;
                this.resolution.x = (int)newX;
                this.resolution.y = WebDisplays.INSTANCE.maxResY;
            }
        }
    }
}

