/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

public class CMessageAddScreen {
    private boolean clear;
    private Vector3i pos;
    private TileEntityScreen.Screen[] screens;

    public CMessageAddScreen(TileEntityScreen tes) {
        this.clear = true;
        this.pos = new Vector3i(tes.m_58899_());
        this.screens = new TileEntityScreen.Screen[tes.screenCount()];
        for (int i = 0; i < tes.screenCount(); ++i) {
            this.screens[i] = tes.getScreen(i);
        }
    }

    public CMessageAddScreen(TileEntityScreen tes, TileEntityScreen.Screen ... toSend) {
        this.clear = false;
        this.pos = new Vector3i(tes.m_58899_());
        this.screens = toSend;
    }

    public CMessageAddScreen(boolean clear, Vector3i pos, TileEntityScreen.Screen[] screens) {
        this.clear = clear;
        this.pos = pos;
        this.screens = screens;
    }

    public static CMessageAddScreen decode(FriendlyByteBuf buf) {
        boolean clear = buf.readBoolean();
        Vector3i pos = new Vector3i((ByteBuf)buf);
        int cnt = buf.readByte() & 7;
        TileEntityScreen.Screen[] screens = new TileEntityScreen.Screen[cnt];
        for (int i = 0; i < cnt; ++i) {
            screens[i] = new TileEntityScreen.Screen();
            screens[i].side = BlockSide.values()[buf.readByte()];
            screens[i].size = new Vector2i((ByteBuf)buf);
            screens[i].url = buf.m_130277_();
            screens[i].resolution = new Vector2i((ByteBuf)buf);
            screens[i].rotation = Rotation.values()[buf.readByte() & 3];
            screens[i].owner = new NameUUIDPair(buf);
            screens[i].upgrades = new ArrayList();
            int numUpgrades = buf.readByte();
            for (int j = 0; j < numUpgrades; ++j) {
                screens[i].upgrades.add(buf.m_130267_());
            }
        }
        return new CMessageAddScreen(clear, pos, screens);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.clear);
        this.pos.writeTo((ByteBuf)buf);
        buf.writeByte(this.screens.length);
        for (TileEntityScreen.Screen scr : this.screens) {
            buf.writeByte(scr.side.ordinal());
            scr.size.writeTo((ByteBuf)buf);
            buf.m_130070_(scr.url);
            scr.resolution.writeTo((ByteBuf)buf);
            buf.writeByte(scr.rotation.ordinal());
            scr.owner.writeTo(buf);
            buf.writeByte(scr.upgrades.size());
            for (ItemStack is : scr.upgrades) {
                buf.m_130055_(is);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            BlockEntity te = WebDisplays.PROXY.getWorld((ResourceKey<Level>)Level.f_46428_).m_7702_(this.pos.toBlock());
            if (!(te instanceof TileEntityScreen)) {
                if (this.clear) {
                    Log.error("CMessageAddScreen: Can't add screen to invalid tile entity at %s", this.pos.toString());
                }
                return;
            }
            TileEntityScreen tes = (TileEntityScreen)te;
            if (this.clear) {
                tes.clear();
            }
            for (TileEntityScreen.Screen entry : this.screens) {
                TileEntityScreen.Screen scr = tes.addScreen(entry.side, entry.size, entry.resolution, null, false);
                scr.rotation = entry.rotation;
                scr.url = entry.url;
                scr.owner = entry.owner;
                scr.upgrades = entry.upgrades;
                if (scr.browser == null) continue;
                scr.browser.loadURL(entry.url);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

