/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client;

import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.utilities.BlockSide;

public class CMessageCloseGui {
    private BlockPos blockPos;
    private BlockSide blockSide;

    public CMessageCloseGui(BlockPos bp) {
        this.blockPos = bp;
        this.blockSide = null;
    }

    public CMessageCloseGui(BlockPos bp, BlockSide side) {
        this.blockPos = bp;
        this.blockSide = side;
    }

    public static CMessageCloseGui decode(FriendlyByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        byte side = buf.readByte();
        BlockPos blockPos = new BlockPos(x, y, z);
        BlockSide blockSide = side <= 0 ? null : BlockSide.values()[side - 1];
        return new CMessageCloseGui(blockPos, blockSide);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.blockPos.m_123341_());
        buf.writeInt(this.blockPos.m_123342_());
        buf.writeInt(this.blockPos.m_123343_());
        if (this.blockSide == null) {
            buf.writeByte(0);
        } else {
            buf.writeByte(this.blockSide.ordinal() + 1);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            if (this.blockSide == null) {
                Arrays.stream(BlockSide.values()).forEach(s -> WebDisplays.PROXY.closeGui(this.blockPos, (BlockSide)((Object)((Object)s))));
            } else {
                WebDisplays.PROXY.closeGui(this.blockPos, this.blockSide);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

