/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

public class CMessageScreenUpdate {
    public static final int UPDATE_URL = 0;
    public static final int UPDATE_RESOLUTION = 1;
    public static final int UPDATE_DELETE = 2;
    public static final int UPDATE_MOUSE = 3;
    public static final int UPDATE_TYPE = 4;
    public static final int UPDATE_UPGRADES = 5;
    public static final int UPDATE_JS_REDSTONE = 6;
    public static final int UPDATE_OWNER = 7;
    public static final int UPDATE_ROTATION = 8;
    public static final int UPDATE_RUN_JS = 9;
    public static final int UPDATE_AUTO_VOL = 10;
    public static final int MOUSE_CLICK = 0;
    public static final int MOUSE_UP = 1;
    public static final int MOUSE_MOVE = 2;
    public static final int MOUSE_DOWN = 3;
    private Vector3i pos;
    private BlockSide side;
    private int action;
    private String string;
    private Vector2i vec2i;
    private int mouseEvent;
    private ItemStack[] upgrades;
    private int redstoneLevel;
    private NameUUIDPair owner;
    private Rotation rotation;
    private boolean autoVolume;

    public CMessageScreenUpdate() {
    }

    public static CMessageScreenUpdate setURL(TileEntityScreen tes, BlockSide side, String url) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.action = 0;
        ret.string = url;
        return ret;
    }

    public static CMessageScreenUpdate setResolution(TileEntityScreen tes, BlockSide side, Vector2i res) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.action = 1;
        ret.vec2i = res;
        return ret;
    }

    public static CMessageScreenUpdate click(TileEntityScreen tes, BlockSide side, int mouseEvent, @Nullable Vector2i pos) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.action = 3;
        ret.mouseEvent = mouseEvent;
        ret.vec2i = pos;
        return ret;
    }

    public CMessageScreenUpdate(TileEntityScreen tes, BlockSide side) {
        this.pos = new Vector3i(tes.m_58899_());
        this.side = side;
        this.action = 2;
    }

    public static CMessageScreenUpdate type(TileEntityScreen tes, BlockSide side, String text) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.string = text;
        ret.action = 4;
        return ret;
    }

    public static CMessageScreenUpdate js(TileEntityScreen tes, BlockSide side, String code) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.string = code;
        ret.action = 9;
        return ret;
    }

    public static CMessageScreenUpdate upgrade(TileEntityScreen tes, BlockSide side) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.action = 5;
        ArrayList<ItemStack> upgrades = tes.getScreen((BlockSide)side).upgrades;
        ret.upgrades = new ItemStack[upgrades.size()];
        for (int i = 0; i < upgrades.size(); ++i) {
            ret.upgrades[i] = upgrades.get(i).m_41777_();
        }
        return ret;
    }

    public static CMessageScreenUpdate jsRedstone(TileEntityScreen tes, BlockSide side, Vector2i vec, int level) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.action = 6;
        ret.vec2i = vec;
        ret.redstoneLevel = level;
        return ret;
    }

    public static CMessageScreenUpdate owner(TileEntityScreen tes, BlockSide side, NameUUIDPair owner) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.action = 7;
        ret.owner = owner;
        return ret;
    }

    public static CMessageScreenUpdate rotation(TileEntityScreen tes, BlockSide side, Rotation rot) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.action = 8;
        ret.rotation = rot;
        return ret;
    }

    public static CMessageScreenUpdate autoVolume(TileEntityScreen tes, BlockSide side, boolean av) {
        CMessageScreenUpdate ret = new CMessageScreenUpdate();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.action = 10;
        ret.autoVolume = av;
        return ret;
    }

    public static CMessageScreenUpdate decode(FriendlyByteBuf buf) {
        Vector3i pos = new Vector3i((ByteBuf)buf);
        BlockSide side = BlockSide.values()[buf.readByte()];
        byte action = buf.readByte();
        CMessageScreenUpdate message = new CMessageScreenUpdate();
        message.pos = pos;
        message.side = side;
        message.action = action;
        switch (action) {
            case 0: 
            case 4: 
            case 9: {
                message.string = buf.m_130277_();
                break;
            }
            case 3: {
                message.mouseEvent = buf.readByte();
                if (message.mouseEvent == 1) break;
                message.vec2i = new Vector2i((ByteBuf)buf);
                break;
            }
            case 1: {
                message.vec2i = new Vector2i((ByteBuf)buf);
                break;
            }
            case 5: {
                message.upgrades = new ItemStack[buf.readByte()];
                for (int i = 0; i < message.upgrades.length; ++i) {
                    message.upgrades[i] = buf.m_130267_();
                }
                break;
            }
            case 6: {
                message.vec2i = new Vector2i((ByteBuf)buf);
                message.redstoneLevel = buf.readByte();
                break;
            }
            case 7: {
                message.owner = new NameUUIDPair(buf);
                break;
            }
            case 8: {
                message.rotation = Rotation.values()[buf.readByte() & 3];
                break;
            }
            case 10: {
                message.autoVolume = buf.readBoolean();
            }
        }
        return message;
    }

    public CMessageScreenUpdate encode(FriendlyByteBuf buf) {
        this.pos.writeTo((ByteBuf)buf);
        buf.writeByte(this.side.ordinal());
        buf.writeByte(this.action);
        if (this.action == 0 || this.action == 4 || this.action == 9) {
            buf.m_130070_(this.string);
        } else if (this.action == 3) {
            buf.writeByte(this.mouseEvent);
            if (this.mouseEvent != 1) {
                this.vec2i.writeTo((ByteBuf)buf);
            }
        } else if (this.action == 1) {
            this.vec2i.writeTo((ByteBuf)buf);
        } else if (this.action == 5) {
            buf.writeByte(this.upgrades.length);
            for (ItemStack is : this.upgrades) {
                buf.m_130055_(is);
            }
        } else if (this.action == 6) {
            this.vec2i.writeTo((ByteBuf)buf);
            buf.writeByte(this.redstoneLevel);
        } else if (this.action == 7) {
            this.owner.writeTo(buf);
        } else if (this.action == 8) {
            buf.writeByte(this.rotation.ordinal());
        } else if (this.action == 10) {
            buf.writeBoolean(this.autoVolume);
        }
        return new CMessageScreenUpdate();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            BlockEntity te = WebDisplays.PROXY.getWorld((ResourceKey<Level>)Level.f_46428_).m_7702_(this.pos.toBlock());
            if (!(te instanceof TileEntityScreen)) {
                Log.error("CMessageScreenUpdate: TileEntity at %s is not a screen!", this.pos.toString());
                return;
            }
            TileEntityScreen tes = (TileEntityScreen)te;
            switch (this.action) {
                case 0: {
                    tes.setScreenURL(this.side, this.string);
                    break;
                }
                case 3: {
                    tes.handleMouseEvent(this.side, this.mouseEvent, this.vec2i);
                    break;
                }
                case 2: {
                    tes.removeScreen(this.side);
                    break;
                }
                case 1: {
                    tes.setResolution(this.side, this.vec2i);
                    break;
                }
                case 4: {
                    tes.type(this.side, this.string, null);
                    break;
                }
                case 9: {
                    tes.evalJS(this.side, this.string);
                    break;
                }
                case 5: {
                    tes.updateUpgrades(this.side, this.upgrades);
                    break;
                }
                case 6: {
                    tes.updateJSRedstone(this.side, this.vec2i, this.redstoneLevel);
                    break;
                }
                case 7: {
                    TileEntityScreen.Screen scr = tes.getScreen(this.side);
                    if (scr == null) break;
                    scr.owner = this.owner;
                    break;
                }
                case 8: {
                    tes.setRotation(this.side, this.rotation);
                    break;
                }
                case 10: {
                    tes.setAutoVolume(this.side, this.autoVolume);
                    break;
                }
                default: {
                    Log.warning("Caught invalid CMessageScreenUpdate with action ID %d", this.action);
                }
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

