/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Vector3i;

public class SMessageRequestTEData
implements Runnable {
    private ResourceLocation dim;
    private Vector3i pos;
    private ServerPlayer player;

    public SMessageRequestTEData() {
    }

    public SMessageRequestTEData(BlockEntity te) {
        this.dim = te.m_58904_().m_46472_().m_135782_();
        this.pos = new Vector3i(te.m_58899_());
    }

    public SMessageRequestTEData(ResourceLocation dim, Vector3i pos) {
        this.dim = dim;
        this.pos = pos;
    }

    public static SMessageRequestTEData decode(FriendlyByteBuf buf) {
        return new SMessageRequestTEData(buf.m_130281_(), new Vector3i((ByteBuf)buf));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.dim);
        this.pos.writeTo((ByteBuf)buf);
    }

    @Override
    public void run() {
        if (!this.player.f_19853_.m_46472_().m_135782_().equals((Object)this.dim)) {
            return;
        }
        BlockPos bp = this.pos.toBlock();
        if (this.player.m_20275_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()) > 262144.0) {
            return;
        }
        BlockEntity te = this.player.f_19853_.m_7702_(bp);
        if (te == null) {
            Log.error("MesageRequestTEData: Can't request data of null tile entity at %s", this.pos.toString());
            return;
        }
        if (te instanceof TileEntityScreen) {
            ((TileEntityScreen)te).requestData(this.player);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        this.player = contextSupplier.get().getSender();
        contextSupplier.get().enqueueWork((Runnable)this);
        contextSupplier.get().setPacketHandled(true);
    }
}

