/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

public class SMessageScreenCtrl
implements Runnable {
    public static final int CTRL_SET_URL = 0;
    public static final int CTRL_SHUT_DOWN = 1;
    public static final int CTRL_ADD_FRIEND = 2;
    public static final int CTRL_REMOVE_FRIEND = 3;
    public static final int CTRL_SET_RIGHTS = 4;
    public static final int CTRL_SET_RESOLUTION = 5;
    public static final int CTRL_TYPE = 6;
    public static final int CTRL_REMOVE_UPGRADE = 7;
    public static final int CTRL_LASER_DOWN = 8;
    public static final int CTRL_LASER_MOVE = 9;
    public static final int CTRL_LASER_UP = 10;
    public static final int CTRL_JS_REQUEST = 11;
    public static final int CTRL_SET_ROTATION = 12;
    public static final int CTRL_SET_URL_REMOTE = 13;
    public static final int CTRL_SET_AUTO_VOL = 14;
    private int ctrl;
    private ResourceLocation dim;
    private Vector3i pos;
    private BlockSide side;
    private String url;
    private NameUUIDPair friend;
    private ServerPlayer player;
    private int friendRights;
    private int otherRights;
    private Vector2i vec2i;
    private String text;
    private BlockPos soundPos;
    private ItemStack toRemove;
    private int jsReqID;
    private JSServerRequest jsReqType;
    private Object[] jsReqData;
    private Rotation rotation;
    private Vector3i remoteLoc;
    private boolean autoVol;

    public SMessageScreenCtrl() {
    }

    public static SMessageScreenCtrl setURL(TileEntityScreen tes, BlockSide side, String url, Vector3i remoteLocation) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = remoteLocation == null ? 0 : 13;
        ret.dim = tes.m_58904_().m_46472_().m_135782_();
        ret.pos = new Vector3i(tes.m_58899_());
        ret.side = side;
        ret.url = url;
        if (remoteLocation != null) {
            ret.remoteLoc = remoteLocation;
        }
        return ret;
    }

    public SMessageScreenCtrl(TileEntityScreen tes, BlockSide side, NameUUIDPair friend, boolean del) {
        this.ctrl = del ? 3 : 2;
        this.dim = tes.m_58904_().m_46472_().m_135782_();
        this.pos = new Vector3i(tes.m_58899_());
        this.side = side;
        this.friend = friend;
    }

    public SMessageScreenCtrl(TileEntityScreen tes, BlockSide side, int fr, int or) {
        this.ctrl = 4;
        this.dim = tes.m_58904_().m_46472_().m_135782_();
        this.pos = new Vector3i(tes.m_58899_());
        this.side = side;
        this.friendRights = fr;
        this.otherRights = or;
    }

    public SMessageScreenCtrl(TileEntityScreen tes, BlockSide side, ItemStack toRem) {
        this.ctrl = 7;
        this.dim = tes.m_58904_().m_46472_().m_135782_();
        this.pos = new Vector3i(tes.m_58899_());
        this.side = side;
        this.toRemove = toRem;
    }

    public SMessageScreenCtrl(TileEntityScreen tes, BlockSide side, Rotation rot) {
        this.ctrl = 12;
        this.dim = tes.m_58904_().m_46472_().m_135782_();
        this.pos = new Vector3i(tes.m_58899_());
        this.side = side;
        this.rotation = rot;
    }

    public static SMessageScreenCtrl type(TileEntityScreen tes, BlockSide side, String text, BlockPos soundPos) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = 6;
        ret.pos = new Vector3i(tes.m_58899_());
        ret.dim = tes.m_58904_().m_46472_().m_135782_();
        ret.side = side;
        ret.text = text;
        ret.soundPos = soundPos;
        return ret;
    }

    public static SMessageScreenCtrl vec2(TileEntityScreen tes, BlockSide side, int ctrl, Vector2i vec) {
        if (!SMessageScreenCtrl.isVec2Ctrl(ctrl)) {
            throw new RuntimeException("Called SMessageScreenCtrl.vec2() with non-vec2 control message " + ctrl);
        }
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = ctrl;
        ret.pos = new Vector3i(tes.m_58899_());
        ret.dim = tes.m_58904_().m_46472_().m_135782_();
        ret.side = side;
        ret.vec2i = vec;
        return ret;
    }

    public static SMessageScreenCtrl laserUp(TileEntityScreen tes, BlockSide side) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = 10;
        ret.pos = new Vector3i(tes.m_58899_());
        ret.dim = tes.m_58904_().m_46472_().m_135782_();
        ret.side = side;
        return ret;
    }

    public static SMessageScreenCtrl jsRequest(TileEntityScreen tes, BlockSide side, int reqId, JSServerRequest reqType, Object ... data) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = 11;
        ret.pos = new Vector3i(tes.m_58899_());
        ret.dim = tes.m_58904_().m_46472_().m_135782_();
        ret.side = side;
        ret.jsReqID = reqId;
        ret.jsReqType = reqType;
        ret.jsReqData = data;
        return ret;
    }

    public static SMessageScreenCtrl autoVol(TileEntityScreen tes, BlockSide side, boolean av) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = 14;
        ret.pos = new Vector3i(tes.m_58899_());
        ret.dim = tes.m_58904_().m_46472_().m_135782_();
        ret.side = side;
        ret.autoVol = av;
        return ret;
    }

    private static boolean isVec2Ctrl(int msg) {
        return msg == 5 || msg == 8 || msg == 9;
    }

    public static SMessageScreenCtrl decode(FriendlyByteBuf buf) {
        SMessageScreenCtrl message = new SMessageScreenCtrl();
        message.ctrl = buf.readByte();
        message.dim = buf.m_130281_();
        message.pos = new Vector3i((ByteBuf)buf);
        message.side = BlockSide.fromInt(buf.readByte());
        if (message.ctrl == 0) {
            message.url = buf.m_130277_();
        } else if (message.ctrl == 2 || message.ctrl == 3) {
            message.friend = new NameUUIDPair(buf);
        } else if (message.ctrl == 4) {
            message.friendRights = buf.readByte();
            message.otherRights = buf.readByte();
        } else if (SMessageScreenCtrl.isVec2Ctrl(message.ctrl)) {
            message.vec2i = new Vector2i((ByteBuf)buf);
        } else if (message.ctrl == 6) {
            message.text = buf.m_130277_();
            int sx = buf.readInt();
            int sy = buf.readInt();
            int sz = buf.readInt();
            message.soundPos = new BlockPos(sx, sy, sz);
        } else if (message.ctrl == 7) {
            message.toRemove = buf.m_130267_();
        } else if (message.ctrl == 11) {
            message.jsReqID = buf.readInt();
            message.jsReqType = JSServerRequest.fromID(buf.readByte());
            if (message.jsReqType != null) {
                message.jsReqData = message.jsReqType.deserialize(buf);
            }
        } else if (message.ctrl == 12) {
            message.rotation = Rotation.values()[buf.readByte() & 3];
        } else if (message.ctrl == 13) {
            message.url = buf.m_130277_();
            message.remoteLoc = new Vector3i((ByteBuf)buf);
        } else if (message.ctrl == 14) {
            message.autoVol = buf.readBoolean();
        }
        return message;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.ctrl);
        buf.m_130085_(this.dim);
        this.pos.writeTo((ByteBuf)buf);
        buf.writeByte(this.side.ordinal());
        if (this.ctrl == 0) {
            buf.m_130070_(this.url);
        } else if (this.ctrl == 2 || this.ctrl == 3) {
            this.friend.writeTo(buf);
        } else if (this.ctrl == 4) {
            buf.writeByte(this.friendRights);
            buf.writeByte(this.otherRights);
        } else if (SMessageScreenCtrl.isVec2Ctrl(this.ctrl)) {
            this.vec2i.writeTo((ByteBuf)buf);
        } else if (this.ctrl == 6) {
            buf.m_130070_(this.text);
            buf.writeInt(this.soundPos.m_123341_());
            buf.writeInt(this.soundPos.m_123342_());
            buf.writeInt(this.soundPos.m_123343_());
        } else if (this.ctrl == 7) {
            buf.m_130055_(this.toRemove);
        } else if (this.ctrl == 11) {
            buf.writeInt(this.jsReqID);
            buf.writeByte(this.jsReqType.ordinal());
            if (!this.jsReqType.serialize(buf, this.jsReqData)) {
                throw new RuntimeException("Could not serialize CTRL_JS_REQUEST " + this.jsReqType);
            }
        } else if (this.ctrl == 12) {
            buf.writeByte(this.rotation.ordinal());
        } else if (this.ctrl == 13) {
            buf.m_130070_(this.url);
            this.remoteLoc.writeTo((ByteBuf)buf);
        } else if (this.ctrl == 14) {
            buf.writeBoolean(this.autoVol);
        }
    }

    @Override
    public void run() {
        if (this.side == null) {
            Log.warning("Caught invalid packet from %s (UUID %s) referencing an invalid block side", this.player.m_7755_(), this.player.m_36316_().getId().toString());
            return;
        }
        try {
            this.runUnsafe();
        }
        catch (MissingPermissionException e) {
            Log.errorEx("I have reasons to believe %s (UUID %s) is a hacker, but don't take my word for it...", e, e.getPlayer().m_7755_(), e.getPlayer().m_36316_().getId().toString());
        }
    }

    private void checkPermission(TileEntityScreen scr, int right) throws MissingPermissionException {
        int prights = scr.getScreen(this.side).rightsFor((Player)this.player);
        if ((prights & right) == 0) {
            throw new MissingPermissionException(right, this.player);
        }
    }

    private void runUnsafe() throws MissingPermissionException {
        BlockEntity te;
        Level world = this.player.f_19853_;
        BlockPos bp = this.pos.toBlock();
        if (!world.m_46472_().m_135782_().equals((Object)this.dim)) {
            return;
        }
        if (this.ctrl == 13) {
            double reachDist = this.player.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get());
            BlockPos blockPos = this.remoteLoc.toBlock();
            if (this.player.m_20275_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()) > reachDist * reachDist) {
                return;
            }
            BlockState bs = world.m_8055_(blockPos);
            if (bs.m_60734_() != BlockInit.blockServer.get() && bs.m_60734_() != BlockInit.blockRControl.get() && bs.m_60734_() != BlockInit.blockKeyBoard.get() && bs.m_60734_() != BlockInit.blockRedControl.get() && bs.m_61143_(BlockPeripheral.type) != DefaultPeripheral.REMOTE_CONTROLLER) {
                return;
            }
        } else if (this.player.m_20275_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()) > 16384.0) {
            return;
        }
        if ((te = world.m_7702_(bp)) == null || !(te instanceof TileEntityScreen)) {
            Log.error("TileEntity at %s is not a screen; can't control it!", this.pos.toString());
            return;
        }
        TileEntityScreen tes = (TileEntityScreen)te;
        if (this.ctrl == 0 || this.ctrl == 13) {
            this.checkPermission(tes, 1);
            tes.setScreenURL(this.side, this.url);
        } else if (this.ctrl != 1) {
            if (this.ctrl == 2) {
                this.checkPermission(tes, 4);
                tes.addFriend(this.player, this.side, this.friend);
            } else if (this.ctrl == 3) {
                this.checkPermission(tes, 4);
                tes.removeFriend(this.player, this.side, this.friend);
            } else if (this.ctrl == 4) {
                TileEntityScreen.Screen scr = tes.getScreen(this.side);
                if (scr != null) {
                    int or;
                    int fr = scr.owner.uuid.equals(this.player.m_36316_().getId()) ? this.friendRights : scr.friendRights;
                    int n = or = (scr.rightsFor((Player)this.player) & 8) == 0 ? scr.otherRights : this.otherRights;
                    if (scr.friendRights != fr || scr.otherRights != or) {
                        tes.setRights(this.player, this.side, fr, or);
                    }
                }
            } else if (this.ctrl == 5) {
                this.checkPermission(tes, 32);
                tes.setResolution(this.side, this.vec2i);
            } else if (this.ctrl == 6) {
                this.checkPermission(tes, 2);
                tes.type(this.side, this.text, this.soundPos);
            } else if (this.ctrl == 7) {
                this.checkPermission(tes, 16);
                tes.removeUpgrade(this.side, this.toRemove, (Player)this.player);
            } else if (this.ctrl == 8 || this.ctrl == 9) {
                tes.laserDownMove(this.side, (Player)this.player, this.vec2i, this.ctrl == 8);
            } else if (this.ctrl == 10) {
                tes.laserUp(this.side, (Player)this.player);
            } else if (this.ctrl == 11) {
                if (this.jsReqType == null || this.jsReqData == null) {
                    Log.warning("Caught invalid JS request from player %s (UUID %s)", this.player.m_7755_(), this.player.m_36316_().getId().toString());
                } else {
                    tes.handleJSRequest(this.player, this.side, this.jsReqID, this.jsReqType, this.jsReqData);
                }
            } else if (this.ctrl == 12) {
                this.checkPermission(tes, 32);
                tes.setRotation(this.side, this.rotation);
            } else if (this.ctrl == 14) {
                this.checkPermission(tes, 16);
                tes.setAutoVolume(this.side, this.autoVol);
            } else {
                Log.warning("Caught SMessageScreenCtrl with invalid control ID %d from player %s (UUID %s)", this.ctrl, this.player.m_7755_(), this.player.m_36316_().getId().toString());
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        this.player = contextSupplier.get().getSender();
        contextSupplier.get().enqueueWork((Runnable)this);
        contextSupplier.get().setPacketHandled(true);
    }
}

