/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public final class IdMapUniforms {
    private IdMapUniforms() {
    }

    public static void addIdMapUniforms(DynamicUniformHolder uniforms, IdMap idMap) {
        uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "heldItemId", new HeldItemSupplier(InteractionHand.MAIN_HAND, idMap.getItemIdMap())).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldItemId2", new HeldItemSupplier(InteractionHand.OFF_HAND, idMap.getItemIdMap()));
        uniforms.uniform1i("entityId", CapturedRenderingState.INSTANCE::getCurrentRenderedEntity, CapturedRenderingState.INSTANCE.getEntityIdNotifier());
        uniforms.uniform1i("blockEntityId", CapturedRenderingState.INSTANCE::getCurrentRenderedBlockEntity, CapturedRenderingState.INSTANCE.getBlockEntityIdNotifier());
    }

    private static class HeldItemSupplier
    implements IntSupplier {
        private final InteractionHand hand;
        private final Object2IntFunction<NamespacedId> itemIdMap;

        HeldItemSupplier(InteractionHand hand, Object2IntFunction<NamespacedId> itemIdMap) {
            this.hand = hand;
            this.itemIdMap = itemIdMap;
        }

        @Override
        public int getAsInt() {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return -1;
            }
            ItemStack heldStack = Minecraft.m_91087_().f_91074_.m_21120_(this.hand);
            ResourceLocation heldItemId = Registry.f_122827_.m_7981_((Object)heldStack.m_41720_());
            return this.itemIdMap.applyAsInt((Object)new NamespacedId(heldItemId.m_135827_(), heldItemId.m_135815_()));
        }
    }
}

