/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.discord;

import java.util.concurrent.TimeUnit;
import me.hypherionmc.discordapi.DiscordEventHandlers;
import me.hypherionmc.discordapi.DiscordRPC;
import me.hypherionmc.discordapi.DiscordRichPresence;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.configuration.ClientConfig;
import me.hypherionmc.simplerpclib.discord.RichPresenceCore;

public class DiscordController {
    private final DiscordRPC discordRPC;
    private final ClientConfig clientConfig;

    public DiscordController(ClientConfig clientConfig) {
        block2: {
            this.clientConfig = clientConfig;
            this.discordRPC = DiscordRPC.INSTANCE;
            try {
                DiscordEventHandlers handlers = new DiscordEventHandlers();
                handlers.ready = user -> RPCConstants.logger.info("Connected and Ready!");
                this.discordRPC.Discord_Initialize(String.valueOf(clientConfig.general.discordid), handlers, false, "");
                RichPresenceCore.taskManager.scheduleAtFixedRate(this.discordRPC::Discord_RunCallbacks, 0L, 500L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (clientConfig == null || !clientConfig.general.debugging) break block2;
                RPCConstants.logger.error("Failed to connect to discord", (Throwable)e);
            }
        }
    }

    public void updateRichPresence(DiscordRichPresence presence) {
        block5: {
            try {
                if (this.discordRPC != null) {
                    if (presence == null) {
                        this.discordRPC.Discord_ClearPresence();
                    } else {
                        this.discordRPC.Discord_UpdatePresence(presence);
                    }
                }
            }
            catch (Exception e) {
                if (this.clientConfig == null || !this.clientConfig.general.debugging) break block5;
                RPCConstants.logger.error("Failed to update Rich Presence", (Throwable)e);
            }
        }
    }

    public void shutdownRichPresence() {
        if (this.discordRPC != null) {
            this.discordRPC.Discord_ClearPresence();
            this.discordRPC.Discord_Shutdown();
        }
    }
}

