/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements PehkuiEntityExtensions {
    @Shadow
    boolean f_19861_;
    @Shadow
    boolean f_19803_;
    private Map<ScaleType, ScaleData> pehkui_scaleTypes = new Object2ObjectOpenHashMap();
    private boolean pehkui_shouldSyncScales = false;
    private boolean pehkui_shouldIgnoreScaleNbt = false;
    @Unique
    private static final ThreadLocal<Entity> pehkui$COLLIDING = new ThreadLocal();

    @Override
    public ScaleData pehkui_constructScaleData(ScaleType type) {
        return ScaleData.Builder.create().type(type).entity((Entity)this).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScaleData pehkui_getScaleData(ScaleType type) {
        Map<ScaleType, ScaleData> scaleTypes;
        Map<ScaleType, ScaleData> map = scaleTypes = this.pehkui_getScales();
        synchronized (map) {
            ScaleData scaleData = scaleTypes.get(type);
            if (scaleData == null && !scaleTypes.containsKey(type)) {
                scaleTypes.put(type, null);
                scaleData = this.pehkui_constructScaleData(type);
                scaleTypes.put(type, scaleData);
            }
            return scaleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ScaleType, ScaleData> pehkui_getScales() {
        if (this.pehkui_scaleTypes == null) {
            EntityMixin entityMixin = this;
            synchronized (entityMixin) {
                if (this.pehkui_scaleTypes == null) {
                    this.pehkui_scaleTypes = new Object2ObjectOpenHashMap();
                }
            }
        }
        return this.pehkui_scaleTypes;
    }

    @Override
    public void pehkui_setShouldSyncScales(boolean sync) {
        this.pehkui_shouldSyncScales = sync;
    }

    @Override
    public boolean pehkui_shouldSyncScales() {
        return this.pehkui_shouldSyncScales;
    }

    @Override
    public boolean pehkui_shouldIgnoreScaleNbt() {
        return this.pehkui_shouldIgnoreScaleNbt;
    }

    @Override
    public void pehkui_setShouldIgnoreScaleNbt(boolean ignore) {
        this.pehkui_shouldIgnoreScaleNbt = ignore;
    }

    @Inject(at={@At(value="HEAD")}, method={"readNbt"})
    private void pehkui$readNbt(CompoundTag tag, CallbackInfo info) {
        this.pehkui_readScaleNbt(tag);
    }

    @Override
    public void pehkui_readScaleNbt(CompoundTag nbt) {
        if (this.pehkui_shouldIgnoreScaleNbt()) {
            return;
        }
        if (nbt.m_128425_("pehkui:scale_data_types", 10) && !DebugCommand.unmarkEntityForScaleReset((Entity)this, nbt)) {
            CompoundTag typeData = nbt.m_128469_("pehkui:scale_data_types");
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                String key = ((ResourceLocation)entry.getKey()).toString();
                if (!typeData.m_128425_(key, 10)) continue;
                ScaleData scaleData = this.pehkui_getScaleData((ScaleType)entry.getValue());
                scaleData.readNbt(typeData.m_128469_(key));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"writeNbt"})
    private void pehkui$writeNbt(CompoundTag tag, CallbackInfoReturnable<CompoundTag> info) {
        this.pehkui_writeScaleNbt(tag);
    }

    @Override
    public CompoundTag pehkui_writeScaleNbt(CompoundTag nbt) {
        if (this.pehkui_shouldIgnoreScaleNbt()) {
            return nbt;
        }
        CompoundTag typeData = new CompoundTag();
        for (Map.Entry<ScaleType, ScaleData> entry : this.pehkui_getScales().entrySet()) {
            CompoundTag compound = entry.getValue().writeNbt(new CompoundTag());
            if (compound.m_128440_() == 0) continue;
            typeData.m_128365_(ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, entry.getKey()).toString(), (Tag)compound);
        }
        if (typeData.m_128440_() > 0) {
            nbt.m_128365_("pehkui:scale_data_types", (Tag)typeData);
        }
        return nbt;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void pehkui$tick(CallbackInfo info) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleUtils.tickScale(this.pehkui_getScaleData(type));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getDimensions"}, cancellable=true)
    private void pehkui$getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> info) {
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((Entity)this);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((Entity)this);
        if (widthScale != 1.0f || heightScale != 1.0f) {
            info.setReturnValue((Object)((EntityDimensions)info.getReturnValue()).m_20390_(widthScale, heightScale));
        }
    }

    @ModifyVariable(method={"dropStack(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/ItemEntity;"}, at=@At(value="STORE"))
    private ItemEntity pehkui$dropStack(ItemEntity entity) {
        ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
        return entity;
    }

    @ModifyConstant(method={"move"}, constant={@Constant(doubleValue=1.0E-7)})
    private double pehkui$move$minVelocity(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale < 1.0f ? (double)(scale * scale) * value : value;
    }

    @ModifyArg(method={"move"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;adjustMovementForSneaking(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/MovementType;)Lnet/minecraft/util/math/Vec3d;"))
    private Vec3 pehkui$move$adjustMovementForSneaking(Vec3 movement, MoverType type) {
        if (type == MoverType.SELF || type == MoverType.PLAYER) {
            return movement.m_82490_((double)ScaleUtils.getMotionScale((Entity)this));
        }
        return movement;
    }

    @Inject(at={@At(value="HEAD")}, method={"pushAwayFrom"})
    private void pehkui$pushAwayFrom(Entity other, CallbackInfo info) {
        pehkui$COLLIDING.set(other);
    }

    @ModifyArg(method={"pushAwayFrom"}, index=0, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    private double pehkui$pushOtherAwayFrom$ownX(double value) {
        return value * (double)ScaleUtils.getMotionScale(pehkui$COLLIDING.get());
    }

    @ModifyArg(method={"pushAwayFrom"}, index=2, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    private double pehkui$pushOtherAwayFrom$ownZ(double value) {
        return value * (double)ScaleUtils.getMotionScale(pehkui$COLLIDING.get());
    }

    @ModifyArg(method={"pushAwayFrom"}, index=0, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    private double pehkui$pushOtherAwayFrom$otherX(double value) {
        return value * (double)ScaleUtils.getMotionScale((Entity)this);
    }

    @ModifyArg(method={"pushAwayFrom"}, index=2, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    private double pehkui$pushOtherAwayFrom$otherZ(double value) {
        return value * (double)ScaleUtils.getMotionScale((Entity)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnSprintingParticles"}, cancellable=true)
    private void pehkui$spawnSprintingParticles(CallbackInfo info) {
        if (ScaleUtils.getMotionScale((Entity)this) < 1.0f) {
            info.cancel();
        }
    }

    @Override
    public boolean pehkui_isFirstUpdate() {
        return this.f_19803_;
    }

    @Override
    public boolean pehkui_getOnGround() {
        return this.f_19861_;
    }

    @Override
    public void pehkui_setOnGround(boolean onGround) {
        this.f_19861_ = onGround;
    }
}

