/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.bit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.client.model.baked.bit.BitBlockBakedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.client.time.TickHandler;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BitBlockBakedModelManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BitBlockBakedModelManager INSTANCE = new BitBlockBakedModelManager();
    private final Cache<BlockInformation, BakedModel> modelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<BlockInformation, BakedModel> largeModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final NonNullList<ItemStack> alternativeStacks = NonNullList.m_122779_();

    private BitBlockBakedModelManager() {
    }

    public static BitBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.modelCache.asMap().clear();
        this.largeModelCache.asMap().clear();
    }

    public BakedModel get(ItemStack stack, Level world, LivingEntity entity) {
        return this.get(stack, world, entity, !Minecraft.m_91087_().f_91066_.f_92090_.m_90862_() && Minecraft.m_91087_().f_91066_.f_92090_.m_90857_() || Minecraft.m_91087_().m_91268_() != null && Screen.m_96638_());
    }

    public BakedModel get(ItemStack stack, Level world, LivingEntity entity, boolean large) {
        if (!(stack.m_41720_() instanceof IBitItem)) {
            LOGGER.warn("Tried to get bit item model for non bit item");
            return NullBakedModel.instance;
        }
        BakedModel model = this.get(large, ((IBitItem)stack.m_41720_()).getBlockInformation(stack), world, entity);
        return model.m_7343_().m_173464_(model, stack, null, null, 0);
    }

    public BakedModel get(boolean large, BlockInformation blockInformation, Level level, LivingEntity entity) {
        if (blockInformation.isAir() || blockInformation == null) {
            int alternativeIndex;
            ItemStack alternativeStack;
            if (this.alternativeStacks.isEmpty()) {
                ModItems.ITEM_BLOCK_BIT.get().m_6787_(Objects.requireNonNull(ModItems.ITEM_BLOCK_BIT.get().m_41471_()), this.alternativeStacks);
            }
            if (!((alternativeStack = (ItemStack)this.alternativeStacks.get(alternativeIndex = (int)(Math.floor((double)TickHandler.getClientTicks() / 20.0) % (double)this.alternativeStacks.size()))).m_41720_() instanceof IBitItem)) {
                throw new IllegalStateException("BitItem returned none bit item stack!");
            }
            blockInformation = ((IBitItem)alternativeStack.m_41720_()).getBlockInformation(alternativeStack);
        }
        Cache<BlockInformation, BakedModel> target = large ? this.largeModelCache : this.modelCache;
        BlockInformation workingState = blockInformation;
        try {
            return (BakedModel)target.get((Object)blockInformation, () -> {
                if (large) {
                    ItemStack lookupStack = IStateVariantManager.getInstance().getItemStack(workingState).orElseGet(() -> new ItemStack((ItemLike)workingState.getBlockState().m_60734_()));
                    if (workingState.getBlockState().m_60734_() instanceof LiquidBlock) {
                        lookupStack = new ItemStack((ItemLike)workingState.getBlockState().m_60819_().m_76152_().m_6859_());
                    }
                    return Minecraft.m_91087_().m_91291_().m_174264_(lookupStack, level, entity, 0);
                }
                return new BitBlockBakedModel(workingState);
            });
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to get a model for a bit: " + blockInformation + " the model calculation got aborted.", (Throwable)e);
            return NullBakedModel.instance;
        }
    }
}

