/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.profiling.IProfilerResult;
import mod.chiselsandbits.api.profiling.IProfilingManager;
import mod.chiselsandbits.api.util.BlockStateUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.network.packets.ExportPatternCommandMessagePacket;
import mod.chiselsandbits.network.packets.ImportPatternCommandMessagePacket;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.CommandUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandManager {
    private static final CommandManager INSTANCE = new CommandManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SimpleCommandExceptionType GIVE_NOT_CHISELABLE_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslatableComponent(LocalStrings.CommandGiveErrorBlockStateNotChiselable.toString()));

    private CommandManager() {
    }

    public static CommandManager getInstance() {
        return INSTANCE;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"candb").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"fill").then(Commands.m_82129_((String)"start", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"end", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"state", (ArgumentType)BlockStateArgument.m_116120_()).executes(this::runFillCommand))).then(Commands.m_82127_((String)"random").executes(this::runFillCommand)))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"start", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"end", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(this::runClearCommand))))).then(Commands.m_82127_((String)"stats").then(Commands.m_82129_((String)"start", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"end", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(this::runStatsCommand))))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"state", (ArgumentType)BlockStateArgument.m_116120_()).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4096)).executes(this::runGiveCommand))).executes(this::runGiveCommand))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"profiling").then(Commands.m_82127_((String)"start").executes(this::startProfiling))).then(Commands.m_82127_((String)"stop").executes(this::stopProfiling)))).then(Commands.m_82127_((String)"undo").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(this::undoFor)))).then(Commands.m_82127_((String)"redo").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(this::redoFor)))).then(Commands.m_82127_((String)"save").then(Commands.m_82129_((String)"target", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::savePatternOf))))).then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::loadPatternOf))));
    }

    private int runFillCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Vec3 start = Vec3Argument.m_120844_(context, (String)"start");
        Vec3 end = Vec3Argument.m_120844_(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((LevelAccessor)((CommandSourceStack)context.getSource()).m_81372_(), start, end);
        if (CommandUtils.hasArgument(context, "state")) {
            BlockState state = BlockStateArgument.m_116123_(context, (String)"state").m_114669_();
            try (IBatchMutation ignored = ((CommandSourceStack)context.getSource()).m_81373_() != null ? mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker((Player)((CommandSourceStack)context.getSource()).m_81375_())) : mutator.batch();){
                mutator.mutableStream().forEach(entry -> entry.overrideState(new BlockInformation(state)));
            }
        }
        try (IBatchMutation ignored = ((CommandSourceStack)context.getSource()).m_81373_() != null ? mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker((Player)((CommandSourceStack)context.getSource()).m_81375_())) : mutator.batch();){
            mutator.mutableStream().forEach(entry -> entry.overrideState(new BlockInformation(BlockStateUtils.getRandomSupportedDefaultState(((CommandSourceStack)context.getSource()).m_81372_().m_5822_()))));
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent(LocalStrings.CommandFillCompleted.toString()), true);
        return 0;
    }

    private int runClearCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Vec3 start = Vec3Argument.m_120844_(context, (String)"start");
        Vec3 end = Vec3Argument.m_120844_(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((LevelAccessor)((CommandSourceStack)context.getSource()).m_81372_(), start, end);
        try (IBatchMutation ignored = ((CommandSourceStack)context.getSource()).m_81373_() != null ? mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker((Player)((CommandSourceStack)context.getSource()).m_81375_())) : mutator.batch();){
            mutator.mutableStream().forEach(IMutableStateEntryInfo::clear);
        }
        return 0;
    }

    private int runStatsCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Vec3 start = Vec3Argument.m_120844_(context, (String)"start");
        Vec3 end = Vec3Argument.m_120844_(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((LevelAccessor)((CommandSourceStack)context.getSource()).m_81372_(), start, end);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Collected the following statistics for the requested area:"), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("----------------------------------------------------------"), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("BlockStates:"), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("############"), true);
        mutator.createSnapshot().getStatics().getStateCounts().forEach((state, count) -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" > ").m_7220_((Component)state.getBlockState().m_60734_().m_49954_()).m_7220_((Component)new TextComponent(": " + count)), true));
        return 0;
    }

    private int runGiveCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"target");
        BlockState state = BlockStateArgument.m_116123_(context, (String)"state").m_114669_();
        if (!IEligibilityManager.getInstance().canBeChiseled(state)) {
            throw GIVE_NOT_CHISELABLE_EXCEPTION.create();
        }
        int count = CommandUtils.hasArgument(context, "count") ? IntegerArgumentType.getInteger(context, (String)"count") : 4096;
        IBitInventory inventory = IBitInventoryManager.getInstance().create((Player)target);
        int insertionCount = Math.min(inventory.getMaxInsertAmount(new BlockInformation(state)), count);
        inventory.insertOrDiscard(new BlockInformation(state), insertionCount);
        return 0;
    }

    private int startProfiling(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (ProfilingManager.getInstance().hasProfiler()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Already profiling!"));
            return 1;
        }
        ProfilingManager.getInstance().setProfiler(IProfilingManager.getInstance().startProfiling(Environment.m_185278_((MinecraftServer)((CommandSourceStack)context.getSource()).m_81377_())));
        return 0;
    }

    private int stopProfiling(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!ProfilingManager.getInstance().hasProfiler()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Not yet profiling!"));
            return 1;
        }
        IProfilerResult result = IProfilingManager.getInstance().stopProfiling(ProfilingManager.getInstance().getProfiler());
        result.writeAsResponse(line -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(line), true));
        return 0;
    }

    private int redoFor(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"target");
        IChangeTracker tracker = IChangeTrackerManager.getInstance().getChangeTracker((Player)target);
        if (tracker.getChanges().isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("No changes available to redo"));
            return 1;
        }
        try {
            tracker.redo((Player)target);
            return 0;
        }
        catch (IllegalChangeAttempt e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Can not redo"));
            return 2;
        }
    }

    private int undoFor(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"target");
        IChangeTracker tracker = IChangeTrackerManager.getInstance().getChangeTracker((Player)target);
        if (tracker.getChanges().isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("No changes available to undo"));
            return 1;
        }
        try {
            tracker.undo((Player)target);
            return 0;
        }
        catch (IllegalChangeAttempt e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Can not undo"));
            return 2;
        }
    }

    private int savePatternOf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos target = BlockPosArgument.m_118242_(context, (String)"target");
        String name = StringArgumentType.getString(context, (String)"name");
        ChiselsAndBits.getInstance().getNetworkChannel().sendToPlayer(new ExportPatternCommandMessagePacket(target, name), ((CommandSourceStack)context.getSource()).m_81375_());
        return 0;
    }

    private int loadPatternOf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        ChiselsAndBits.getInstance().getNetworkChannel().sendToPlayer(new ImportPatternCommandMessagePacket(name), ((CommandSourceStack)context.getSource()).m_81375_());
        return 0;
    }
}

