/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.List;
import mod.chiselsandbits.api.item.tool.IQuillItem;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.platforms.core.entity.IPlayerInventoryManager;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuillItem
extends Item
implements IQuillItem {
    private final String CONST_INTERACTION = "Interaction";
    private final String CONST_SIMULATION = "Simulation";

    public QuillItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isInteracting(ItemStack stack) {
        return stack.m_41720_() == this && stack.m_41784_().m_128441_("Interaction");
    }

    @Override
    public ItemStack getInteractionTarget(ItemStack stack) {
        return this.isInteracting(stack) ? ItemStack.m_41712_((CompoundTag)stack.m_41698_("Interaction")) : ItemStack.f_41583_;
    }

    @Override
    public boolean isRunningASimulatedInteraction(ItemStack stack) {
        return this.isInteracting(stack) && stack.m_41784_().m_128441_("Simulation");
    }

    @Override
    public float getBobbingTickCount() {
        return 4.0f;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 32;
    }

    public int m_6473_() {
        return 5;
    }

    public static void spawnParticles(Vec3 location, ItemStack polishedStack, Level world) {
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VectorUtils.offsetRandomly(Vec3.f_82478_, world.f_46441_, 0.125f);
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, polishedStack), location.f_82479_, location.f_82480_, location.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        if (this.isInteracting(stack)) {
            ItemStack interactionTarget = this.getInteractionTarget(stack);
            player.m_150109_().m_150079_(interactionTarget);
            stack.m_41784_().m_128473_("Interaction");
        }
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        if (this.isInteracting(stack)) {
            ItemStack target = this.getInteractionTarget(stack);
            ItemStack pattern = QuillItem.createPattern(player);
            if (worldIn.f_46443_) {
                QuillItem.spawnParticles(entityLiving.m_20299_(1.0f).m_82549_(entityLiving.m_20154_().m_82490_(0.5)), target, worldIn);
                return stack;
            }
            if (!pattern.m_41619_()) {
                IPlayerInventoryManager.getInstance().giveToPlayer(player, pattern);
            }
            stack.m_41784_().m_128473_("Interaction");
            stack.m_41622_(1, entityLiving, p -> p.m_21190_(p.m_7655_()));
        }
        return stack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        InteractionResultHolder FAIL = new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        if (this.isInteracting(itemstack)) {
            playerIn.m_6672_(handIn);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        InteractionHand otherHand = handIn == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack itemInOtherHand = playerIn.m_21120_(otherHand);
        if (QuillItem.createPattern(playerIn).m_41720_() != Items.f_42516_ && itemInOtherHand.m_41720_() == Items.f_42516_) {
            ItemStack item = itemInOtherHand.m_41777_();
            ItemStack target = item.m_41620_(1);
            playerIn.m_6672_(handIn);
            itemstack.m_41784_().m_128365_("Interaction", (Tag)target.m_41739_(new CompoundTag()));
            playerIn.m_21008_(otherHand, item);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    private static ItemStack createPattern(Player playerEntity) {
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            return new ItemStack((ItemLike)Items.f_42516_);
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().in((LevelAccessor)playerEntity.m_20193_(), blockRayTraceResult.m_82425_());
        return areaMutator.createSnapshot().toItemStack().toPatternStack();
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        HelpTextUtils.build(LocalStrings.HelpQuill, tooltip, new Object[0]);
    }
}

