/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.api.DisplayMode;
import com.blamejared.controlling.api.SearchType;
import com.blamejared.controlling.api.SortOrder;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.client.FancyCheckbox;
import com.blamejared.controlling.client.FreeKeysList;
import com.blamejared.controlling.client.NewKeyBindsList;
import com.blamejared.controlling.mixin.AccessKeyBindsScreen;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.blamejared.controlling.mixin.AccessScreen;
import com.blamejared.controlling.platform.Services;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class NewKeyBindsScreen
extends KeyBindsScreen {
    private Button buttonReset;
    private final Options options;
    private String lastSearch;
    private EditBox search;
    private DisplayMode displayMode;
    private SearchType searchType;
    private SortOrder sortOrder;
    private Button buttonNone;
    private Button buttonConflicting;
    private FancyCheckbox buttonKey;
    private FancyCheckbox buttonCat;
    private boolean confirmingReset = false;
    private boolean showFree = false;
    private KeyBindsList customKeyList;
    private FreeKeysList freeKeyList;

    public NewKeyBindsScreen(Screen screen, Options settings) {
        super(screen, settings);
        this.options = settings;
    }

    protected void m_7856_() {
        this.customKeyList = new NewKeyBindsList(this, this.f_96541_);
        this.freeKeyList = new FreeKeysList(this, this.f_96541_);
        this.setKeyBindsList(this.customKeyList);
        this.m_7787_((GuiEventListener)this.getKeyBindsList());
        this.m_7522_((GuiEventListener)this.getKeyBindsList());
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160, this.f_96544_ - 29, 150, 20, (Component)new TranslatableComponent("gui.done"), btn -> Objects.requireNonNull(this.f_96541_).m_91152_(this.f_96281_)));
        this.buttonReset = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 29, 74, 20, (Component)new TranslatableComponent("controls.resetAll"), btn -> {
            if (!this.confirmingReset) {
                this.confirmingReset = true;
                btn.m_93666_((Component)new TranslatableComponent("options.confirmReset"));
                return;
            }
            this.confirmingReset = false;
            btn.m_93666_((Component)new TranslatableComponent("controls.resetAll"));
            for (KeyMapping keybinding : Objects.requireNonNull(this.f_96541_).f_91066_.f_92059_) {
                Services.PLATFORM.setToDefault(this.f_96541_.f_91066_, keybinding);
                KeyMapping.m_90854_();
            }
            KeyMapping.m_90847_();
        }));
        this.buttonNone = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160 + 76, this.f_96544_ - 29 - 24, 75, 20, (Component)new TranslatableComponent("options.showNone"), btn -> {
            if (this.displayMode == DisplayMode.NONE) {
                this.buttonNone.m_93666_((Component)new TranslatableComponent("options.showNone"));
                this.displayMode = DisplayMode.ALL;
            } else {
                this.displayMode = DisplayMode.NONE;
                this.buttonNone.m_93666_((Component)new TranslatableComponent("options.showAll"));
                this.buttonConflicting.m_93666_((Component)new TranslatableComponent("options.showConflicts"));
            }
            this.filterKeys();
        }));
        this.buttonConflicting = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160, this.f_96544_ - 29 - 24, 75, 20, (Component)new TranslatableComponent("options.showConflicts"), btn -> {
            if (this.displayMode == DisplayMode.CONFLICTING) {
                this.buttonConflicting.m_93666_((Component)new TranslatableComponent("options.showConflicts"));
                this.displayMode = DisplayMode.ALL;
            } else {
                this.displayMode = DisplayMode.CONFLICTING;
                this.buttonConflicting.m_93666_((Component)new TranslatableComponent("options.showAll"));
                this.buttonNone.m_93666_((Component)new TranslatableComponent("options.showNone"));
            }
            this.filterKeys();
        }));
        this.search = new EditBox(this.f_96547_, this.f_96543_ / 2 - 154, this.f_96544_ - 29 - 23, 148, 18, TextComponent.f_131282_);
        this.m_7787_((GuiEventListener)this.search);
        this.buttonKey = (FancyCheckbox)this.m_142416_((GuiEventListener)new FancyCheckbox(this.f_96543_ / 2 - 77, this.f_96544_ - 29 - 37, 11, 11, (Component)new TranslatableComponent("options.key"), false, btn -> {
            this.buttonCat.selected(false);
            this.searchType = btn.selected() ? SearchType.KEY : SearchType.NAME;
            this.filterKeys();
        }));
        this.buttonCat = (FancyCheckbox)this.m_142416_((GuiEventListener)new FancyCheckbox(this.f_96543_ / 2 - 77, this.f_96544_ - 29 - 50, 11, 11, (Component)new TranslatableComponent("options.category"), false, btn -> {
            this.buttonKey.selected(false);
            this.searchType = btn.selected() ? SearchType.CATEGORY : SearchType.NAME;
            this.filterKeys();
        }));
        this.sortOrder = SortOrder.NONE;
        Button buttonSort = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160 + 76, this.f_96544_ - 29 - 24 - 24, 75, 20, (Component)new TranslatableComponent("options.sort").m_130946_(": " + this.sortOrder.getName()), btn -> {
            this.sortOrder = this.sortOrder.cycle();
            btn.m_93666_((Component)new TranslatableComponent("options.sort").m_130946_(": " + this.sortOrder.getName()));
            this.filterKeys();
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 76, this.f_96544_ - 29, 74, 20, (Component)new TranslatableComponent("options.toggleFree"), btn -> {
            this.m_169411_((GuiEventListener)this.getKeyBindsList());
            if (this.showFree) {
                buttonSort.f_93623_ = true;
                this.buttonCat.f_93623_ = true;
                this.buttonKey.f_93623_ = true;
                this.buttonNone.f_93623_ = true;
                this.buttonConflicting.f_93623_ = true;
                this.buttonReset.f_93623_ = true;
                this.setKeyBindsList(this.customKeyList);
            } else {
                this.freeKeyList.recalculate();
                buttonSort.f_93623_ = false;
                this.buttonCat.f_93623_ = false;
                this.buttonKey.f_93623_ = false;
                this.buttonNone.f_93623_ = false;
                this.buttonConflicting.f_93623_ = false;
                this.buttonReset.f_93623_ = false;
                this.setKeyBindsList(this.freeKeyList);
            }
            this.m_7787_((GuiEventListener)this.getKeyBindsList());
            this.m_7522_((GuiEventListener)this.getKeyBindsList());
            this.showFree = !this.showFree;
        }));
        this.lastSearch = "";
        this.displayMode = DisplayMode.ALL;
        this.searchType = SearchType.NAME;
    }

    public boolean m_5534_(char character, int code) {
        return this.search.m_5534_(character, code);
    }

    public void m_96624_() {
        this.search.m_94120_();
        if (!this.lastSearch.equals(this.search.m_94155_())) {
            this.filterKeys();
        }
    }

    public void filterKeys() {
        this.lastSearch = this.search.m_94155_();
        this.getKeyBindsList().m_6702_().clear();
        if (this.getKeyBindsList() instanceof NewKeyBindsList) {
            if (this.lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
                this.getKeyBindsList().m_6702_().addAll(((CustomList)this.getKeyBindsList()).getAllEntries());
                return;
            }
            this.getKeyBindsList().m_93410_(0.0);
            Predicate<NewKeyBindsList.KeyEntry> filters = switch (this.searchType) {
                default -> throw new IncompatibleClassChangeError();
                case SearchType.NAME -> this.displayMode.getPredicate().and(keyEntry -> keyEntry.getKeyDesc().toLowerCase().contains(this.lastSearch.toLowerCase()));
                case SearchType.CATEGORY -> this.displayMode.getPredicate().and(keyEntry -> new TranslatableComponent(keyEntry.getKeybinding().m_90858_()).getString().toLowerCase().contains(this.lastSearch.toLowerCase()));
                case SearchType.KEY -> this.displayMode.getPredicate().and(keyEntry -> keyEntry.getKeybinding().m_90863_().getString().toLowerCase().contains(this.lastSearch.toLowerCase()));
            };
            for (KeyBindsList.Entry entry : ((CustomList)this.getKeyBindsList()).getAllEntries()) {
                NewKeyBindsList.KeyEntry keyEntry2;
                if (this.searchType == SearchType.CATEGORY && this.sortOrder == SortOrder.NONE && this.displayMode == DisplayMode.ALL) {
                    if (entry instanceof NewKeyBindsList.KeyEntry) {
                        NewKeyBindsList.KeyEntry keyEntry3 = (NewKeyBindsList.KeyEntry)entry;
                        if (!filters.test(keyEntry3)) continue;
                        this.getKeyBindsList().m_6702_().add(entry);
                        continue;
                    }
                    this.getKeyBindsList().m_6702_().add(entry);
                    continue;
                }
                if (!(entry instanceof NewKeyBindsList.KeyEntry) || !filters.test(keyEntry2 = (NewKeyBindsList.KeyEntry)entry)) continue;
                this.getKeyBindsList().m_6702_().add(entry);
            }
            if (this.searchType == SearchType.CATEGORY && this.sortOrder == SortOrder.NONE && this.displayMode == DisplayMode.ALL) {
                LinkedHashSet<NewKeyBindsList.CategoryEntry> categories = new LinkedHashSet<NewKeyBindsList.CategoryEntry>();
                for (KeyBindsList.Entry entry : this.getKeyBindsList().m_6702_()) {
                    if (!(entry instanceof NewKeyBindsList.CategoryEntry)) continue;
                    NewKeyBindsList.CategoryEntry cEntry = (NewKeyBindsList.CategoryEntry)entry;
                    categories.add(cEntry);
                    for (KeyBindsList.Entry child : this.getKeyBindsList().m_6702_()) {
                        NewKeyBindsList.KeyEntry childEntry;
                        if (!(child instanceof NewKeyBindsList.KeyEntry) || !(childEntry = (NewKeyBindsList.KeyEntry)child).getKeybinding().m_90858_().equals(cEntry.getName())) continue;
                        categories.remove((Object)cEntry);
                    }
                }
                this.getKeyBindsList().m_6702_().removeAll(categories);
            }
            this.sortOrder.sort(this.getKeyBindsList().m_6702_());
        } else if (this.getKeyBindsList() instanceof FreeKeysList) {
            if (this.lastSearch.isEmpty()) {
                this.getKeyBindsList().m_6702_().addAll(((CustomList)this.getKeyBindsList()).getAllEntries());
                return;
            }
            this.getKeyBindsList().m_93410_(0.0);
            for (KeyBindsList.Entry entry : ((CustomList)this.getKeyBindsList()).getAllEntries()) {
                if (entry instanceof FreeKeysList.InputEntry) {
                    FreeKeysList.InputEntry inputEntry = (FreeKeysList.InputEntry)entry;
                    if (!inputEntry.getInput().toString().toLowerCase().contains(this.lastSearch.toLowerCase())) continue;
                    this.getKeyBindsList().m_6702_().add(entry);
                    continue;
                }
                this.getKeyBindsList().m_6702_().add(entry);
            }
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        this.getKeyBindsList().m_6305_(stack, mouseX, mouseY, partialTicks);
        NewKeyBindsScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        boolean flag = false;
        if (!this.showFree) {
            for (KeyMapping keybinding : this.options.f_92059_) {
                if (keybinding.m_90864_()) continue;
                flag = true;
                break;
            }
        }
        this.search.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.buttonReset.f_93623_ = flag;
        if (!flag) {
            this.confirmingReset = false;
            this.buttonReset.m_93666_((Component)new TranslatableComponent("controls.resetAll"));
        }
        TranslatableComponent text = new TranslatableComponent("options.search");
        this.f_96547_.m_92889_(stack, (Component)text, (float)this.f_96543_ / 2.0f - 77.5f - (float)this.f_96547_.m_92895_(text.getString()) - 5.0f, (float)(this.f_96544_ - 29 - 42), 0xFFFFFF);
        for (Widget widget : this.getScreenAccess().controlling$getRenderables()) {
            widget.m_6305_(stack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mx, double my, int mb) {
        boolean valid;
        if (this.f_193975_ != null) {
            this.options.m_92159_(this.f_193975_, InputConstants.Type.MOUSE.m_84895_(mb));
            this.f_193975_ = null;
            KeyMapping.m_90854_();
            valid = true;
            this.search.m_94178_(false);
        } else if (mb == 0 && this.getKeyBindsList().m_6375_(mx, my, mb)) {
            this.m_7897_(true);
            this.m_7522_((GuiEventListener)this.getKeyBindsList());
            valid = true;
            this.search.m_94178_(false);
        } else {
            valid = this.search.m_6375_(mx, my, mb);
            if (!valid && this.search.m_93696_() && mb == 1) {
                this.search.m_94144_("");
                valid = true;
            }
        }
        if (!valid) {
            for (GuiEventListener listeners : this.m_6702_()) {
                if (!listeners.m_6375_(mx, my, mb)) continue;
                this.m_7522_(listeners);
                if (mb == 0) {
                    this.m_7897_(true);
                }
                return true;
            }
        }
        return valid;
    }

    public boolean m_6348_(double mx, double my, int mb) {
        if (mb == 0 && this.getKeyBindsList().m_6348_(mx, my, mb)) {
            this.m_7897_(false);
            return true;
        }
        if (this.search.m_93696_()) {
            return this.search.m_6348_(mx, my, mb);
        }
        this.m_7897_(false);
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (!this.search.m_93696_() && this.f_193975_ == null && NewKeyBindsScreen.m_96637_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)70)) {
            this.search.m_94178_(true);
            return true;
        }
        if (this.search.m_7933_(keyCode, scanCode, modifier)) {
            return true;
        }
        if (this.search.m_93696_() && keyCode == 256) {
            this.search.m_94178_(false);
            return true;
        }
        if (this.f_193975_ != null) {
            if (keyCode == 256) {
                Services.PLATFORM.setKey(this.options, this.f_193975_, InputConstants.f_84822_);
            } else {
                Services.PLATFORM.setKey(this.options, this.f_193975_, InputConstants.m_84827_((int)keyCode, (int)scanCode));
            }
            if (!Services.PLATFORM.isKeyCodeModifier(((AccessKeyMapping)this.f_193975_).controlling$getKey())) {
                this.f_193975_ = null;
            }
            this.f_193976_ = Util.m_137550_();
            KeyMapping.m_90854_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    private KeyBindsList getKeyBindsList() {
        return this.getAccess().controlling$getKeyBindsList();
    }

    private void setKeyBindsList(KeyBindsList newList) {
        this.getAccess().controlling$setKeyBindsList(newList);
    }

    private AccessScreen getScreenAccess() {
        return (AccessScreen)((Object)this);
    }

    private AccessKeyBindsScreen getAccess() {
        return (AccessKeyBindsScreen)((Object)this);
    }
}

