/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.handlers;

import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.handlers.CommonState;
import dynamiclabs.immersivefx.environs.handlers.HandlerBase;
import dynamiclabs.immersivefx.environs.handlers.scripts.ConditionEvaluator;
import dynamiclabs.immersivefx.environs.library.BiomeLibrary;
import dynamiclabs.immersivefx.environs.library.DimensionLibrary;
import dynamiclabs.immersivefx.environs.scanner.CeilingCoverage;
import dynamiclabs.immersivefx.lib.DayCycle;
import dynamiclabs.immersivefx.lib.TickCounter;
import dynamiclabs.immersivefx.lib.WorldUtils;
import dynamiclabs.immersivefx.lib.events.DiagnosticEvent;
import dynamiclabs.immersivefx.lib.resource.ResourceUtils;
import dynamiclabs.immersivefx.lib.seasons.Season;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
class CommonStateHandler
extends HandlerBase {
    private static final double VILLAGE_RANGE = 4096.0;
    private static final List<String> scripts;
    protected final CeilingCoverage ceilingCoverage = new CeilingCoverage();

    CommonStateHandler() {
        super("Common State");
    }

    @Override
    public void process(@Nonnull Player player) {
        long currentTick = TickCounter.getTickCount();
        CommonState data = CommonState.getData();
        Level world = player.m_20193_();
        this.ceilingCoverage.tick();
        data.clock.update(world);
        data.season = Season.getSeason(world);
        data.playerBiome = BiomeLibrary.getPlayerBiome(player, false);
        data.truePlayerBiome = BiomeLibrary.getPlayerBiome(player, true);
        data.dimInfo = DimensionLibrary.getData(world);
        data.dimensionName = data.dimInfo.getName().toString();
        data.playerPosition = player.m_142538_();
        data.playerEyePosition = player.m_20299_(1.0f);
        data.dayCycle = DayCycle.getCycle((LevelAccessor)world);
        data.inside = this.ceilingCoverage.isReallyInside();
        data.biomeTemperature = WorldUtils.getTemperatureAt(world, data.playerPosition);
        data.isUnderground = data.playerBiome == BiomeLibrary.UNDERGROUND_INFO;
        data.isInSpace = data.playerBiome == BiomeLibrary.OUTERSPACE_INFO;
        data.isInClouds = data.playerBiome == BiomeLibrary.CLOUDS_INFO;
        int blockLight = world.m_45517_(LightLayer.BLOCK, data.playerPosition);
        int skyLight = world.m_45517_(LightLayer.SKY, data.playerPosition) - world.m_45524_(data.playerPosition, 0);
        data.lightLevel = Math.max(blockLight, skyLight);
        if (currentTick % 20L == 0L && !world.m_6042_().m_63956_()) {
            data.isInVillage = false;
        }
        ConditionEvaluator.INSTANCE.tick();
    }

    @Override
    public void onDisconnect() {
        CommonState.reset();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void diagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            event.addLeft(ChatFormatting.YELLOW + CommonState.getData().clock.getFormattedTime());
            for (String s : scripts) {
                String result = ConditionEvaluator.INSTANCE.eval(s).toString();
                event.getLeft().add(ChatFormatting.DARK_AQUA + result);
            }
        }
    }

    static {
        String script_lines = ResourceUtils.readResource(new ResourceLocation("environs", "misc/script_debug.txt"));
        assert (script_lines != null);
        scripts = Pattern.compile("\\r?\\n").splitAsStream(script_lines).map(String::trim).filter(s -> !StringUtil.m_14408_((String)s) && !s.startsWith("//")).collect(Collectors.toList());
    }
}

