/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library;

import com.google.common.base.MoreObjects;
import dynamiclabs.immersivefx.environs.handlers.scripts.ConditionEvaluator;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AcousticEntry {
    private final IAcoustic acoustic;
    private final String conditions;

    public AcousticEntry(@Nonnull IAcoustic acoustic, @Nullable String condition) {
        this.acoustic = acoustic;
        this.conditions = condition != null ? condition : "";
    }

    @Nonnull
    public IAcoustic getAcoustic() {
        return this.acoustic;
    }

    @Nonnull
    public String getConditions() {
        return this.conditions;
    }

    public boolean matches() {
        return ConditionEvaluator.INSTANCE.check(this.conditions);
    }

    protected String getConditionsForLogging() {
        String cond = this.getConditions();
        return cond.length() > 0 ? cond : "No Conditions";
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getAcoustic().toString()).addValue((Object)this.getConditionsForLogging()).toString();
    }
}

