/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library;

import dynamiclabs.immersivefx.environs.library.AcousticEntry;
import dynamiclabs.immersivefx.environs.library.FakeBiomeAdapter;
import dynamiclabs.immersivefx.environs.library.IBiome;
import dynamiclabs.immersivefx.environs.library.WeightedAcousticEntry;
import dynamiclabs.immersivefx.environs.library.config.AcousticConfig;
import dynamiclabs.immersivefx.environs.library.config.BiomeConfig;
import dynamiclabs.immersivefx.lib.WeightTable;
import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.lib.gui.Color;
import dynamiclabs.immersivefx.lib.math.MathStuff;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.Library;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public final class BiomeInfo
implements Comparable<BiomeInfo> {
    private static final float DEFAULT_VISIBILITY = 1.0f;
    public static final int DEFAULT_SPOT_CHANCE = 250;
    protected final IBiome biome;
    protected boolean hasAurora;
    private Color fogColor;
    private float visibility = 1.0f;
    protected int spotSoundChance = 250;
    protected final ObjectArray<AcousticEntry> sounds = new ObjectArray();
    protected final ObjectArray<WeightedAcousticEntry> spotSounds = new ObjectArray();
    protected ObjectArray<String> comments;
    protected final boolean isRiver;
    protected final boolean isOcean;
    protected final boolean isDeepOcean;
    protected final String traits;

    public BiomeInfo(@Nonnull IBiome biome) {
        this.biome = biome;
        this.isRiver = this.biome.getTypes().contains(BiomeDictionary.Type.RIVER);
        this.isOcean = this.biome.getTypes().contains(BiomeDictionary.Type.OCEAN);
        this.isDeepOcean = this.isOcean && this.getBiomeName().matches("(?i).*deep.*ocean.*|.*abyss.*");
        this.traits = this.getBiomeTypes().stream().map(BiomeDictionary.Type::getName).collect(Collectors.joining(" "));
    }

    public boolean isRiver() {
        return this.isRiver;
    }

    public boolean isOcean() {
        return this.isOcean;
    }

    public boolean isDeepOcean() {
        return this.isDeepOcean;
    }

    public ResourceLocation getKey() {
        return this.biome.getKey();
    }

    public Biome getBiome() {
        return this.biome.getBiome();
    }

    public Set<BiomeDictionary.Type> getBiomeTypes() {
        return this.biome.getTypes();
    }

    public String getBiomeTraits() {
        return this.traits;
    }

    void addComment(@Nonnull String comment) {
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            if (this.comments == null) {
                this.comments = new ObjectArray();
            }
            this.comments.add(comment);
        }
    }

    public String getBiomeName() {
        String name = this.biome.getName();
        return name == null ? "UNKNOWN" : name;
    }

    public Biome.Precipitation getPrecipitationType() {
        return this.biome.getPrecipitationType();
    }

    public boolean getHasAurora() {
        return this.hasAurora;
    }

    void setHasAurora(boolean flag) {
        this.hasAurora = flag;
    }

    public Color getFogColor() {
        return this.fogColor;
    }

    void setFogColor(@Nonnull Color color) {
        this.fogColor = color;
    }

    public boolean getHasFog() {
        return this.fogColor != null;
    }

    public float getVisibility() {
        return this.visibility;
    }

    void setVisibility(float density) {
        this.visibility = MathStuff.clamp(density, 0.0f, 1.0f);
    }

    void setSpotSoundChance(int chance) {
        this.spotSoundChance = chance;
    }

    public boolean isFake() {
        return this.biome instanceof FakeBiomeAdapter;
    }

    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return this.biome.getFloatTemperature(pos);
    }

    public float getTemperature() {
        return this.biome.getTemperature();
    }

    public boolean isHighHumidity() {
        return this.biome.isHighHumidity();
    }

    public float getRainfall() {
        return this.biome.getDownfall();
    }

    @Nonnull
    public Collection<IAcoustic> findSoundMatches() {
        return this.findSoundMatches(new ObjectArray<IAcoustic>());
    }

    @Nonnull
    public Collection<IAcoustic> findSoundMatches(@Nonnull Collection<IAcoustic> results) {
        for (AcousticEntry sound : this.sounds) {
            if (!sound.matches()) continue;
            results.add(sound.getAcoustic());
        }
        return results;
    }

    @Nullable
    public IAcoustic getSpotSound(@Nonnull Random random) {
        if (this.spotSounds.size() == 0 || random.nextInt(this.spotSoundChance) != 0) {
            return null;
        }
        return (IAcoustic)new WeightTable(this.spotSounds.stream().filter(AcousticEntry::matches).collect(Collectors.toList())).next();
    }

    void resetSounds() {
        this.sounds.clear();
        this.spotSounds.clear();
        this.spotSoundChance = 250;
    }

    public void update(@Nonnull BiomeConfig entry) {
        this.addComment(entry.comment);
        if (entry.hasAurora != null) {
            this.setHasAurora(entry.hasAurora);
        }
        if (entry.visibility != null) {
            this.setVisibility(entry.visibility.floatValue());
        }
        if (entry.fogColor != null) {
            this.setFogColor(Color.parse(entry.fogColor));
        }
        if (entry.soundReset != null && entry.soundReset.booleanValue()) {
            this.addComment("> Sound Reset");
            this.resetSounds();
        }
        if (entry.spotSoundChance != null) {
            this.setSpotSoundChance(entry.spotSoundChance);
        }
        for (AcousticConfig sr : entry.acoustics) {
            ResourceLocation res = Library.resolveResource("environs", sr.acoustic);
            IAcoustic acoustic = Library.resolve(res, sr.acoustic);
            if (sr.type.equalsIgnoreCase("spot")) {
                int weight = sr.weight;
                WeightedAcousticEntry acousticEntry = new WeightedAcousticEntry(acoustic, sr.conditions, weight);
                this.spotSounds.add(acousticEntry);
                continue;
            }
            AcousticEntry acousticEntry = new AcousticEntry(acoustic, sr.conditions);
            this.sounds.add(acousticEntry);
        }
    }

    public void trim() {
        this.sounds.trim();
        this.spotSounds.trim();
        this.comments = null;
    }

    @Nonnull
    public String toString() {
        ResourceLocation rl = this.biome.getKey();
        String registryName = rl == null ? (this.isFake() ? "FAKE" : "UNKNOWN") : rl.toString();
        StringBuilder builder = new StringBuilder();
        builder.append("Biome [").append(this.getBiomeName()).append('/').append(registryName).append("]");
        if (!this.isFake()) {
            builder.append("\n+ ").append('<');
            builder.append(this.getBiomeTraits());
            builder.append('>').append('\n');
            builder.append("+ temp: ").append(this.getTemperature());
            builder.append(" rain: ").append(this.getRainfall());
        }
        if (this.hasAurora) {
            builder.append(" AURORA");
        }
        if (this.fogColor != null) {
            builder.append(" fogColor:").append(this.fogColor.toString());
        }
        builder.append(" visibility:").append(this.visibility);
        if (this.sounds.size() > 0) {
            builder.append("\n+ sounds [\n");
            builder.append(this.sounds.stream().map(c -> "+   " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n+ ]");
        }
        if (this.spotSounds.size() > 0) {
            builder.append("\n+ spot sound chance:").append(this.spotSoundChance);
            builder.append("\n+ spot sounds [\n");
            builder.append(this.spotSounds.stream().map(c -> "+   " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n+ ]");
        }
        if (this.comments != null && this.comments.size() > 0) {
            builder.append("\n+ comments:\n");
            builder.append(this.comments.stream().map(c -> "+   " + c).collect(Collectors.joining("\n")));
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public int compareTo(@Nonnull BiomeInfo o) {
        return this.getBiomeName().compareTo(o.getBiomeName());
    }
}

