/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library;

import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.library.config.DimensionConfig;
import dynamiclabs.immersivefx.lib.WorldUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DimensionInfo {
    private static final int SPACE_HEIGHT_OFFSET = 32;
    public static final DimensionInfo NONE = new DimensionInfo();
    protected ResourceLocation name;
    protected int seaLevel;
    protected int skyHeight;
    protected int cloudHeight;
    protected int spaceHeight;
    protected boolean hasHaze = false;
    protected boolean hasAuroras = false;
    protected boolean hasFog = false;
    protected boolean alwaysOutside = false;
    protected boolean playBiomeSounds = true;
    protected final boolean isFlatWorld;

    DimensionInfo() {
        this.name = new ResourceLocation("environs", "no_dimension");
        this.isFlatWorld = false;
    }

    public DimensionInfo(@Nonnull Level world, @Nullable DimensionConfig dimConfig) {
        DimensionType dt = world.m_6042_();
        this.name = world.m_46472_().m_135782_();
        this.seaLevel = world.m_5736_();
        this.cloudHeight = this.skyHeight = world.m_151558_();
        this.spaceHeight = this.skyHeight + 32;
        this.isFlatWorld = WorldUtils.isSuperFlat(world);
        if (dt.m_63956_() && dt.m_63935_()) {
            this.hasAuroras = true;
            this.hasFog = true;
        }
        if (this.isFlatWorld) {
            this.seaLevel = 0;
        } else if (dt.m_63956_() && (Integer)Config.CLIENT.biome.worldSealevelOverride.get() > 0) {
            this.seaLevel = (Integer)Config.CLIENT.biome.worldSealevelOverride.get();
        }
        if (((List)Config.CLIENT.biome.biomeSoundBlacklist.get()).contains(this.name.toString())) {
            this.playBiomeSounds = false;
        }
        if (dimConfig != null) {
            if (dimConfig.seaLevel != null) {
                this.seaLevel = dimConfig.seaLevel;
            }
            if (dimConfig.skyHeight != null) {
                this.skyHeight = dimConfig.skyHeight;
            }
            if (dimConfig.hasHaze != null) {
                this.hasHaze = dimConfig.hasHaze;
            }
            if (dimConfig.hasAurora != null) {
                this.hasAuroras = dimConfig.hasAurora;
            }
            if (dimConfig.cloudHeight != null) {
                this.cloudHeight = dimConfig.cloudHeight;
            } else {
                int n = this.cloudHeight = this.hasHaze ? this.skyHeight / 2 : this.skyHeight;
            }
            if (dimConfig.hasFog != null) {
                this.hasFog = dimConfig.hasFog;
            }
            if (dimConfig.alwaysOutside != null) {
                this.alwaysOutside = dimConfig.alwaysOutside;
            }
            this.spaceHeight = this.skyHeight + 32;
        }
    }

    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public int getSkyHeight() {
        return this.skyHeight;
    }

    public int getCloudHeight() {
        return this.cloudHeight;
    }

    public int getSpaceHeight() {
        return this.spaceHeight;
    }

    public boolean hasHaze() {
        return this.hasHaze;
    }

    public boolean hasAuroras() {
        return this.hasAuroras;
    }

    public boolean hasFog() {
        return this.hasFog;
    }

    public boolean playBiomeSounds() {
        return this.playBiomeSounds;
    }

    public boolean alwaysOutside() {
        return this.alwaysOutside;
    }

    public boolean isFlatWorld() {
        return this.isFlatWorld;
    }
}

