/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import dynamiclabs.immersivefx.environs.Environs;
import dynamiclabs.immersivefx.environs.library.config.AcousticConfig;
import dynamiclabs.immersivefx.lib.validation.IValidator;
import dynamiclabs.immersivefx.lib.validation.ValidationException;
import dynamiclabs.immersivefx.lib.validation.ValidationHelpers;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BiomeConfig
implements IValidator<BiomeConfig> {
    @SerializedName(value="conditions")
    public String conditions = "";
    @SerializedName(value="_comment")
    public String comment = null;
    @SerializedName(value="aurora")
    public Boolean hasAurora = null;
    @SerializedName(value="fogColor")
    public String fogColor = null;
    @SerializedName(value="visibility")
    public Float visibility = null;
    @SerializedName(value="soundReset")
    public Boolean soundReset = null;
    @SerializedName(value="spotSoundChance")
    public Integer spotSoundChance = null;
    @SerializedName(value="acoustics")
    public List<AcousticConfig> acoustics = ImmutableList.of();

    public String toString() {
        return this.comment == null ? this.conditions : this.comment;
    }

    @Override
    public void validate(@Nonnull BiomeConfig obj) throws ValidationException {
        if (this.visibility != null) {
            ValidationHelpers.inRange("visibility", this.visibility.floatValue(), 0.0f, 1.0f, x$0 -> Environs.LOGGER.warn((String)x$0, new Object[0]));
        }
        for (AcousticConfig ac : this.acoustics) {
            ac.validate(ac);
        }
    }
}

