/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.particles.IParticleMote;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Mote
implements IParticleMote {
    protected final BlockGetter world;
    protected final LevelReader lighting;
    protected boolean isAlive = true;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected final BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
    protected int packedLighting;
    protected float red;
    protected float green;
    protected float blue;
    protected float alpha;

    public Mote(@Nonnull BlockGetter world, double x, double y, double z) {
        this.world = world;
        this.lighting = world instanceof LevelReader ? (LevelReader)world : GameUtils.getWorld();
        this.setPosition(x, y, z);
        this.configureColor();
    }

    public void setPosition(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.position.m_122169_(posX, posY, posZ);
    }

    @Override
    @Nonnull
    public Vec3 getPosition() {
        return new Vec3(this.posX, this.posY, this.posZ);
    }

    public void configureColor() {
        this.alpha = 1.0f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public void kill() {
        this.isAlive = false;
    }

    @Override
    public boolean tick() {
        if (this.isAlive()) {
            this.update();
            if (this.isAlive()) {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.updateBrightness();
            }
        }
        return this.isAlive();
    }

    protected void update() {
    }

    public void updateBrightness() {
        this.packedLighting = LevelRenderer.m_109541_((BlockAndTintGetter)this.lighting, (BlockPos)this.position);
    }

    protected final double interpX(Camera info) {
        return info.m_90583_().f_82479_;
    }

    protected final double interpY(Camera info) {
        return info.m_90583_().f_82480_;
    }

    protected final double interpZ(Camera info) {
        return info.m_90583_().f_82481_;
    }

    protected float renderX(Camera info, float partialTicks) {
        return (float)(this.posX - this.interpX(info));
    }

    protected float renderY(Camera info, float partialTicks) {
        return (float)(this.posY - this.interpY(info));
    }

    protected float renderZ(Camera info, float partialTicks) {
        return (float)(this.posZ - this.interpZ(info));
    }

    protected void drawVertex(VertexConsumer buffer, double x, double y, double z, float u, float v) {
        buffer.m_5483_(x, y, z).m_7421_(u, v).m_85950_(this.red, this.green, this.blue, this.alpha).m_85969_(this.packedLighting).m_5752_();
    }

    @Override
    public abstract void renderParticle(@Nonnull VertexConsumer var1, @Nonnull Camera var2, float var3);
}

