/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.scripting.sets;

import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.WorldUtils;
import dynamiclabs.immersivefx.lib.scripting.VariableSet;
import dynamiclabs.immersivefx.lib.scripting.sets.IPlayerVariables;
import dynamiclabs.immersivefx.lib.scripting.sets.LazyVariable;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerVariables
extends VariableSet<IPlayerVariables>
implements IPlayerVariables {
    private final LazyVariable<Boolean> isSuffocating = new LazyVariable<Boolean>(() -> {
        if (GameUtils.isInGame()) {
            Player player = GameUtils.getPlayer();
            return !player.m_7500_() && player.m_20146_() < 0;
        }
        return false;
    });
    private final LazyVariable<Boolean> canSeeSky = new LazyVariable<Boolean>(() -> {
        if (GameUtils.isInGame()) {
            ClientLevel world = GameUtils.getWorld();
            Player player = GameUtils.getPlayer();
            return world.m_46861_(player.m_142538_().m_142082_(0, 2, 0));
        }
        return false;
    });
    private final LazyVariable<Boolean> canRainOn = new LazyVariable<Boolean>(() -> {
        Player player;
        ClientLevel world;
        if (GameUtils.isInGame() && (world = GameUtils.getWorld()).m_46861_((player = GameUtils.getPlayer()).m_142538_().m_142082_(0, 2, 0))) {
            return WorldUtils.getTopSolidOrLiquidBlock((LevelReader)world, player.m_142538_()).m_123342_() <= player.m_142538_().m_123342_();
        }
        return false;
    });
    private boolean isCreative;
    private boolean isBurning;
    private boolean isFlying;
    private boolean isSprintnig;
    private boolean isInLava;
    private boolean isInvisible;
    private boolean isBlind;
    private boolean isInWater;
    private boolean isWet;
    private boolean isRiding;
    private boolean isOnGround;
    private boolean isMoving;
    private float health;
    private float maxHealth;
    private float foodLevel;
    private float foodSaturationLevel;
    private double x;
    private double y;
    private double z;

    public PlayerVariables() {
        super("player");
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            Player player = GameUtils.getPlayer();
            assert (player != null);
            this.isCreative = player.m_7500_();
            this.isBurning = player.m_6060_();
            this.isFlying = player.f_19812_;
            this.isSprintnig = player.m_20142_();
            this.isInLava = player.m_20077_();
            this.isInvisible = player.m_20145_();
            this.isBlind = player.m_21023_(MobEffects.f_19610_);
            this.isInWater = player.m_20069_();
            this.isWet = player.m_20070_();
            this.isRiding = player.m_146898_();
            this.isOnGround = player.m_20096_();
            this.isMoving = player.f_19787_ != player.f_19867_;
            this.health = player.m_21223_();
            this.maxHealth = player.m_21233_();
            this.foodLevel = player.m_36324_().m_38702_();
            this.foodSaturationLevel = player.m_36324_().m_38722_();
            this.x = player.m_20185_();
            this.y = player.m_20186_();
            this.z = player.m_20189_();
        } else {
            this.isCreative = false;
            this.isBurning = false;
            this.isFlying = false;
            this.isSprintnig = false;
            this.isInLava = false;
            this.isInvisible = false;
            this.isBlind = false;
            this.isInWater = false;
            this.isWet = false;
            this.isRiding = false;
            this.isOnGround = false;
            this.health = 20.0f;
            this.maxHealth = 20.0f;
            this.foodLevel = 20.0f;
            this.foodSaturationLevel = 20.0f;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        }
        this.isSuffocating.reset();
        this.canRainOn.reset();
        this.canSeeSky.reset();
    }

    @Override
    @Nonnull
    public IPlayerVariables getInterface() {
        return this;
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public boolean isBurning() {
        return this.isBurning;
    }

    @Override
    public boolean isSuffocating() {
        return this.isSuffocating.get();
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public boolean isSprintnig() {
        return this.isSprintnig;
    }

    @Override
    public boolean isInLava() {
        return this.isInLava;
    }

    @Override
    public boolean isInvisible() {
        return this.isInvisible;
    }

    @Override
    public boolean isBlind() {
        return this.isBlind;
    }

    @Override
    public boolean isInWater() {
        return this.isInWater;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }

    @Override
    public boolean isWet() {
        return this.isWet;
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public boolean canRainOn() {
        return this.canRainOn.get();
    }

    @Override
    public boolean canSeeSky() {
        return this.canSeeSky.get();
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public float getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public float getFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public float getFoodSaturationLevel() {
        return this.foodSaturationLevel;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }
}

