/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.footsteps;

import dynamiclabs.immersivefx.mobeffects.footsteps.FootStrikeLocation;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.AcousticEvent;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.AcousticCompiler;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Association {
    private final FootStrikeLocation location;
    private IAcoustic data;

    public Association(@Nonnull LivingEntity entity, @Nonnull IAcoustic association) {
        Vec3 vec = entity.m_20182_();
        this.location = new FootStrikeLocation(entity, vec.f_82479_, vec.f_82480_ + 1.0, vec.f_82481_);
        this.data = association;
    }

    public Association(@Nonnull FootStrikeLocation pos, @Nonnull IAcoustic association) {
        this.location = pos;
        this.data = association;
    }

    public void merge(IAcoustic ... acoustics) {
        IAcoustic[] t = new IAcoustic[1 + acoustics.length];
        t[0] = this.data;
        System.arraycopy(acoustics, 0, t, 1, acoustics.length);
        this.data = AcousticCompiler.combine(t);
    }

    public void play(@Nonnull AcousticEvent event) {
        this.data.playAt(this.location.getStrikePosition(), event);
    }

    @Nonnull
    public FootStrikeLocation getStrikeLocation() {
        return this.location;
    }

    @Nonnull
    public BlockPos getStepPos() {
        return this.location.getStepPos();
    }
}

