/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.library;

import dynamiclabs.immersivefx.lib.Utilities;
import dynamiclabs.immersivefx.lib.blockstate.BlockStateMatcher;
import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.mobeffects.library.Constants;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public final class BlockAcousticMap {
    protected final Map<Block, ObjectArray<Pair<BlockStateMatcher, IAcoustic>>> data = new Reference2ObjectOpenHashMap();
    protected final Function<BlockState, IAcoustic> resolver;

    public BlockAcousticMap() {
        this(s -> null);
    }

    public BlockAcousticMap(@Nonnull Function<BlockState, IAcoustic> resolver) {
        this.resolver = resolver;
        this.put(BlockStateMatcher.create(Blocks.f_50016_.m_49966_()), Constants.NOT_EMITTER);
        this.put(BlockStateMatcher.create(Blocks.f_50627_.m_49966_()), Constants.NOT_EMITTER);
        this.put(BlockStateMatcher.create(Blocks.f_50626_.m_49966_()), Constants.NOT_EMITTER);
    }

    @Nonnull
    public IAcoustic getBlockAcoustics(@Nonnull BlockState state) {
        ObjectArray<Pair<BlockStateMatcher, IAcoustic>> entries = this.data.get(state.m_60734_());
        if (entries != null) {
            BlockStateMatcher matcher = BlockStateMatcher.create(state);
            IAcoustic result = this.find(entries, matcher);
            if (result != null) {
                return result;
            }
            result = this.find(entries, BlockStateMatcher.asGeneric(state));
            if (result != null) {
                return result;
            }
        }
        return Utilities.firstNonNull(this.resolver.apply(state), Constants.EMPTY);
    }

    @Nullable
    private IAcoustic find(@Nonnull ObjectArray<Pair<BlockStateMatcher, IAcoustic>> entries, @Nonnull BlockStateMatcher matcher) {
        for (int i = entries.size() - 1; i >= 0; --i) {
            Pair<BlockStateMatcher, IAcoustic> e = entries.get(i);
            if (!matcher.equals(e.getKey())) continue;
            return (IAcoustic)e.getValue();
        }
        return null;
    }

    public void put(@Nonnull BlockStateMatcher info, @Nonnull IAcoustic acoustics) {
        ObjectArray<Object> entry = this.data.get(info.getBlock());
        if (entry == null) {
            entry = new ObjectArray();
            this.data.put(info.getBlock(), entry);
        }
        entry.add((Pair<BlockStateMatcher, IAcoustic>)Pair.of((Object)info, (Object)acoustics));
    }

    public void clear() {
        this.data.clear();
    }

    public void trim() {
        this.data.forEach((key, value) -> value.trim());
    }
}

