/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.library.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import dynamiclabs.immersivefx.lib.validation.IValidator;
import dynamiclabs.immersivefx.lib.validation.ValidationException;
import dynamiclabs.immersivefx.lib.validation.ValidationHelpers;
import dynamiclabs.immersivefx.mobeffects.MobEffects;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FootstepConfig
implements IValidator<FootstepConfig> {
    @SerializedName(value="primitives")
    public Map<String, String> primitives = ImmutableMap.of();
    @SerializedName(value="blockTags")
    public Map<String, String> blockTags = ImmutableMap.of();
    @SerializedName(value="footsteps")
    public Map<String, String> footsteps = ImmutableMap.of();
    @SerializedName(value="footprints")
    public List<String> footprints = ImmutableList.of();

    @Override
    public void validate(@Nonnull FootstepConfig obj) throws ValidationException {
        for (String fp : this.footprints) {
            ValidationHelpers.notNullOrWhitespace("footprints", fp, x$0 -> MobEffects.LOGGER.warn((String)x$0, new Object[0]));
            ValidationHelpers.mustBeLowerCase("footprints", fp, x$0 -> MobEffects.LOGGER.warn((String)x$0, new Object[0]));
        }
    }
}

