/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.relocated.dev._100media.capabilitysyncer.network;

import dynamiclabs.immersivefx.relocated.dev._100media.capabilitysyncer.core.ISyncableCapability;
import dynamiclabs.immersivefx.relocated.dev._100media.capabilitysyncer.network.ClientPacketHandler;
import dynamiclabs.immersivefx.relocated.dev._100media.capabilitysyncer.network.LevelCapabilityStatusPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class SimpleLevelCapabilityStatusPacket
extends LevelCapabilityStatusPacket {
    private static final Map<ResourceLocation, Function<Level, ISyncableCapability>> capRetrievers = new HashMap<ResourceLocation, Function<Level, ISyncableCapability>>();
    private final ResourceLocation capabilityId;

    public SimpleLevelCapabilityStatusPacket(ResourceLocation capabilityId, CompoundTag tag) {
        super(tag);
        this.capabilityId = capabilityId;
    }

    public SimpleLevelCapabilityStatusPacket(ResourceLocation capabilityId, ISyncableCapability capability) {
        super(capability);
        this.capabilityId = capabilityId;
    }

    public static <T extends Level> void register(ResourceLocation capabilityId, Function<T, ISyncableCapability> capabilityRetriever, SimpleChannel channel, int id) {
        capRetrievers.put(capabilityId, capabilityRetriever);
        SimpleLevelCapabilityStatusPacket.register(channel, id, SimpleLevelCapabilityStatusPacket.class, buf -> SimpleLevelCapabilityStatusPacket.read(buf, tag -> new SimpleLevelCapabilityStatusPacket(buf.m_130281_(), (CompoundTag)tag)));
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.m_130085_(this.capabilityId);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> ClientPacketHandler.handleLevelCapabilityStatus(this, capRetrievers.get(this.capabilityId)));
    }
}

