/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.audio.acoustic;

import com.google.common.base.MoreObjects;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.AcousticEvent;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcousticFactory;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundCategory;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundInstance;
import dynamiclabs.immersivefx.sndctrl.audio.AudioEngine;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.AcousticFactory;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleAcoustic
implements IAcoustic {
    private final AcousticFactory factory;
    private final ResourceLocation name;

    public SimpleAcoustic(@Nonnull SoundEvent event, @Nonnull ISoundCategory category) {
        this(event.m_11660_(), event);
        this.factory.setCategory(category);
    }

    public SimpleAcoustic(@Nonnull SoundEvent event) {
        this(event.m_11660_(), event);
    }

    public SimpleAcoustic(@Nonnull ResourceLocation name, @Nonnull SoundEvent evt) {
        this(name, new AcousticFactory(evt));
    }

    public SimpleAcoustic(@Nonnull ResourceLocation name, @Nonnull AcousticFactory factory) {
        this.name = Objects.requireNonNull(name);
        this.factory = factory;
    }

    @Override
    @Nonnull
    public AcousticFactory getFactory() {
        return this.factory;
    }

    @Override
    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public void play(@Nonnull AcousticEvent ignored) {
        this.play(this.factory.createSound());
    }

    @Override
    public void playAt(@Nonnull BlockPos pos, @Nonnull AcousticEvent ignored) {
        this.play(this.factory.createSoundAt(pos));
    }

    @Override
    public void playAt(@Nonnull Vec3 pos, @Nonnull AcousticEvent ignored) {
        this.play(this.factory.createSoundAt(pos));
    }

    @Override
    public void playNear(@Nonnull Entity entity, @Nonnull AcousticEvent ignored) {
        this.play(this.factory.createSoundNear(entity));
    }

    @Override
    public void playNear(@Nonnull Entity entity, @Nonnull AcousticEvent ignored, int minRange, int maxRange) {
        this.play(this.factory.createSoundNear(entity, minRange, maxRange));
    }

    @Override
    public void playBackground(@Nonnull AcousticEvent ignored) {
        this.play(this.factory.createBackgroundSound());
    }

    @Override
    public IAcousticFactory getFactory(@Nonnull AcousticEvent event) {
        return this.factory;
    }

    protected void play(@Nonnull ISoundInstance sound) {
        AudioEngine.play(sound);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName().toString()).toString();
    }
}

