/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.audio.handlers;

import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import dynamiclabs.immersivefx.lib.random.XorShiftRandom;
import dynamiclabs.immersivefx.sndctrl.SoundControl;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcousticFactory;
import dynamiclabs.immersivefx.sndctrl.api.sound.Category;
import dynamiclabs.immersivefx.sndctrl.audio.AudioEngine;
import dynamiclabs.immersivefx.sndctrl.audio.PlayerCenteredSoundInstance;
import dynamiclabs.immersivefx.sndctrl.config.Config;
import dynamiclabs.immersivefx.sndctrl.library.Primitives;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class SoundEventHandling {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(SoundEventHandling.class);
    private static boolean hasPlayed = false;

    private SoundEventHandling() {
    }

    @SubscribeEvent
    public static void onGuiOpen(@Nonnull ScreenOpenEvent event) {
        if (!hasPlayed && event.getScreen() instanceof TitleScreen) {
            hasPlayed = true;
            List possibles = ((List)Config.CLIENT.sound.startupSoundList.get()).stream().map(StringUtils::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
            if (possibles.size() == 0) {
                return;
            }
            String res = possibles.size() == 1 ? (String)possibles.get(0) : (String)possibles.get(XorShiftRandom.current().nextInt(possibles.size()));
            ResourceLocation rl = new ResourceLocation(res);
            IAcoustic acoustic = Primitives.getSound(rl, Category.MASTER);
            IAcousticFactory factory = acoustic.getFactory();
            if (factory != null) {
                PlayerCenteredSoundInstance instance = new PlayerCenteredSoundInstance(acoustic.getFactory().createSound(), Category.MASTER);
                GameUtils.getMC().m_6937_(() -> {
                    try {
                        AudioEngine.play(instance);
                    }
                    catch (Throwable t) {
                        LOGGER.error(t, "Error executing startup sound '%s'", rl.toString());
                    }
                });
            }
        }
    }
}

