/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftbchunks.net.RequestMapDataPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.ChunkPos;

public class ChunkScreen
extends BaseScreen {
    public MapDimension dimension = MapDimension.getCurrent();
    public List<ChunkButton> chunkButtons;
    public Set<XZ> selectedChunks;

    public ChunkScreen() {
        FTBChunksClient.alwaysRenderChunksOnMap = true;
        if (this.dimension == null) {
            FTBChunks.LOGGER.warn("Closed chunk screen map screen to prevent map dimension manager crash");
            this.closeGui();
        }
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        FTBChunksClient.alwaysRenderChunksOnMap = false;
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
        super.onClosed();
    }

    public void addWidgets() {
        int sx = this.getX() + (this.width - 240) / 2;
        int sy = this.getY() + (this.height - 240) / 2;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ChunkPos chunkPos = player.m_146902_();
        int startX = chunkPos.f_45578_ - 7;
        int startZ = chunkPos.f_45579_ - 7;
        this.chunkButtons = new ArrayList<ChunkButton>();
        this.selectedChunks = new LinkedHashSet<XZ>();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                ChunkButton button = new ChunkButton((Panel)this, XZ.of((int)(startX + x), (int)(startZ + z)));
                button.chunk = this.dimension.getRegion(XZ.regionFromChunk((int)(startX + x), (int)(startZ + z))).getDataBlocking().getChunk(button.chunkPos);
                this.chunkButtons.add(button);
                button.setPos(sx + x * 16, sy + z * 16);
            }
        }
        this.addAll(this.chunkButtons);
        new RequestMapDataPacket(chunkPos.f_45578_ - 7, chunkPos.f_45579_ - 7, chunkPos.f_45578_ + 7, chunkPos.f_45579_ + 7).sendToServer();
        this.add(new SimpleButton((Panel)this, (Component)new TranslatableComponent("ftbchunks.gui.large_map"), Icons.MAP, (simpleButton, mouseButton) -> new LargeMapScreen().openGui()).setPosAndSize(1, 1, 16, 16));
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (!this.selectedChunks.isEmpty()) {
            new RequestChunkChangePacket(ChunkScreen.isShiftKeyDown() ? (button.isLeft() ? 2 : 3) : (button.isLeft() ? 0 : 1), this.selectedChunks).sendToServer();
            this.selectedChunks.clear();
            this.playClickSound();
        }
    }

    public boolean keyPressed(Key key) {
        if (key.is(70)) {
            new LargeMapScreen().openGui();
            return true;
        }
        return super.keyPressed(key);
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int sx = x + (w - 240) / 2;
        int sy = y + (h - 240) / 2;
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        RenderSystem.m_69832_((float)Math.max(2.5f, (float)Minecraft.m_91087_().m_91268_().m_85441_() / 1920.0f * 2.5f));
        RenderSystem.m_69493_();
        RenderSystem.m_157184_((int)FTBChunksClient.minimapTextureId);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9728);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9728);
        RenderSystem.m_157453_((int)0, (int)FTBChunksClient.minimapTextureId);
        GuiHelper.drawTexturedRect((PoseStack)matrixStack, (int)sx, (int)sy, (int)240, (int)240, (Color4I)Color4I.WHITE, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)258)) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69472_();
            buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            Matrix4f m = matrixStack.m_85850_().m_85861_();
            for (int gy = 1; gy < 15; ++gy) {
                buffer.m_85982_(m, (float)sx, (float)(sy + gy * 16), 0.0f).m_6122_(r, g, b, a).m_5752_();
                buffer.m_85982_(m, (float)(sx + 240), (float)(sy + gy * 16), 0.0f).m_6122_(r, g, b, a).m_5752_();
            }
            for (int gx = 1; gx < 15; ++gx) {
                buffer.m_85982_(m, (float)(sx + gx * 16), (float)sy, 0.0f).m_6122_(r, g, b, a).m_5752_();
                buffer.m_85982_(m, (float)(sx + gx * 16), (float)(sy + 240), 0.0f).m_6122_(r, g, b, a).m_5752_();
            }
            for (ChunkButton button : this.chunkButtons) {
                MapChunk chunk = button.chunk;
                if (chunk.forceLoadedDate == null) continue;
                int cx = button.getX();
                int cy = button.getY();
                buffer.m_85982_(m, (float)cx, (float)cy, 0.0f).m_6122_(255, 0, 0, 100).m_5752_();
                buffer.m_85982_(m, (float)(cx + 16), (float)(cy + 16), 0.0f).m_6122_(255, 0, 0, 100).m_5752_();
                buffer.m_85982_(m, (float)cx + 8.0f, (float)cy, 0.0f).m_6122_(255, 0, 0, 100).m_5752_();
                buffer.m_85982_(m, (float)(cx + 16), (float)cy + 8.0f, 0.0f).m_6122_(255, 0, 0, 100).m_5752_();
                buffer.m_85982_(m, (float)cx, (float)cy + 8.0f, 0.0f).m_6122_(255, 0, 0, 100).m_5752_();
                buffer.m_85982_(m, (float)cx + 8.0f, (float)(cy + 16), 0.0f).m_6122_(255, 0, 0, 100).m_5752_();
            }
            tessellator.m_85914_();
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69832_((float)1.0f);
        double hx = (double)(sx + 112) + MathUtils.mod((double)player.m_20185_(), (double)16.0);
        double hy = (double)(sy + 112) + MathUtils.mod((double)player.m_20189_(), (double)16.0);
        FaceIcon.getFace((GameProfile)player.m_36316_()).draw(matrixStack, (int)(hx - 4.0), (int)(hy - 4.0), 8, 8);
        SendGeneralDataPacket d = FTBChunksClient.generalData;
        if (d != null) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(new TranslatableComponent("ftbchunks.gui.claimed"));
            list.add(new TextComponent(d.claimed + " / " + d.maxClaimChunks).m_130940_(d.claimed > d.maxClaimChunks ? ChatFormatting.RED : (d.claimed == d.maxClaimChunks ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
            list.add(new TranslatableComponent("ftbchunks.gui.force_loaded"));
            list.add(new TextComponent(d.loaded + " / " + d.maxForceLoadChunks).m_130940_(d.loaded > d.maxForceLoadChunks ? ChatFormatting.RED : (d.loaded == d.maxForceLoadChunks ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
            for (int i = 0; i < list.size(); ++i) {
                theme.drawString(matrixStack, list.get(i), 3.0f, (float)(this.getScreen().m_85446_() - 10 * (list.size() - i) - 1), Color4I.WHITE, 2);
            }
        }
    }

    public class ChunkButton
    extends Button {
        public final XZ chunkPos;
        public MapChunk chunk;

        public ChunkButton(Panel panel, XZ xz) {
            super(panel, TextComponent.f_131282_, (Icon)Icon.EMPTY);
            this.setSize(16, 16);
            this.chunkPos = xz;
        }

        public void onClicked(MouseButton mouseButton) {
            ChunkScreen.this.selectedChunks.add(this.chunkPos);
        }

        public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver() || ChunkScreen.this.selectedChunks.contains(this.chunkPos)) {
                Color4I.WHITE.withAlpha(100).draw(matrixStack, x, y, w, h);
                if (ChunkButton.isMouseButtonDown((MouseButton)MouseButton.LEFT) || ChunkButton.isMouseButtonDown((MouseButton)MouseButton.RIGHT)) {
                    ChunkScreen.this.selectedChunks.add(this.chunkPos);
                }
            }
        }

        public void addMouseOverText(TooltipList list) {
            if (this.chunk != null && this.chunk.getTeam() != null) {
                list.add(this.chunk.getTeam().getName());
                Date date = new Date();
                if (Screen.m_96639_()) {
                    list.add((Component)new TextComponent(this.chunk.claimedDate.toLocaleString()).m_130940_(ChatFormatting.GRAY));
                } else {
                    list.add((Component)new TextComponent(TimeUtils.prettyTimeString((long)((date.getTime() - this.chunk.claimedDate.getTime()) / 1000L)) + " ago").m_130940_(ChatFormatting.GRAY));
                }
                if (this.chunk.forceLoadedDate != null) {
                    list.add((Component)new TranslatableComponent("ftbchunks.gui.force_loaded").m_130940_(ChatFormatting.RED));
                    if (Screen.m_96639_()) {
                        list.add((Component)new TextComponent(this.chunk.forceLoadedDate.toLocaleString()).m_130940_(ChatFormatting.GRAY));
                    } else {
                        list.add((Component)new TextComponent(TimeUtils.prettyTimeString((long)((date.getTime() - this.chunk.forceLoadedDate.getTime()) / 1000L)) + " ago").m_130940_(ChatFormatting.GRAY));
                    }
                }
            }
        }
    }
}

