/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.PlayerLocation;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.VisiblePlayerListItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SendVisiblePlayerListPacket
extends BaseS2CMessage {
    public final List<PlayerLocation> players;
    public final ResourceKey<Level> dim;

    public SendVisiblePlayerListPacket(List<PlayerLocation> p, ResourceKey<Level> d) {
        this.players = p;
        this.dim = d;
    }

    SendVisiblePlayerListPacket(FriendlyByteBuf buf) {
        int s = buf.m_130242_();
        this.players = new ArrayList<PlayerLocation>(s);
        for (int i = 0; i < s; ++i) {
            PlayerLocation p = new PlayerLocation();
            long most = buf.readLong();
            long least = buf.readLong();
            p.uuid = new UUID(most, least);
            p.name = buf.m_130136_(Short.MAX_VALUE);
            p.x = buf.m_130242_();
            p.z = buf.m_130242_();
            this.players.add(p);
        }
        this.dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
    }

    public static void sendAll() {
        ArrayList<VisiblePlayerListItem> playerList = new ArrayList<VisiblePlayerListItem>();
        for (ServerPlayer player : FTBChunksAPI.getManager().teamManager.server.m_6846_().m_11314_()) {
            VisiblePlayerListItem item = new VisiblePlayerListItem();
            item.player = player;
            item.data = FTBChunksAPI.getManager().getData(player);
            item.location = new PlayerLocation((Player)player);
            playerList.add(item);
        }
        for (VisiblePlayerListItem self : playerList) {
            ResourceKey dim = self.player.f_19853_.m_46472_();
            ArrayList<PlayerLocation> players = new ArrayList<PlayerLocation>();
            for (VisiblePlayerListItem other : playerList) {
                if (other.player.f_19853_ != self.player.f_19853_ || !self.data.canUse(other.player, FTBChunksTeamData.LOCATION_MODE)) continue;
                players.add(other.location);
            }
            new SendVisiblePlayerListPacket(players, (ResourceKey<Level>)dim).sendTo(self.player);
        }
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_VISIBLE_PLAYER_LIST;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.players.size());
        for (PlayerLocation p : this.players) {
            buf.writeLong(p.uuid.getMostSignificantBits());
            buf.writeLong(p.uuid.getLeastSignificantBits());
            buf.m_130072_(p.name, Short.MAX_VALUE);
            buf.m_130130_(p.x);
            buf.m_130130_(p.z);
        }
        buf.m_130085_(this.dim.m_135782_());
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateVisiblePlayerList(this);
    }
}

