/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.ServiceLoader;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.common.world.biome.end.BYGEndBiomeSource;
import potionstudios.byg.common.world.biome.nether.BYGNetherBiomeSource;
import potionstudios.byg.network.packet.BYGS2CPacket;

public interface ModPlatform {
    public static final ModPlatform INSTANCE = (ModPlatform)Util.m_137537_(() -> {
        ServiceLoader<ModPlatform> loader = ServiceLoader.load(ModPlatform.class);
        Iterator<ModPlatform> it = loader.iterator();
        if (!it.hasNext()) {
            throw new RuntimeException("No Mod Platform was found on the classpath!");
        }
        ModPlatform factory = it.next();
        if (it.hasNext()) {
            throw new RuntimeException("More than one Mod Platform was found on the classpath!");
        }
        return factory;
    });

    public Path configPath();

    public BYGNetherBiomeSource createNetherBiomeSource(Registry<Biome> var1, long var2);

    public BYGEndBiomeSource createEndBiomeSource(Registry<Biome> var1, long var2);

    public boolean isModLoaded(String var1);

    public <P extends BYGS2CPacket> void sendToClient(ServerPlayer var1, P var2);

    public String tagNameSpace();

    public String curseForgeURL();

    public boolean isClientEnvironment();

    public Platform modPlatform();

    public boolean hasLoadErrors();

    public boolean canTreeGrowWithEvent(Level var1, Random var2, BlockPos var3);

    default public <P extends BYGS2CPacket> void sendToAllClients(List<ServerPlayer> players, P packet) {
        for (ServerPlayer player : players) {
            this.sendToClient(player, packet);
        }
    }

    public static enum Platform {
        FORGE,
        FABRIC;

    }
}

