/*
 * Decompiled with CFR 0.152.
 */
package qouteall.forge_model_data_fix;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.client.model.data.IModelData;

public class ForgeModelDataManagerPerWorld {
    private final Map<ChunkPos, Set<BlockPos>> needModelDataRefresh = new ConcurrentHashMap<ChunkPos, Set<BlockPos>>();
    private final Map<ChunkPos, Map<BlockPos, IModelData>> modelDataCache = new ConcurrentHashMap<ChunkPos, Map<BlockPos, IModelData>>();
    private final WeakReference<Level> currentWorld = new WeakReference<Object>(null);

    private void cleanCaches(Level world) {
    }

    public void requestModelDataRefresh(BlockEntity te) {
        Preconditions.checkNotNull((Object)te, (Object)"Tile entity must not be null");
        Level world = te.m_58904_();
        this.cleanCaches(world);
        this.needModelDataRefresh.computeIfAbsent(new ChunkPos(te.m_58899_()), $ -> Collections.synchronizedSet(new HashSet())).add(te.m_58899_());
    }

    private void refreshModelData(Level world, ChunkPos chunk) {
        this.cleanCaches(world);
        Set<BlockPos> needUpdate = this.needModelDataRefresh.remove(chunk);
        if (needUpdate != null) {
            Map data = this.modelDataCache.computeIfAbsent(chunk, $ -> new ConcurrentHashMap());
            for (BlockPos pos : needUpdate) {
                BlockEntity toUpdate = world.m_7702_(pos);
                if (toUpdate != null && !toUpdate.m_58901_()) {
                    data.put(pos, toUpdate.getModelData());
                    continue;
                }
                data.remove(pos);
            }
        }
    }

    public void onChunkUnload(LevelChunk chunk) {
        this.needModelDataRefresh.remove(chunk);
        this.modelDataCache.remove(chunk);
    }

    @Nullable
    public IModelData getModelData(Level world, BlockPos pos) {
        return this.getModelData(world, new ChunkPos(pos)).get(pos);
    }

    public Map<BlockPos, IModelData> getModelData(Level world, ChunkPos pos) {
        Preconditions.checkArgument((boolean)world.m_5776_(), (Object)"Cannot request model data for server world");
        this.refreshModelData(world, pos);
        return this.modelDataCache.getOrDefault(pos, Collections.emptyMap());
    }
}

