/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.context_management.DimensionRenderHelper;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.dimension.DimensionTypeSync;
import qouteall.q_misc_util.forge.events.ClientDimensionUpdateEvent;
import qouteall.q_misc_util.my_util.LimitedLogger;
import qouteall.q_misc_util.my_util.SignalArged;

@OnlyIn(value=Dist.CLIENT)
public class ClientWorldLoader {
    public static final SignalArged<ResourceKey<Level>> clientDimensionDynamicRemoveSignal = new SignalArged();
    public static final SignalArged<ClientLevel> clientWorldLoadSignal = new SignalArged();
    public static boolean isFlatWorld = false;
    private static final Map<ResourceKey<Level>, ClientLevel> clientWorldMap = new HashMap<ResourceKey<Level>, ClientLevel>();
    public static final Map<ResourceKey<Level>, LevelRenderer> worldRendererMap = new HashMap<ResourceKey<Level>, LevelRenderer>();
    public static final Map<ResourceKey<Level>, DimensionRenderHelper> renderHelperMap = new HashMap<ResourceKey<Level>, DimensionRenderHelper>();
    private static final Minecraft client = Minecraft.m_91087_();
    private static boolean isInitialized = false;
    private static boolean isCreatingClientWorld = false;
    public static boolean isClientRemoteTicking = false;
    private static final LimitedLogger limitedLogger = new LimitedLogger(10);
    private static boolean isReloadingOtherWorldRenderers = false;

    public static void init() {
        IPGlobal.postClientTickSignal.connect(ClientWorldLoader::tick);
        IPGlobal.clientCleanupSignal.connect(ClientWorldLoader::cleanUp);
        MinecraftForge.EVENT_BUS.register(ClientWorldLoader.class);
    }

    @SubscribeEvent
    public static void clientDimensionUpdate(ClientDimensionUpdateEvent event) {
        if (ClientWorldLoader.getIsInitialized()) {
            List<ResourceKey> dimensionsToRemove = clientWorldMap.keySet().stream().filter(dim -> !event.dimIdSet.contains(dim)).toList();
            for (ResourceKey dim2 : dimensionsToRemove) {
                ClientWorldLoader.disposeDimensionDynamically((ResourceKey<Level>)dim2);
            }
        }
    }

    public static boolean getIsInitialized() {
        return isInitialized;
    }

    public static boolean getIsCreatingClientWorld() {
        return isCreatingClientWorld;
    }

    private static void tick() {
        if (IPCGlobal.isClientRemoteTickingEnabled) {
            isClientRemoteTicking = true;
            clientWorldMap.values().forEach(world -> {
                if (ClientWorldLoader.client.f_91073_ != world) {
                    ClientWorldLoader.tickRemoteWorld(world);
                }
            });
            worldRendererMap.values().forEach(worldRenderer -> {
                if (worldRenderer != ClientWorldLoader.client.f_91060_) {
                    worldRenderer.m_109823_();
                }
            });
            isClientRemoteTicking = false;
        }
        boolean lightmapTextureConflict = false;
        for (DimensionRenderHelper helper : renderHelperMap.values()) {
            helper.tick();
            if (helper.world == ClientWorldLoader.client.f_91073_ || helper.lightmapTexture != ClientWorldLoader.client.f_91063_.m_109154_()) continue;
            Helper.err(String.format("Lightmap Texture Conflict %s %s", helper.world.m_46472_(), ClientWorldLoader.client.f_91073_.m_46472_()));
            lightmapTextureConflict = true;
        }
        if (lightmapTextureConflict) {
            ClientWorldLoader.disposeRenderHelpers();
            Helper.log("Refreshed Lightmaps");
        }
    }

    public static void disposeRenderHelpers() {
        renderHelperMap.values().forEach(DimensionRenderHelper::cleanUp);
        renderHelperMap.clear();
    }

    private static void tickRemoteWorld(ClientLevel newWorld) {
        List nearbyPortals = CHelper.getClientNearbyPortals(10.0).collect(Collectors.toList());
        ClientWorldLoader.withSwitchedWorld(newWorld, () -> {
            try {
                newWorld.m_104804_();
                newWorld.m_104726_(() -> true);
                if (!client.m_91104_()) {
                    ClientWorldLoader.tickRemoteWorldRandomTicksClient(newWorld, nearbyPortals);
                }
                newWorld.m_194141_();
            }
            catch (Throwable e) {
                limitedLogger.invoke(e::printStackTrace);
            }
        });
    }

    private static void tickRemoteWorldRandomTicksClient(ClientLevel newWorld, List<Portal> nearbyPortals) {
        nearbyPortals.stream().filter(portal -> portal.dimensionTo == newWorld.m_46472_()).findFirst().ifPresent(portal -> {
            Vec3 playerPos = ClientWorldLoader.client.f_91074_.m_20182_();
            Vec3 center = portal.transformPoint(playerPos);
            Camera camera = ClientWorldLoader.client.f_91063_.m_109153_();
            Vec3 oldCameraPos = camera.m_90583_();
            ((IECamera)camera).portal_setPos(center);
            if (newWorld.m_46467_() % 2L == 0L) {
                newWorld.m_104784_((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_);
            }
            ClientWorldLoader.client.f_91061_.m_107388_();
            ((IECamera)camera).portal_setPos(oldCameraPos);
        });
    }

    private static void cleanUp() {
        worldRendererMap.values().forEach(ClientWorldLoader::disposeWorldRenderer);
        for (ClientLevel clientWorld : clientWorldMap.values()) {
            ((IEClientWorld)clientWorld).resetWorldRendererRef();
        }
        clientWorldMap.clear();
        worldRendererMap.clear();
        ClientWorldLoader.disposeRenderHelpers();
        isInitialized = false;
    }

    private static void disposeWorldRenderer(LevelRenderer worldRenderer) {
        worldRenderer.m_109701_(null);
        if (worldRenderer != ClientWorldLoader.client.f_91060_) {
            worldRenderer.close();
            ((IEWorldRenderer)worldRenderer).portal_fullyDispose();
        }
    }

    private static void disposeDimensionDynamically(ResourceKey<Level> dimension) {
        Validate.isTrue((ClientWorldLoader.client.f_91073_.m_46472_() != dimension ? 1 : 0) != 0);
        Validate.isTrue((ClientWorldLoader.client.f_91074_.f_19853_.m_46472_() != dimension ? 1 : 0) != 0);
        Validate.isTrue((boolean)client.m_18695_());
        LevelRenderer worldRenderer = worldRendererMap.get(dimension);
        ClientWorldLoader.disposeWorldRenderer(worldRenderer);
        worldRendererMap.remove(dimension);
        Validate.isTrue((ClientWorldLoader.client.f_91060_ != worldRenderer ? 1 : 0) != 0);
        ClientLevel clientWorld = clientWorldMap.get(dimension);
        ((IEClientWorld)clientWorld).resetWorldRendererRef();
        clientWorldMap.remove(dimension);
        DimensionRenderHelper renderHelper = renderHelperMap.remove(dimension);
        if (renderHelper != null) {
            renderHelper.cleanUp();
        }
        Helper.log("Client Dynamically Removed Dimension " + dimension.m_135782_());
        if (clientWorld.m_7726_().m_142061_() > 0) {
            Helper.err("The chunks of that dimension was not cleared before removal");
        }
        if (clientWorld.m_104813_() > 0) {
            Helper.err("The entities of that dimension was not cleared before removal");
        }
        ClientWorldLoader.client.f_91063_.m_109150_();
        clientDimensionDynamicRemoveSignal.emit(dimension);
    }

    public static LevelRenderer getWorldRenderer(ResourceKey<Level> dimension) {
        ClientWorldLoader.initializeIfNeeded();
        return worldRendererMap.get(dimension);
    }

    public static ClientLevel getWorld(ResourceKey<Level> dimension) {
        Validate.notNull(dimension);
        Validate.isTrue((boolean)client.m_18695_());
        ClientWorldLoader.initializeIfNeeded();
        if (!clientWorldMap.containsKey(dimension)) {
            return ClientWorldLoader.createSecondaryClientWorld(dimension);
        }
        return clientWorldMap.get(dimension);
    }

    @Nullable
    public static ClientLevel getOptionalWorld(ResourceKey<Level> dimension) {
        Validate.notNull(dimension);
        Validate.isTrue((boolean)client.m_18695_());
        if (ClientWorldLoader.getServerDimensions().contains(dimension)) {
            return ClientWorldLoader.getWorld(dimension);
        }
        return null;
    }

    public static DimensionRenderHelper getDimensionRenderHelper(ResourceKey<Level> dimension) {
        ClientWorldLoader.initializeIfNeeded();
        DimensionRenderHelper result = renderHelperMap.computeIfAbsent(dimension, dimensionType -> new DimensionRenderHelper((Level)ClientWorldLoader.getWorld(dimension)));
        Validate.isTrue((result.world.m_46472_() == dimension ? 1 : 0) != 0);
        return result;
    }

    public static void initializeIfNeeded() {
        if (!isInitialized) {
            Validate.isTrue((ClientWorldLoader.client.f_91073_ != null ? 1 : 0) != 0);
            Validate.isTrue((ClientWorldLoader.client.f_91060_ != null ? 1 : 0) != 0);
            Validate.notNull((Object)ClientWorldLoader.client.f_91074_);
            Validate.isTrue((ClientWorldLoader.client.f_91074_.f_19853_ == ClientWorldLoader.client.f_91073_ ? 1 : 0) != 0);
            ResourceKey playerDimension = ClientWorldLoader.client.f_91073_.m_46472_();
            clientWorldMap.put((ResourceKey<Level>)playerDimension, ClientWorldLoader.client.f_91073_);
            worldRendererMap.put((ResourceKey<Level>)playerDimension, ClientWorldLoader.client.f_91060_);
            renderHelperMap.put((ResourceKey<Level>)ClientWorldLoader.client.f_91073_.m_46472_(), new DimensionRenderHelper((Level)ClientWorldLoader.client.f_91073_));
            isInitialized = true;
        }
    }

    private static ClientLevel createSecondaryClientWorld(ResourceKey<Level> dimension) {
        ClientLevel newWorld;
        Validate.notNull((Object)ClientWorldLoader.client.f_91074_);
        Validate.isTrue((boolean)client.m_18695_());
        Set<ResourceKey<Level>> dimIds = ClientWorldLoader.getServerDimensions();
        if (!dimIds.contains(dimension)) {
            throw new RuntimeException("Cannot create invalid client dimension " + dimension.m_135782_());
        }
        isCreatingClientWorld = true;
        client.m_91307_().m_6180_("create_world");
        int chunkLoadDistance = 3;
        LevelRenderer worldRenderer = new LevelRenderer(client, client.m_91269_());
        try {
            ClientPacketListener mainNetHandler = ClientWorldLoader.client.f_91074_.f_108617_;
            ResourceKey<DimensionType> dimensionTypeKey = DimensionTypeSync.getDimensionTypeKey(dimension);
            ClientLevel.ClientLevelData currentProperty = (ClientLevel.ClientLevelData)((IEWorld)ClientWorldLoader.client.f_91073_).myGetProperties();
            RegistryAccess registryManager = mainNetHandler.m_105152_();
            int simulationDistance = ClientWorldLoader.client.f_91073_.m_194186_();
            Holder dimensionType = registryManager.m_175515_(Registry.f_122818_).m_206081_(dimensionTypeKey);
            ClientLevel.ClientLevelData properties = new ClientLevel.ClientLevelData(currentProperty.m_5472_(), currentProperty.m_5466_(), isFlatWorld);
            newWorld = new ClientLevel(mainNetHandler, properties, dimension, dimensionType, chunkLoadDistance, simulationDistance, () -> ((Minecraft)client).m_91307_(), worldRenderer, ClientWorldLoader.client.f_91073_.m_46659_(), ClientWorldLoader.client.f_91073_.m_7062_().f_47863_);
        }
        catch (Exception e) {
            throw new IllegalStateException("Creating Client World " + dimension + " " + clientWorldMap.keySet(), e);
        }
        worldRenderer.m_109701_(newWorld);
        worldRenderer.m_6213_(client.m_91098_());
        clientWorldMap.put(dimension, newWorld);
        worldRendererMap.put(dimension, worldRenderer);
        Helper.log("Client World Created " + dimension.m_135782_());
        isCreatingClientWorld = false;
        clientWorldLoadSignal.emit(newWorld);
        client.m_91307_().m_7238_();
        return newWorld;
    }

    public static Set<ResourceKey<Level>> getServerDimensions() {
        return ClientWorldLoader.client.f_91074_.f_108617_.m_105151_();
    }

    public static Collection<ClientLevel> getClientWorlds() {
        Validate.isTrue((boolean)isInitialized);
        return clientWorldMap.values();
    }

    public static void _onWorldRendererReloaded() {
        Validate.isTrue((boolean)client.m_18695_());
        if (ClientWorldLoader.client.f_91073_ != null) {
            Helper.log("WorldRenderer reloaded " + ClientWorldLoader.client.f_91073_.m_46472_().m_135782_());
        }
        if (isReloadingOtherWorldRenderers) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        if (ClientWorldLoader.getIsCreatingClientWorld()) {
            return;
        }
        isReloadingOtherWorldRenderers = true;
        List toReload = worldRendererMap.keySet().stream().filter(d -> d != ClientWorldLoader.client.f_91073_.m_46472_()).collect(Collectors.toList());
        for (ResourceKey dim : toReload) {
            ClientLevel world = clientWorldMap.get(dim);
            Validate.notNull((Object)world);
            ClientWorldLoader.withSwitchedWorld(world, () -> ClientWorldLoader.client.f_91060_.m_109818_());
        }
        isReloadingOtherWorldRenderers = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withSwitchedWorld(ClientLevel newWorld, Supplier<T> supplier) {
        Validate.isTrue((boolean)client.m_18695_());
        Validate.isTrue((ClientWorldLoader.client.f_91074_ != null ? 1 : 0) != 0);
        ClientPacketListener networkHandler = client.m_91403_();
        ClientLevel originalWorld = ClientWorldLoader.client.f_91073_;
        LevelRenderer originalWorldRenderer = ClientWorldLoader.client.f_91060_;
        ClientLevel originalNetHandlerWorld = networkHandler.m_105147_();
        LevelRenderer newWorldRenderer = ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)newWorld.m_46472_());
        Validate.notNull((Object)newWorldRenderer);
        ClientWorldLoader.client.f_91073_ = newWorld;
        ((IEParticleManager)ClientWorldLoader.client.f_91061_).ip_setWorld(newWorld);
        ((IEMinecraftClient)client).setWorldRenderer(newWorldRenderer);
        ((IEClientPlayNetworkHandler)networkHandler).ip_setWorld(newWorld);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (ClientWorldLoader.client.f_91073_ != newWorld) {
                Helper.err("Respawn packet should not be redirected");
                originalWorld = ClientWorldLoader.client.f_91073_;
                originalWorldRenderer = ClientWorldLoader.client.f_91060_;
            }
            ClientWorldLoader.client.f_91073_ = originalWorld;
            ((IEMinecraftClient)client).setWorldRenderer(originalWorldRenderer);
            ((IEParticleManager)ClientWorldLoader.client.f_91061_).ip_setWorld(originalWorld);
            ((IEClientPlayNetworkHandler)networkHandler).ip_setWorld(originalNetHandlerWorld);
        }
    }

    public static void withSwitchedWorld(ClientLevel newWorld, Runnable runnable) {
        ClientWorldLoader.withSwitchedWorld(newWorld, () -> {
            runnable.run();
            return null;
        });
    }
}

