/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import com.mojang.blaze3d.platform.GlUtil;
import java.util.UUID;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.commands.ClientDebugCommand;
import qouteall.imm_ptl.core.compat.IPFlywheelCompat;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisCompatibilityPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisPortalRenderer;
import qouteall.imm_ptl.core.miscellaneous.DubiousThings;
import qouteall.imm_ptl.core.miscellaneous.GcMonitor;
import qouteall.imm_ptl.core.portal.PortalAnimationManagement;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.CrossPortalEntityRenderer;
import qouteall.imm_ptl.core.render.MyBuiltChunkStorage;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.VisibleSectionDiscovery;
import qouteall.imm_ptl.core.render.context_management.CloudContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.optimization.GLResourceCache;
import qouteall.imm_ptl.core.render.optimization.SharedBlockMeshBuffers;
import qouteall.imm_ptl.core.teleportation.CollisionHelper;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class IPModMainClient {
    private static boolean fabulousWarned = false;

    public static void switchToCorrectRenderer() {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92115_ == GraphicsStatus.FABULOUS && !fabulousWarned) {
            fabulousWarned = true;
            CHelper.printChat((Component)new TranslatableComponent("imm_ptl.fabulous_warning"));
        }
        if (IrisInterface.invoker.isIrisPresent() && IrisInterface.invoker.isShaders()) {
            if (IPCGlobal.experimentalIrisPortalRenderer) {
                return;
            }
            switch (IPGlobal.renderMode) {
                case normal: {
                    IPModMainClient.switchRenderer(IrisPortalRenderer.instance);
                    break;
                }
                case compatibility: {
                    IPModMainClient.switchRenderer(IrisCompatibilityPortalRenderer.instance);
                    break;
                }
                case debug: {
                    IPModMainClient.switchRenderer(IrisCompatibilityPortalRenderer.debugModeInstance);
                    break;
                }
                case none: {
                    IPModMainClient.switchRenderer(IPCGlobal.rendererDummy);
                }
            }
            return;
        }
        switch (IPGlobal.renderMode) {
            case normal: {
                IPModMainClient.switchRenderer(IPCGlobal.rendererUsingStencil);
                break;
            }
            case compatibility: {
                IPModMainClient.switchRenderer(IPCGlobal.rendererUsingFrameBuffer);
                break;
            }
            case debug: {
                IPModMainClient.switchRenderer(IPCGlobal.rendererDebug);
                break;
            }
            case none: {
                IPModMainClient.switchRenderer(IPCGlobal.rendererDummy);
            }
        }
    }

    private static void switchRenderer(PortalRenderer renderer) {
        if (IPCGlobal.renderer != renderer) {
            Helper.log("switched to renderer " + renderer.getClass());
            IPCGlobal.renderer = renderer;
            if (IrisInterface.invoker.isShaders()) {
                IrisInterface.invoker.reloadPipelines();
            }
        }
    }

    private static void showPreviewWarning() {
        IPGlobal.clientTaskList.addTask(MyTaskList.withDelayCondition(() -> Minecraft.m_91087_().f_91073_ == null, MyTaskList.oneShotTask(() -> {
            if (IPGlobal.enableWarning) {
                Minecraft.m_91087_().f_91065_.m_93051_(ChatType.CHAT, (Component)new TranslatableComponent("imm_ptl.preview_warning").m_7220_((Component)McHelper.getLinkText("https://github.com/qouteall/ImmersivePortalsMod/issues")), UUID.randomUUID());
            }
        })));
    }

    private static void showIntelVideoCardWarning() {
        IPGlobal.clientTaskList.addTask(MyTaskList.withDelayCondition(() -> Minecraft.m_91087_().f_91073_ == null, MyTaskList.oneShotTask(() -> {
            if (GlUtil.m_84818_().toLowerCase().contains("intel")) {
                CHelper.printChat((Component)new TranslatableComponent("imm_ptl.intel_warning"));
            }
        })));
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        ClientWorldLoader.init();
        DubiousThings.init();
        CrossPortalEntityRenderer.init();
        GLResourceCache.init();
        CollisionHelper.initClient();
        PortalRenderInfo.init();
        CloudContext.init();
        SharedBlockMeshBuffers.init();
        GcMonitor.initClient();
        MinecraftForge.EVENT_BUS.register(ClientDebugCommand.class);
        MinecraftForge.EVENT_BUS.register(ClientWorldLoader.class);
        IPModMainClient.showPreviewWarning();
        IPModMainClient.showIntelVideoCardWarning();
        PortalAnimationManagement.init();
        VisibleSectionDiscovery.init();
        MyBuiltChunkStorage.init();
        IPFlywheelCompat.init();
    }
}

