/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.api.example;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.render.GuiPortalRendering;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.DQuaternion;

public class ExampleGuiPortalRendering {
    @OnlyIn(value=Dist.CLIENT)
    private static RenderTarget frameBuffer;
    private static final WeakHashMap<ServerPlayer, ChunkLoader> chunkLoaderMap;

    private static void removeChunkLoaderFor(ServerPlayer player) {
        ChunkLoader chunkLoader = chunkLoaderMap.remove(player);
        if (chunkLoader != null) {
            PortalAPI.removeChunkLoaderForPlayer(player, chunkLoader);
        }
    }

    public static void onCommandExecuted(ServerPlayer player, ServerLevel world, Vec3 pos) {
        ExampleGuiPortalRendering.removeChunkLoaderFor(player);
        ChunkLoader chunkLoader = new ChunkLoader(new DimensionalChunkPos((ResourceKey<Level>)world.m_46472_(), new ChunkPos(new BlockPos(pos))), 8);
        PortalAPI.addChunkLoaderForPlayer(player, chunkLoader);
        chunkLoaderMap.put(player, chunkLoader);
        McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.api.example.ExampleGuiPortalRendering.RemoteCallables.clientActivateExampleGuiPortal", world.m_46472_(), pos);
    }

    static {
        chunkLoaderMap = new WeakHashMap();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GuiPortalScreen
    extends Screen {
        private final ResourceKey<Level> viewingDimension;
        private final Vec3 viewingPosition;

        public GuiPortalScreen(ResourceKey<Level> viewingDimension, Vec3 viewingPosition) {
            super((Component)new TextComponent("GUI Portal Example"));
            this.viewingDimension = viewingDimension;
            this.viewingPosition = viewingPosition;
        }

        public void m_7379_() {
            super.m_7379_();
            McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.core.api.example.ExampleGuiPortalRendering.RemoteCallables.serverRemoveChunkLoader", new Object[0]);
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            super.m_6305_(matrices, mouseX, mouseY, delta);
            double t1 = CHelper.getSmoothCycles(503L);
            double t2 = CHelper.getSmoothCycles(197L);
            Matrix4f cameraTransformation = new Matrix4f();
            cameraTransformation.m_27624_();
            cameraTransformation.m_27646_(DQuaternion.rotationByDegrees(new Vec3(1.0, 1.0, 1.0).m_82541_(), t1 * 360.0).toMcQuaternion());
            Vec3 cameraPosition = this.viewingPosition.m_82549_(new Vec3(Math.cos(t2 * 2.0 * Math.PI), 0.0, Math.sin(t2 * 2.0 * Math.PI)).m_82490_(30.0));
            WorldRenderInfo worldRenderInfo = new WorldRenderInfo(ClientWorldLoader.getWorld(this.viewingDimension), cameraPosition, cameraTransformation, true, null, this.f_96541_.f_91066_.f_92106_);
            GuiPortalRendering.submitNextFrameRendering(worldRenderInfo, frameBuffer);
            int h = this.f_96541_.m_91268_().m_85442_();
            int w = this.f_96541_.m_91268_().m_85441_();
            MyRenderHelper.drawFramebuffer(frameBuffer, false, false, (float)w * 0.2f, (float)w * 0.8f, (float)h * 0.2f, (float)h * 0.8f);
            GuiPortalScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)70, (int)0xFFFFFF);
        }

        public boolean m_7043_() {
            return false;
        }
    }

    public static class RemoteCallables {
        @OnlyIn(value=Dist.CLIENT)
        public static void clientActivateExampleGuiPortal(ResourceKey<Level> dimension, Vec3 position) {
            if (frameBuffer == null) {
                frameBuffer = new TextureTarget(100, 100, true, true);
            }
            Minecraft.m_91087_().m_91152_((Screen)new GuiPortalScreen(dimension, position));
        }

        public static void serverRemoveChunkLoader(ServerPlayer player) {
            ExampleGuiPortalRendering.removeChunkLoaderFor(player);
        }
    }
}

