/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.block_manipulation;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockBreakAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class BlockManipulationServer {
    public static void processBreakBlock(ResourceKey<Level> dimension, ServerboundPlayerActionPacket packet, ServerPlayer player) {
        if (BlockManipulationServer.shouldFinishMining(dimension, packet, player)) {
            if (BlockManipulationServer.canPlayerReach(dimension, player, packet.m_134281_())) {
                BlockManipulationServer.doDestroyBlock(dimension, packet, player);
            } else {
                Helper.log("Rejected cross portal block breaking packet " + player);
            }
        }
    }

    private static boolean shouldFinishMining(ResourceKey<Level> dimension, ServerboundPlayerActionPacket packet, ServerPlayer player) {
        if (packet.m_134285_() == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            return BlockManipulationServer.canInstantMine(MiscHelper.getServer().m_129880_(dimension), player, packet.m_134281_());
        }
        return packet.m_134285_() == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK;
    }

    private static boolean canPlayerReach(ResourceKey<Level> dimension, ServerPlayer player, BlockPos requestPos) {
        Float playerScale = Float.valueOf(PehkuiInterface.invoker.computeBlockReachScale((Entity)player));
        Vec3 pos = Vec3.m_82512_((Vec3i)requestPos);
        Vec3 playerPos = player.m_20182_();
        double distanceSquare = 576.0f * playerScale.floatValue() * playerScale.floatValue();
        if (player.f_19853_.m_46472_() == dimension && playerPos.m_82557_(pos) < distanceSquare) {
            return true;
        }
        return IPMcHelper.getNearbyPortals((Entity)player, 20.0).anyMatch(portal -> portal.dimensionTo == dimension && portal.transformPoint(playerPos).m_82557_(pos) < distanceSquare * portal.getScale() * portal.getScale());
    }

    private static void doDestroyBlock(ResourceKey<Level> dimension, ServerboundPlayerActionPacket packet, ServerPlayer player) {
        ServerLevel destWorld = MiscHelper.getServer().m_129880_(dimension);
        ServerLevel oldWorld = player.m_183503_();
        BlockPos blockPos = packet.m_134281_();
        if (destWorld.m_7966_((Player)player, blockPos)) {
            player.f_8941_.m_9260_(destWorld);
            player.f_8941_.m_9280_(blockPos);
            player.f_8941_.m_9260_(oldWorld);
        } else {
            ClientboundBlockBreakAckPacket ackPacket = new ClientboundBlockBreakAckPacket(blockPos, destWorld.m_8055_(blockPos), packet.m_134285_(), false, "may not interact");
            player.f_8906_.m_141995_(PacketRedirection.createRedirectedMessage(dimension, (Packet<ClientGamePacketListener>)ackPacket));
        }
    }

    private static boolean canInstantMine(ServerLevel world, ServerPlayer player, BlockPos pos) {
        if (player.m_7500_()) {
            return true;
        }
        float progress = 1.0f;
        BlockState blockState = world.m_8055_(pos);
        if (!blockState.m_60795_()) {
            blockState.m_60686_((Level)world, pos, (Player)player);
            progress = blockState.m_60625_((Player)player, (BlockGetter)world, pos);
        }
        return !blockState.m_60795_() && progress >= 1.0f;
    }

    public static Tuple<BlockHitResult, ResourceKey<Level>> getHitResultForPlacing(Level world, BlockHitResult blockHitResult) {
        Direction side = blockHitResult.m_82434_();
        Vec3 sideVec = Vec3.m_82528_((Vec3i)side.m_122436_());
        Vec3 hitCenter = Vec3.m_82512_((Vec3i)blockHitResult.m_82425_());
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        Portal portal = globalPortals.stream().filter(p -> p.getNormal().m_82526_(sideVec) < -0.9 && p.isPointInPortalProjection(hitCenter) && p.getDistanceToPlane(hitCenter) < 0.6).findFirst().orElse(null);
        if (portal == null) {
            return new Tuple((Object)blockHitResult, (Object)world.m_46472_());
        }
        Vec3 newCenter = portal.transformPoint(hitCenter.m_82549_(sideVec.m_82490_(0.501)));
        BlockPos placingBlockPos = new BlockPos(newCenter);
        BlockHitResult newHitResult = new BlockHitResult(Vec3.f_82478_, side.m_122424_(), placingBlockPos, blockHitResult.m_82436_());
        return new Tuple((Object)newHitResult, portal.dimensionTo);
    }

    public static void processRightClickBlock(ResourceKey<Level> dimension, ServerboundUseItemOnPacket packet, ServerPlayer player) {
        InteractionHand hand = packet.m_134703_();
        BlockHitResult blockHitResult = packet.m_134706_();
        ServerLevel world = MiscHelper.getServer().m_129880_(dimension);
        BlockManipulationServer.doProcessRightClick(dimension, player, hand, blockHitResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProcessRightClick(ResourceKey<Level> dimension, ServerPlayer player, InteractionHand hand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        MinecraftServer server = MiscHelper.getServer();
        ServerLevel targetWorld = server.m_129880_(dimension);
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        player.m_9243_();
        if (targetWorld.m_7966_((Player)player, blockPos)) {
            if (!BlockManipulationServer.canPlayerReach(dimension, player, blockPos)) {
                Helper.log("Reject cross portal block placing packet " + player);
                return;
            }
            Level oldWorld = player.f_19853_;
            player.f_19853_ = targetWorld;
            try {
                InteractionResult actionResult = player.f_8941_.m_7179_(player, (Level)targetWorld, itemStack, hand, blockHitResult);
                if (actionResult.m_19080_()) {
                    player.m_21011_(hand, true);
                }
            }
            finally {
                player.f_19853_ = oldWorld;
            }
        }
        PacketRedirection.sendRedirectedMessage(player, dimension, (Packet)new ClientboundBlockUpdatePacket((BlockGetter)targetWorld, blockPos));
        BlockPos offseted = blockPos.m_142300_(direction);
        if (offseted.m_123342_() >= targetWorld.m_141937_() && offseted.m_123342_() < targetWorld.m_151558_()) {
            PacketRedirection.sendRedirectedMessage(player, dimension, (Packet)new ClientboundBlockUpdatePacket((BlockGetter)targetWorld, offseted));
        }
    }
}

