/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class IPModCompatibilityWarning {
    private static final List<ModInfo> incompatibleMods = Lists.newArrayList((Object[])new ModInfo[]{new ModInfo("mcxr-core", "MCXR"), new ModInfo("taterzens", "Taterzens"), new ModInfo("altoclef", "Altoclef"), new ModInfo("tweakeroo", "Tweakeroo"), new ModInfo("replaymod", "Replay Mod"), new ModInfo("twilightforest", "Twilight Forest"), new ModInfo("c2me", "C2ME"), new ModInfo("sereneseasons", "Serene Seasons")});
    private static final List<ModInfo> maybeIncompatibleMods = Lists.newArrayList((Object[])new ModInfo[]{new ModInfo("physicsmod", "Physics Mod"), new ModInfo("cameraoverhaul", "Camera Overhaul"), new ModInfo("figura", "Figura"), new ModInfo("dimthread", "Dimensional Threading"), new ModInfo("requiem", "Requiem"), new ModInfo("vmp", "VMP"), new ModInfo("modern_industrialization", "Modern Industrialization"), new ModInfo("create", "Create")});

    public static void initDedicatedServer() {
        for (ModInfo mod : incompatibleMods) {
            if (!ModList.get().isLoaded(mod.modId)) continue;
            Helper.err(String.format("WARNING: This mod is incompatible with Immersive Portals: %s(%s)", mod.modName, mod.modId));
        }
        for (ModInfo mod : maybeIncompatibleMods) {
            if (!ModList.get().isLoaded(mod.modId)) continue;
            Helper.err(String.format("WARNING: This mod is maybe incompatible with Immersive Portals: %s(%s)", mod.modName, mod.modId));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        for (ModInfo mod : incompatibleMods) {
            if (!ModList.get().isLoaded(mod.modId)) continue;
            IPGlobal.clientTaskList.addTask(MyTaskList.withDelayCondition(() -> Minecraft.m_91087_().f_91073_ == null, MyTaskList.oneShotTask(() -> CHelper.printChat((Component)new TextComponent(String.format("WARNING: Immersive Portals mod is incompatible with mod %s(%s) . Major issues will occur. You should uninstall one of the two mods. (If the two mods become compatible now, report it to qouteall.)", mod.modName, mod.modId)).m_130940_(ChatFormatting.RED)))));
        }
        for (ModInfo mod : maybeIncompatibleMods) {
            if (!ModList.get().isLoaded(mod.modId)) continue;
            IPGlobal.clientTaskList.addTask(MyTaskList.withDelayCondition(() -> Minecraft.m_91087_().f_91073_ == null, MyTaskList.oneShotTask(() -> {
                String warningMessage = String.format("WARNING: Immersive Portals mod maybe has compatibility issues with mod %s(%s).", mod.modName, mod.modId);
                if (IPGlobal.enableWarning) {
                    CHelper.printChat((Component)new TextComponent(warningMessage).m_130940_(ChatFormatting.RED).m_7220_(IPMcHelper.getDisableWarningText()));
                }
                Helper.err(warningMessage);
            })));
        }
        IPGlobal.clientTaskList.addTask(MyTaskList.withDelayCondition(() -> Minecraft.m_91087_().f_91073_ == null, MyTaskList.oneShotTask(() -> {})));
    }

    public record ModInfo(String modId, String modName) {
    }
}

